﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="LessonTable_Month.aspx.cs"
    Inherits="SWTraining.Class.LessonTable_Month" Title="教务管理-课程总表(月)" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">

        var arrIndexs = new Array();
        var i = 0;

        function getElementsByClassName(n) {
            var classElements = [], allElements = document.getElementsByTagName('*');
            for (var i = 0; i < allElements.length; i++) {
                if (allElements[i].className == n) {
                    classElements[classElements.length] = allElements[i];
                }
            }
            return classElements;
        }

        function ClassName(className, state, color) {
            if (state == 1) {
                var redClassElements = getElementsByClassName(className);
                for (var i = 0; i < redClassElements.length; i++) {
                    redClassElements[i].style.backgroundColor = color;
                }
            } else {
                var redClassElements = getElementsByClassName(className);
                for (var i = 0; i < redClassElements.length; i++) {
                    redClassElements[i].style.backgroundColor = color;
                }
            }
        }

        function OnClick(index, color) {
            var redClassElements = getElementsByClassName('mt_bg_' + index);
            for (var i = 0; i < redClassElements.length; i++) {
                redClassElements[i].style.backgroundColor = color;
                redClassElements[i].onmouseout = "";
            }
        }

        function Selected(indexs) {
            if (indexs != "0") {
                var index = indexs.split('_')[0];
                var color = indexs.split('_')[1];
                OnClick(index, color);

                arrIndexs[i] = index;
                i++;
            }
            else {
                for (i = 0; i < arrIndexs.length; i++) {
                    var index = arrIndexs[i];
                    ClassName('mt_bg_' + index, 0, '#ffffff');
                }
            }
        }

        //        function ColorMode(type) {
        //            if (type == 1) {
        //                for (i = 0; i < arrColors.length; i++) {
        //                    var color = arrColors[i];
        //                    OnClick(i + 1, color);
        //                }
        //            }
        //            if (type == 0) {
        //                for (i = 0; i < arrColors.length; i++) {
        //                    var color = arrColors[i];
        //                    ClassName('mt_bg_' + (i + 1), 0, '#ffffff');
        //                }
        //            }
        //        }

        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "cbxName") {
                    e.checked = checkbox.checked;
                }
            }
        }

        function Hide() {
            var StudentID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "cbxName") {
                    if (e.checked) {
                        document.getElementById("GridView1").rows[e.value].style.display = "none";
                    }
                }
            }
        }
    </script>
    <style type="text/css">
        .gridview th
        {
            text-align: center;
        }
        .gridview td
        {
            border-right-width: 1px;
        }
        
        .colorCode
        {
            background-color: White;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
    <div class="tool_ControlPanel">
        <table cellpadding="0" cellspacing="0">
            <tr>
                <td>
                    <input onclick="Checks(this)" type="checkbox" />
                </td>
                <td>
                    全选
                </td>
                <td>
                    <label class="lab_buttom">
                        <input id="Button1" type="button" value="隐藏" onclick="Hide();" /></label>
                </td>
                <td>
                    校区：
                </td>
                <td>
                    <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                    </asp:DropDownList>
                    分组：<asp:DropDownList ID="ddlSortType" runat="server">
                        <asp:ListItem Value="0">教室</asp:ListItem>
                        <asp:ListItem Value="1">老师</asp:ListItem>
                        <asp:ListItem Value="2">班级</asp:ListItem>
                    </asp:DropDownList>
                </td>
                <td>
                    日期：
                </td>
                <td>
                    <asp:TextBox ID="tbxDateAndTime" runat="server" Width="100px"></asp:TextBox>
                </td>
                <td>
                    <label class="lab_buttom">
                        <asp:Button ID="btnShow" runat="server" OnClick="btnShow_Click" Text="查看" />
                    </label>
                    <label class="lab_buttom">
                        <asp:Button ID="btnUp" runat="server" OnClick="btnUp_Click" Text="上月" />
                    </label>
                    <label class="lab_buttom">
                        <asp:Button ID="btnDown" runat="server" OnClick="btnDown_Click" Text="下月" />
                    </label>
                    <label class="lab_buttom">
                        <asp:Button ID="btnExportExcel" runat="server" OnClick="btnExportExcel_Click" Text="导出EXCEL" />
                    </label>
                </td>
            </tr>
        </table>
    </div>
    <div class="both">
    </div>
    <div class="divpanel" style="overflow: auto; padding-bottom: 40px">
        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="false" CssClass="gridview"
            OnRowDataBound="GridView1_RowDataBound" EnableViewState="False">
        </asp:GridView>
    </div>
    <div class="divpanel">
        <b>色标说明：</b><br />
        <br />
        <div style="width: 600px; height: auto; overflow: auto; border: 1px solid #cccccc;">
            <asp:GridView ID="GridView2" runat="server" EnableModelValidation="True" EnableViewState="False"
                CssClass="colorCode" AutoGenerateColumns="False" Width="100%" HeaderStyle-HorizontalAlign="Left">
                <Columns>
                    <asp:TemplateField HeaderText="色标">
                        <ItemTemplate>
                            <div onclick="<%# string.Format("Selected('{0}_{1}')",Eval("ClassIndex"),GetClassColor((int)Eval("ClassIndex"))) %>"
                                style="<%# string.Format("background-color:{0}; width: 20px;height: 20px; border: 1px solid #cccccc; text-align: center; margin-left: auto; cursor:pointer;margin-right: auto;; vertical-align:middle; line-height:20px",GetClassColor((int)Eval("ClassIndex"))) %>">
                                <%#Eval("ClassIndex") %></div>
                        </ItemTemplate>
                        <HeaderStyle HorizontalAlign="Center" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="ClassID" HeaderText="班号">
                        <HeaderStyle HorizontalAlign="Left" />
                    </asp:BoundField>
                    <asp:BoundField DataField="ClassName" HeaderText="班名">
                        <HeaderStyle HorizontalAlign="Left" />
                    </asp:BoundField>
                    <asp:BoundField DataField="TeacherName" HeaderText="老师">
                        <HeaderStyle HorizontalAlign="Left" />
                    </asp:BoundField>
                </Columns>
                <HeaderStyle HorizontalAlign="Left" />
            </asp:GridView>
        </div>
    </div>
    <div class="divremark">
        <b>注意事项：</b><br />
        1、标题数字红色表示周末，蓝色表示当前日期。<br />
        2、内容方框内数字红色表示课程时间有冲突。
        <br />
        3、内容方框内左上角显示绿色表示已上完课。
    </div>
    </form>
</body>
</html>
