﻿<%@ Import Namespace="SWTraining" %>

<%@ Page Language="c#" CodeBehind="Classroom.aspx.cs" AutoEventWireup="True" Inherits="SWTraining.Class.Classroom"
    Title="教务管理-教室设置" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="tool_Search">
        教室名称：
        <asp:TextBox ID="tbxClassroomName" runat="server"></asp:TextBox>
        容纳人数：
        <asp:TextBox ID="tbxSeating" runat="server" Width="47px"></asp:TextBox>
        校区：
        <asp:DropDownList ID="ddlSchool" runat="server" DataSource="<%# swq.Cache.GetSchool() %>"
            DataValueField="SchoolID" DataTextField="SchoolName">
        </asp:DropDownList>
        <label class="lab_buttom">
<asp:Button ID="btnGo" runat="server" Text="转到" OnClick="btnGo_Click"></asp:Button>
</label>
        <label class="lab_buttom">
<asp:Button ID="btnAdd" runat="server" Text="增加" OnClick="btnAdd_Click"></asp:Button>
</label>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="ClassroomID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowCommand="GridView1_RowCommand"
            OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" OnRowCreated="GridView1_RowCreated"
            OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:BoundField DataField="ClassroomID" ReadOnly="True" HeaderText="教室编号" />
                <asp:BoundField DataField="ClassroomName" HeaderText="教室名称" />
                <asp:BoundField DataField="Seating" HeaderText="容纳人数" />
                <asp:TemplateField HeaderText="状态">
                    <ItemTemplate>
                        <%# Rs.Items.GetLockState((int)Eval("LockState"))%>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList runat="server" ID="ddlLockState" SelectedIndex='<%# Eval("LockState") %>'>
                            <asp:ListItem Value="0" Text="禁用"></asp:ListItem>
                            <asp:ListItem Value="1" Text="启用"></asp:ListItem>
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="校区">
                    <ItemTemplate>
                        <%# Eval("SchoolName") %>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList ID="ddlSchool" runat="server" DataSource="<%# swq.Cache.GetSchool() %>"
                            SelectedValue='<%# Eval("SchoolID") %>' DataValueField="SchoolID" DataTextField="SchoolName">
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="排序">
                    <ItemTemplate>
                        <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" Text="↑"></asp:LinkButton>
                        <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" Text="↓"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消" UpdateText="更新" ShowEditButton="true" />
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="divpanel">
        <b>注意事项：</b><br />
        1、注意教室不是班级，有几间教室您就设置几间。<br />
    </div>
    </form>
</body>
</html>
