﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="TimeConflict.aspx.cs" Inherits="SWTraining.Affairs.TimeConflict"
    Title="教务管理-学员排课冲突检测" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" DataKeyNames="LessonDegreeID"
            AutoGenerateColumns="false" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:TemplateField HeaderText="状态">
                    <ItemTemplate>
                        <asp:ImageButton runat="server" Enabled="false" ID="ibnLeStateID" ImageUrl='<%#String.Format(accTheme("lesson_{0}.gif"),Eval("LeStateID"))%>'
                            ToolTip='<%# (int)Eval("LeStateID") == 0 ? "未上课": "已上课"%>' CommandName="LeStateID"
                            CommandArgument='<%#Eval("LeStateID")%>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="Subject" ReadOnly="True" HeaderText="课题" />
                <asp:TemplateField HeaderText="上课日期">
                    <ItemTemplate>
                        <span runat="server" id="spanDate">
                            <%#Eval("StartDate","{0:d}")%></span><span style="color: Red; font-size: 9px">[<%#((DateTime)Eval("StartDate")).DayOfWeek.ToString("d")%>]</span>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="上课时段">
                    <ItemTemplate>
                        <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),swq.Tools.EndDate(Eval("EndDate")))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="ClassroomName" ReadOnly="True" HeaderText="教室" />
                <asp:BoundField DataField="TeacherName" ReadOnly="True" HeaderText="讲师" />
                <asp:BoundField DataField="ClassID" ReadOnly="True" HeaderText="班号" />
                <asp:BoundField DataField="ClassName" ReadOnly="True" HeaderText="班级名称" />
                <asp:TemplateField HeaderText="上课类型">
                    <ItemTemplate>
                        <%# Rs.Items.GetLessonType(Eval("LessonType"))%>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    </form>
</body>
</html>
