﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="DelStudent.aspx.cs" Inherits="SWTraining.Admin_Tools.DelStudent" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="../UserCol/Progress.ascx" TagName="progress" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>管理员工具-删除学员</title>
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
            <script type="text/javascript">
                function StudentBox() {
                    window.showModalDialog('../Tools/StudentBox.aspx', window, 'dialogWidth=750px;dialogHeight=500px');
                }
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="tool_Search">
        学号：<asp:TextBox ID="tbxStudentID" runat="server"></asp:TextBox>
        <label class="lab_buttom">
<asp:Button ID="btnShow" runat="server" OnClick="btnShow_Click" Text="展开" />
</label>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <table cellpadding="0" cellspacing="0" class="table">
            <tr>
                <th>
                    基本信息
                </th>
            </tr>
            <tr>
                <td>
                    <asp:GridView ID="gdvStudent" runat="server" CssClass="subgridview" AutoGenerateColumns="False"
                        DataKeyNames="StudentID" OnRowDeleting="gdvStudent_RowDeleting" OnRowDataBound="gdv_RowDataBound">
                        <Columns>
                            <asp:TemplateField HeaderText="学号">
                                <ItemTemplate>
                                    <%# Eval("StudentID") %>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="学员">
                                <ItemTemplate>
                                    <%# ShowStudent(Eval("StudentName"), Eval("Byname"), Eval("Sex"), Eval("StudentType"), Eval("SignInID"), Eval("MobileTel"), Eval("SignInSMS"), Eval("FingerState"), Eval("FingerCode"), Eval("LastAppLoginTime"))%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="DateAndTime" DataFormatString="{0:d}" HeaderText="报名日期" />
                            <asp:TemplateField HeaderText="校区">
                                <ItemTemplate>
                                    <%#Eval("SchoolName")%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="删除" SortExpression="delete">
                                <ItemTemplate>
                                    <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("UserID")%>'
                                        OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
                </td>
            </tr>
            <tr>
                <th>
                    帐户信息
                </th>
            </tr>
            <tr>
                <td>
                    <asp:GridView ID="gdvPayment" runat="server" AutoGenerateColumns="False" CssClass="subgridview"
                        DataKeyNames="PaymentID" OnRowDataBound="gdv_RowDataBound" OnRowDeleting="gdvPayment_RowDeleting">
                        <Columns>
                            <asp:BoundField DataField="PaymentID" HeaderText="编号" ReadOnly="true" />
                            <asp:TemplateField HeaderText="类型">
                                <ItemTemplate>
                                    <asp:Label ID="labPaymentType" runat="server" Text='<%#Eval("PaymentTypeName") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="金额">
                                <ItemTemplate>
                                    <asp:Label ID="labPayMoney" runat="server" Text='<%# Bind("PayMoney", "{0:c2}") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="收款方式">
                                <ItemTemplate>
                                    <asp:Label ID="labPayMethod" runat="server" Text='<%# Bind("PayMethod") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="日期">
                                <ItemTemplate>
                                    <asp:Label ID="labDateAndTime" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="备注">
                                <ItemTemplate>
                                    <asp:Label ID="labRemark" runat="server" Text='<%# Bind("Remark") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="借款到期">
                                <ItemTemplate>
                                    <asp:Label ID="labCreditExpiration" runat="server" Text='<%# Bind("CreditExpiration") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="办理点">
                                <ItemTemplate>
                                    <asp:Label ID="labPostSchoolName" runat="server" Text='<%# Bind("PostSchoolName") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="收费文员">
                                <ItemTemplate>
                                    <asp:Label ID="labTrueName" runat="server" Text='<%# Bind("TrueName") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="删除">
                                <ItemTemplate>
                                    <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
                </td>
            </tr>
            <tr>
                <th>
                    消费单
                </th>
            </tr>
            <tr>
                <td>
                    <asp:GridView ID="gdvBill" runat="server" CssClass="subgridview" AutoGenerateColumns="False"
                        DataKeyNames="BillID" OnRowDataBound="gdv_RowDataBound" OnRowDeleting="gdvBill_RowDeleting">
                        <SelectedRowStyle CssClass="selected" />
                        <Columns>
                            <asp:TemplateField InsertVisible="False" HeaderText="单号" SortExpression="BillID">
                                <ItemTemplate>
                                    <%# Eval("BillID") %>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="日期">
                                <ItemTemplate>
                                    <asp:Label ID="labDateAndTime0" runat="server" Text='<%#Eval("DateAndTime")%>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="类型">
                                <ItemTemplate>
                                    <asp:Label ID="labBillTypeID" runat="server" Text='<%#(int)Eval("BillTypeID") == 1 ? "购买" : "退货"%>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="应交金额">
                                <ItemTemplate>
                                    <asp:Label ID="labPay" runat="server" Text='<%# Eval("Pay","{0:c2}") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="优惠">
                                <ItemTemplate>
                                    <asp:Label ID="labFavourable" runat="server" Text='<%# Eval("Favourable","{0:c2}") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="实收金额">
                                <ItemTemplate>
                                    <asp:Label ID="labPayed" runat="server" Text='<%# Eval("Payed","{0:c2}") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="备注">
                                <ItemTemplate>
                                    <asp:Literal runat="server" ID="litRemark" Text='<%# Eval("Remark") %>' Mode="Encode"></asp:Literal>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="PostSchoolName" HeaderText="交费点" ReadOnly="true" />
                            <asp:TemplateField HeaderText="录入员">
                                <ItemTemplate>
                                    <%#Eval("TrueName")%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="删除">
                                <ItemTemplate>
                                    <asp:LinkButton ID="lbnDelete2" runat="server" Text="删除" CommandArgument='<%#Eval("UserID")%>'
                                        CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
                </td>
            </tr>
            <tr>
                <th>
                    学员选班
                </th>
            </tr>
            <tr>
                <td>
                    <asp:GridView ID="gdvStuClass" runat="server" CssClass="subgridview" AutoGenerateColumns="False"
                        DataKeyNames="StuClassID" OnRowDeleting="gdvStuClass_RowDeleting" OnRowDataBound="gdv_RowDataBound">
                        <SelectedRowStyle CssClass="selected" />
                        <Columns>
                            <asp:TemplateField HeaderText="选班号">
                                <ItemTemplate>
                                    <%#Eval("StuClassID")%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="班号">
                                <ItemTemplate>
                                    <%#Eval("ClassID")%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="班级名称">
                                <ItemTemplate>
                                    <%#Eval("ClassName")%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="上课地点">
                                <ItemTemplate>
                                    <%#Eval("SchoolName")%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="DateAndTime" ReadOnly="True" HeaderText="选班日期" />
                            <asp:TemplateField HeaderText="选班状态">
                                <ItemTemplate>
                                    <%#Rs.Items.GetScState(Eval("ScStateID"))%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="类型">
                                <ItemTemplate>
                                    <%#Rs.Items.GetStuClassType(Eval("ContinueReg"))%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="课时进度">
                                <ItemTemplate>
                                    <uc1:progress ID="Progress1" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>'
                                        ProgressWidth="65%" />
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="PostSchoolName" ReadOnly="True" HeaderText="报名点" />
                            <asp:TemplateField HeaderText="删除">
                                <ItemTemplate>
                                    <asp:LinkButton ID="lbnDelete1" runat="server" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("UserID")%>'
                                        OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
                </td>
            </tr>
            <tr>
                <th>
                    学员异动
                </th>
            </tr>
            <tr>
                <td>
                    <asp:GridView ID="gdvChange" runat="server" CssClass="subgridview" AutoGenerateColumns="False"
                        DataKeyNames="ChangeID" OnRowDataBound="gdv_RowDataBound" OnRowDeleting="gdvChange_RowDeleting">
                        <Columns>
                            <asp:BoundField DataField="StudentID" ReadOnly="true" HeaderText="学号" />
                            <asp:TemplateField HeaderText="学员">
                                <ItemTemplate>
                                    <%#Eval("StudentName")%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="类型">
                                <ItemTemplate>
                                    <%#Rs.Items.GetScState(Eval("ChangeType"))%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="班级名称">
                                <ItemTemplate>
                                    <%#Eval("ClassName")%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="DateAndTime" ReadOnly="true" DataFormatString="{0:d}"
                                HeaderText="办理时间" />
                            <asp:BoundField DataField="GetDateTime" ReadOnly="true" DataFormatString="{0:d}"
                                HeaderText="延期" />
                            <asp:BoundField DataField="NewStuClassID" ReadOnly="true" DataFormatString="{0:d}"
                                HeaderText="新班号" />
                            <asp:TemplateField HeaderText="详情及原因">
                                <ItemTemplate>
                                    <%#swq.Tools.StrLen(Eval("Remark").ToString(),8)%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="TrueName" ReadOnly="true" HeaderText="录入员" />
                            <asp:TemplateField HeaderText="删除">
                                <ItemTemplate>
                                    <asp:LinkButton ID="lbnDelete3" runat="server" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("UserID")%>'
                                        OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
                </td>
            </tr>
            <tr>
                <th>
                    学员考勤
                </th>
            </tr>
            <tr>
                <td>
                    <asp:GridView ID="gdvAttend" runat="server" CssClass="subgridview" DataKeyNames="AttendID"
                        AutoGenerateColumns="false" OnRowDataBound="gdv_RowDataBound" OnRowDeleting="gdvAttend_RowDeleting">
                        <Columns>
                            <asp:BoundField DataField="Subject" ReadOnly="True" HeaderText="课题" />
                            <asp:TemplateField HeaderText="上课日期">
                                <ItemTemplate>
                                    <span runat="server" id="spanDate">
                                        <%#Eval("StartDate","{0:d}")%></span><span style="color: Red; font-size: 9px">[<%#((DateTime)Eval("StartDate")).DayOfWeek.ToString("d")%>]</span>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="上课时段">
                                <ItemTemplate>
                                    <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),swq.Tools.EndDate(Eval("EndDate")))%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="出勤状态">
                                <ItemTemplate>
                                    <%# Rs.Items.GetAtState(Eval("AtStateID"))%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="ClassName" ReadOnly="True" HeaderText="班级名称" />
                            <asp:BoundField DataField="Lessons" ReadOnly="True" HeaderText="课时" />
                            <asp:BoundField DataField="Remark" ReadOnly="True" HeaderText="备注" HtmlEncode="true" />
                            <asp:TemplateField HeaderText="删除">
                                <ItemTemplate>
                                    <asp:LinkButton ID="lbnDelete4" runat="server" Text="删除" CommandName="delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
                </td>
            </tr>
        </table>
    </div>
    <div class="divremark">
        <b>注意事项：</b><br />
        1、从下至上逐步删除即可。<br />
    </div>
    </form>
</body>
</html>
