//==============================================================================
// Scn35p5: AI Scenario Script for scenario 35 player 5
//==============================================================================
/*
   AI owner:  Dave Leary
   Scenario owner: Joe "the Golem" Gillum

	Handles the forward forces of Gargarensis in the finale.  Creates defend plans 
	for three forward positions, and attacks the player with two different groups, 
	hypaspists and catapults, and hippikons (all upgraded).  Basically a delaying 
	action AI who fights until the player makes enough progress	to turn on the 
	rearguard AI (scn35p2).  Includes two heroes in the mix (Theseus and Hippolyta)

   Gargarensis' scary god power actions are handled by scenario triggers.

   Some minor diff level changes for this AI - cavalry attacks do not come on Easy.
*/
//==============================================================================
// Set Town Location.
//==============================================================================
void setTownLocation(void)
{
   //Look for the "Town Location" marker.
   kbSetTownLocation(kbGetBlockPosition("2447"));
}

//==============================================================================
// miscStartup.
//==============================================================================
void miscStartup(void)
{
	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

   //Startup message(s).
   aiEcho("");
   aiEcho("");
   aiEcho("Scn35P5 AI Start, filename='"+cFilename+"'.");
	aiEcho("Difficulty Level="+difflevel+".");
   //Spit out the map size.
   aiEcho("  Map size is ("+kbGetMapXSize()+", "+kbGetMapZSize()+").");
   //Cheat like a bastard.  Once only, though.
   kbLookAtAllUnitsOnMap();
   //Calculate some areas.
   kbAreaCalculate(1200.0);
   //Set our town location.
   setTownLocation();
	//Reset random seed
	aiRandSetSeed();
   
	//Allocate all resources to the root escrow by setting percentage of military/economy to 0.
	kbEscrowSetPercentage( cEconomyEscrowID, cAllResources, 0.0 );
	kbEscrowSetPercentage( cMilitaryEscrowID, cAllResources, 0.0 );

	//Allocate all resources 
   kbEscrowAllocateCurrentResources();
}

//==============================================================================
//==============================================================================
// Attack stuff
//==============================================================================
//==============================================================================
//Shared variables.
int numberAttacks=0;
int attackPlayerID=-1;

//TODO: Decide how to rep attack group size.
int attackMinimumGroupSize=6;
int attackMaximumGroupSize=12;

//Attack vars.
int attackPlan1ID=-1;
int attackPlan2ID=-1;

// Unit types.
int attackerUnitTypeID1=cUnitTypeHoplite;
int attackerUnitTypeID2=cUnitTypeHippikon;
int attackerUnitTypeID3=cUnitTypeToxotes;
int attackerUnitTypeID4=cUnitTypeHypaspist;
int attackerUnitTypeID5=cUnitTypePeltast;

int attackerSiegeTypeID1=cUnitTypePetrobolos;
int attackerSiegeTypeID2=cUnitTypeHelepolis;

int attackerMythTypeID1=cUnitTypeCyclops;
int attackerMythTypeID2=cUnitTypeNemeanLion;
int attackerMythTypeID3=cUnitTypeColossus;

int attackerHeroTypeID1=cUnitTypeHeroGreekTheseus;
int attackerHeroTypeID2=cUnitTypeHeroGreekHippolyta;

// Maintain Plans
int maintainPlan1ID=-1;
int maintainPlan2ID=-1;
int maintainPlan3ID=-1;
int maintainPlan4ID=-1;
int maintainPlan5ID=-1;

int maintainSiege1ID=-1;

int maintainMythPlan1ID=-1;
int maintainMythPlan2ID=-1;

int maintainHeroPlan1ID=-1;
int maintainHeroPlan2ID=-1;

// Defend Plans
int defendPlan1ID=-1;
int defendPlan2ID=-1;
int defendPlan3ID=-1;

// Route and path vars
int attackRoute1ID=-1;
int attackPath1ID=-1;
int attackRoute2ID=-1;
int attackPath2ID=-1;

//=========================================================================================
// Kidd's cool configQuery function: used to create attack routes, etc.  Oooh, lovin' that!
//=========================================================================================
bool configQuery( int queryID = -1, int unitType = -1, int action = -1, int state = -1, int player = -1, vector center = vector(-1,-1,-1), bool sort = false, float radius = -1 )
{
   if ( queryID == -1)
   {
      return(false);
   }

   if (player != -1)
      kbUnitQuerySetPlayerID(queryID, player);
   
   if (unitType != -1)
      kbUnitQuerySetUnitType(queryID, unitType);

   if (action != -1)
      kbUnitQuerySetActionType(queryID, action);

   if (state != -1)
      kbUnitQuerySetState(queryID, state);

   if (center != vector(-1,-1,-1))
   {
      kbUnitQuerySetPosition(queryID, center);
      if (sort == true)
         kbUnitQuerySetAscendingSort(queryID, true);
      if (radius != -1)
         kbUnitQuerySetMaximumDistance(queryID, radius);
   }
   return(true);
}

//==============================================================================
// initAttack: Creates attack routes, etc.
//==============================================================================
void initAttack(int playerID=-1)
{
   //Destroy all previous attacks (if this isn't the player we're already attacking.
   if (playerID != attackPlayerID)
   {
      //Reset the attack player ID.
      attackPlayerID=-1;
      //Destroy any previous attack plan.
      aiPlanDestroy(attackPlan1ID);
      attackPlan1ID=-1;
      aiPlanDestroy(attackPlan2ID);
      attackPlan2ID=-1;
  
      //Destroy our previous attack paths.
      kbPathDestroy(attackPath1ID);
      attackPath1ID=-1;
      kbPathDestroy(attackPath2ID);
      attackPath2ID=-1;

      //Destroy our previous attack routes.
      attackRoute1ID=-1;
      attackRoute2ID=-1;

      //Reset the number of attacks.
      numberAttacks=0;
   }

   //Save the player to attack
   attackPlayerID=playerID;

   vector gatherPoint=kbGetBlockPosition("2445");
	vector gatherPointWest=kbGetBlockPosition("2452");
	   
	//Setup attack path 1 - go east
   attackPath1ID=kbPathCreate("Attack Path 1");
   kbPathAddWaypoint(attackPath1ID, kbGetBlockPosition("2449"));
   //Create attack route 1.
   attackRoute1ID=kbCreateAttackRouteWithPath("Attack Route 1", gatherPoint, kbGetBlockPosition("2462"));
   
	
	if (attackRoute1ID >= 0)
      kbAttackRouteAddPath(attackRoute1ID, attackPath1ID);

   //Setup attack path 2 - go west 
   attackPath2ID=kbPathCreate("Attack Path 2");
	kbPathAddWaypoint(attackPath2ID, kbGetBlockPosition("2453"));
	kbPathAddWaypoint(attackPath2ID, kbGetBlockPosition("2454"));
   //Create attack route 2.
   attackRoute2ID=kbCreateAttackRouteWithPath("Attack Route 2", gatherPointWest, kbGetBlockPosition("2521"));
   
	if (attackRoute2ID >= 0)
      kbAttackRouteAddPath(attackRoute2ID, attackPath2ID);

}

//==============================================================================
// setupAttack
//==============================================================================
bool setupAttack(int playerID=-1)
{
	// int randomPath=aiRandInt(2);
	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

	//Info.
	aiEcho("Attacking Player "+playerID+".");

   //If the player to attack doesn't match, init the attack.
   if (attackPlayerID != playerID)
   {
      initAttack(playerID);
      if (attackPlayerID < 0)
         return(false);
   }

   //Create an attack plan.
   int newAttackPlanID=aiPlanCreate("Attack Player"+attackPlayerID+" Attempt"+numberAttacks, cPlanAttack);
   if (newAttackPlanID < 0)
      return(false);

   //Target player (required).  This must work.
   if (aiPlanSetVariableInt(newAttackPlanID, cAttackPlanPlayerID, 0, attackPlayerID) == false)
      return(false);

   //Gather points.
	vector gatherPoint=kbGetBlockPosition("2445");
	

	//Set the target type.  This must work.
   if (aiPlanSetNumberVariableValues(newAttackPlanID, cAttackPlanTargetTypeID, 2, true) == false)
      return(false);

   //Unit types to attack.
   aiPlanSetVariableInt(newAttackPlanID, cAttackPlanTargetTypeID, 0, cUnitTypeBuilding);
	aiPlanSetVariableInt(newAttackPlanID, cAttackPlanTargetTypeID, 1, cUnitTypeUnit);

	aiPlanSetVariableInt(newAttackPlanID, cAttackPlanAttackRouteID, 0, attackRoute1ID);
	aiPlanSetVariableVector(newAttackPlanID, cAttackPlanGatherPoint, 0, gatherPoint);

   //Set the gather point and gather point distance.
   aiPlanSetVariableFloat(newAttackPlanID, cAttackPlanGatherDistance, 0, 20.0);

   //Set up the attack route usage pattern.
   aiPlanSetVariableInt(newAttackPlanID, cAttackPlanAttackRoutePattern, 0, cAttackPlanAttackRoutePatternRandom);
   
	//Add the unit types to the plan.
   aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID1, attackMinimumGroupSize, attackMaximumGroupSize, attackMaximumGroupSize);
	if ( difflevel > 0 )
	{
		aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID3, 0, attackMaximumGroupSize, attackMaximumGroupSize);
	}

	// Heroes, except on easy.
	if ( difflevel > 0 )
	{
		aiPlanAddUnitType(newAttackPlanID, attackerHeroTypeID1, 0, 1, 1);
		aiPlanAddUnitType(newAttackPlanID, attackerHeroTypeID2, 0, 1, 1);
	}

	// Catapults if available; fewer on easy.
	if ( difflevel > 0 )
	{
		aiPlanAddUnitType(newAttackPlanID, attackerSiegeTypeID1, 0, 2, 4);
	}
	else
	{
		aiPlanAddUnitType(newAttackPlanID, attackerSiegeTypeID1, 0, 1, 1);
	}

	// A pair o' cyclopses if available, or one on easy.
	if ( difflevel > 0 )
	{
		aiPlanAddUnitType(newAttackPlanID, attackerMythTypeID1, 0, 2, 2);
	}
	else
	{
		aiPlanAddUnitType(newAttackPlanID, attackerMythTypeID1, 0, 1, 1);
	}

	// Myth units, sometimes.
	// aiPlanAddUnitType(newAttackPlanID, attackerMythTypeID2, 0, 4, 4);
	// aiPlanAddUnitType(newAttackPlanID, attackerMythTypeID3, 0, 2, 2);
	
   //Set the initial position.
	aiPlanSetInitialPosition(newAttackPlanID, gatherPoint);
		
   //Plan requires all need units to work (can be false).
   aiPlanSetRequiresAllNeedUnits(newAttackPlanID, true);
   //Activate the plan.
   aiPlanSetActive(newAttackPlanID);

   //Now, save the attack plan ID appropriately.
   aiPlanSetOrphan(attackPlan1ID, true);
   attackPlan1ID=newAttackPlanID;

   //Increment our overall number of attacks.
   numberAttacks++;
}

//==============================================================================
// setupCavAttack
//==============================================================================
bool setupCavAttack(int playerID=-1)
{
	//Info.
	aiEcho("Attacking Player "+playerID+".");

   //If the player to attack doesn't match, init the attack.
   if (attackPlayerID != playerID)
   {
      initAttack(playerID);
      if (attackPlayerID < 0)
         return(false);
   }

   //Create an attack plan.
   int newAttackPlanID=aiPlanCreate("Attack Player"+attackPlayerID+" Attempt"+numberAttacks, cPlanAttack);
   if (newAttackPlanID < 0)
      return(false);

   //Target player (required).  This must work.
   if (aiPlanSetVariableInt(newAttackPlanID, cAttackPlanPlayerID, 0, attackPlayerID) == false)
      return(false);

   //Gather points.
	vector gatherPoint=kbGetBlockPosition("2452");
	

	//Set the target type.  This must work.
   if (aiPlanSetNumberVariableValues(newAttackPlanID, cAttackPlanTargetTypeID, 2, true) == false)
      return(false);

	aiPlanSetNumberVariableValues(newAttackPlanID, cAttackPlanTargetTypeID, 3, true);

   //Unit types to attack.
   aiPlanSetVariableInt(newAttackPlanID, cAttackPlanTargetTypeID, 0, cUnitTypeVillagerGreek);
	aiPlanSetVariableInt(newAttackPlanID, cAttackPlanTargetTypeID, 1, cUnitTypeUnit);
	aiPlanSetVariableInt(newAttackPlanID, cAttackPlanTargetTypeID, 2, cUnitTypeBuilding);

	aiPlanSetVariableInt(newAttackPlanID, cAttackPlanAttackRouteID, 0, attackRoute1ID);
	aiPlanSetVariableVector(newAttackPlanID, cAttackPlanGatherPoint, 0, gatherPoint);

   //Set the gather point and gather point distance.
   aiPlanSetVariableFloat(newAttackPlanID, cAttackPlanGatherDistance, 0, 30.0);

	// Use the second route here.
	aiPlanSetVariableInt(newAttackPlanID, cAttackPlanAttackRouteID, 0, attackRoute2ID);

   //Set up the attack route usage pattern.
   aiPlanSetVariableInt(newAttackPlanID, cAttackPlanAttackRoutePattern, 0, cAttackPlanAttackRoutePatternRandom);
   
	//Add the unit types to the plan.
   aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID2, 4, 8, 12);

	// A pair o' nemeans if available.
	aiPlanAddUnitType(newAttackPlanID, attackerMythTypeID2, 0, 2, 2);

   //Set the initial position.
	aiPlanSetInitialPosition(newAttackPlanID, gatherPoint);
		
   //Plan requires all need units to work (can be false).
   aiPlanSetRequiresAllNeedUnits(newAttackPlanID, true);
   //Activate the plan.
   aiPlanSetActive(newAttackPlanID);

   //Now, save the attack plan ID appropriately.
   aiPlanSetOrphan(attackPlan2ID, true);
   attackPlan2ID=newAttackPlanID;

   //Increment our overall number of attacks.
   numberAttacks++;
}

//==============================================================================
// Attack Generator 1 - Mixed group of human units
//==============================================================================
rule attackGenerator
   minInterval 110
   inactive
   group AttackRules
   runImmediately
{
   //See how many "idle" attack plans we have.  Don't create any more if we have
   //idle plans.
   int numberIdleAttackPlans=aiGetNumberIdlePlans(cPlanAttack);

   if (numberIdleAttackPlans > 0)
      return;

   // If we have enough unassigned military units, create a new attack plan.
	// Hoplites are the primary unit.
   int numberAvailableUnits=aiNumberUnassignedUnits(attackerUnitTypeID1);
   aiEcho("There are "+numberAvailableUnits+" hoplites available for a new attack.");
   
	if (numberAvailableUnits >= attackMinimumGroupSize)
		setupAttack(1);
}

//==============================================================================
// Attack Generator 2 - Cav and Nemean raiders 
//==============================================================================
rule attackGeneratorCav
   minInterval 160
   inactive
   group AttackRules
{
   //See how many "idle" attack plans we have.  Don't create any more if we have
   //idle plans.
   int numberIdleAttackPlans=aiGetNumberIdlePlans(cPlanAttack);

   if (numberIdleAttackPlans > 0)
      return;

   // If we have enough unassigned military units, create a new attack plan.
	// Hoplites are the primary unit.
   int numberAvailableUnits=aiNumberUnassignedUnits(attackerUnitTypeID2);
   aiEcho("There are "+numberAvailableUnits+" hoplites available for a new attack.");
   
	if (numberAvailableUnits >= 4)
		setupCavAttack(1);
}

//==============================================================================
// Attack enablers - enable attacks after initial timers expire 
//==============================================================================
rule attack1Enabler
   minInterval 150
   active
   group AttackRules
{
	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

	aiEcho("*** PLAYER 5 - ATTACKS ENABLED ***");
   xsEnableRule("attackGenerator");

	// Cavalry attacks on all levels other than Easy.
	if ( difflevel > 0 )
	{
		xsEnableRule("attackGeneratorCav");
	}
   xsDisableSelf();
}

//==============================================================================
// Siege enabler - start maintaining siege weapons at ten minutes.
//==============================================================================
rule siegeEnabler
   minInterval 600
   active
   group AttackRules
{
	aiEcho("*** PLAYER 5 - MAINTAINING SIEGE and LIONS - ATTACKING WITH CAVALRY ***");

	vector gatherPointSiege=kbGetBlockPosition("2463");
	vector gatherPointLions=kbGetBlockPosition("2451");

   //Maintain Catapults (4)
   maintainSiege1ID=aiPlanCreate("Maintain 4 "+kbGetProtoUnitName(attackerSiegeTypeID1), cPlanTrain);
   if (maintainSiege1ID >= 0)
   {
		//Must set the type of unit to train. 
      aiPlanSetVariableInt(maintainSiege1ID, cTrainPlanUnitType, 0, attackerSiegeTypeID1);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
      aiPlanSetVariableInt(maintainSiege1ID, cTrainPlanNumberToMaintain, 0, 4);
      //Don't train units too fast
      aiPlanSetVariableInt(maintainSiege1ID, cTrainPlanFrequency, 0, 90);
      //Set a gather point.
      aiPlanSetVariableVector(maintainSiege1ID, cTrainPlanGatherPoint, 0, gatherPointSiege);
      //Activate the plan.
      aiPlanSetActive(maintainSiege1ID);
   }

	// Myth Maintain Plan - two Nemeans
   maintainMythPlan2ID=aiPlanCreate("Maintain 2 "+kbGetProtoUnitName(attackerMythTypeID2), cPlanTrain);
   if (maintainMythPlan1ID >= 0)
   {
		//Must set the type of unit to train.
      aiPlanSetVariableInt(maintainMythPlan2ID, cTrainPlanUnitType, 0, attackerMythTypeID2);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
      aiPlanSetVariableInt(maintainMythPlan2ID, cTrainPlanNumberToMaintain, 0, 2);
      //Don't train units too fast
      aiPlanSetVariableInt(maintainMythPlan2ID, cTrainPlanFrequency, 0, 90);
      //Set a gather point.
      aiPlanSetVariableVector(maintainMythPlan2ID, cTrainPlanGatherPoint, 0, gatherPointLions);
      //Activate the plan.
      aiPlanSetActive(maintainMythPlan2ID);
   }
   xsDisableSelf();
}


/*
//==============================================================================
// Tech Researching Rules - medium axemen, medium slingers, medium spearmen
//==============================================================================
rule researchMediumAxemen
   minInterval 600
   active
{
   int planID=aiPlanCreate("Medium Axemen research at ten minutes.", cPlanResearch);
   if (planID < 0)
      return;

   aiPlanSetVariableInt(planID, cResearchPlanTechID, 0, cTechMediumAxemen);
   aiPlanSetVariableInt(planID, cResearchPlanBuildingTypeID, 0, cUnitTypeBarracks);
   aiPlanSetActive(planID);
   
	//Done.
   xsDisableSelf();
}
*/

//==============================================================================
// Favor cheat - favor every so often.
//==============================================================================
rule favorCheat
   minInterval 60
   active
   group AttackRules
{
	// Cheat for favor every 60 seconds.  That Gargarensis is a bastard.
	aiResourceCheat( 5, cResourceFavor, 20.0 );
}


//==================================================================================================
// Player has Plenties!  Or, alternatively, he's destroyed a forward fortress.  Leary sleep now.  :)
//==================================================================================================
void playerHasPlenties(int scriptCall = -1)
{
	vector defendPointWest=kbGetBlockPosition("2447");
	vector defendPointEast=kbGetBlockPosition("2444");

	aiEcho("*** PLAYER 5: HP has destroyed a forward fortress ***");
	
	// Disable the attack generator (and the siege stuff if it hasn't fired)
	xsDisableRule( "attackGenerator" );
	xsDisableRule( "siegeEnabler" );

	// Disable the cavalry defend plan and stop maintaining cav, catapults, toxotes, cyclopses, and heroes.
	//aiPlanDestroy( defendPlan1ID );
	aiPlanDestroy( maintainPlan2ID );
	aiPlanDestroy( maintainSiege1ID );
	
	aiPlanDestroy( maintainPlan2ID );
	aiPlanDestroy( maintainPlan3ID );
	aiPlanDestroy( maintainMythPlan1ID );
	aiPlanDestroy( maintainHeroPlan1ID );
	aiPlanDestroy( maintainHeroPlan2ID );

	// Back the other two defense plans up to the entrance to "higher ground."
	aiPlanSetVariableVector(defendPlan2ID, cDefendPlanDefendPoint, 0, defendPointWest);
	aiPlanSetVariableVector(defendPlan3ID, cDefendPlanDefendPoint, 0, defendPointEast);
}

//==============================================================================
// Maintain stuff - separated out for sanity's sake.
//==============================================================================
void maintainStuff(void)
{
   //Share a common gather point.
	vector gatherPointWest=kbGetBlockPosition("2451");
	vector gatherPointCenter=kbGetBlockPosition("2448");
   vector gatherPointEast=kbGetBlockPosition("2445");
	vector gatherPointTemple=kbGetBlockPosition("2447");
	
	//Share the number to maintain.
   int numberToMaintain=attackMinimumGroupSize*2;

   //Maintain hoplites (16)
   maintainPlan1ID=aiPlanCreate("Maintain "+numberToMaintain+" "+kbGetProtoUnitName(attackerUnitTypeID1), cPlanTrain);
   if (maintainPlan1ID >= 0)
   {
		//Must set the type of unit to train. 
      aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanUnitType, 0, attackerUnitTypeID1);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
      aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanNumberToMaintain, 0, 12);
      //Don't train units too fast
      aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanFrequency, 0, 20);
      //Set a gather point.
      aiPlanSetVariableVector(maintainPlan1ID, cTrainPlanGatherPoint, 0, gatherPointCenter);
      //Activate the plan.
      aiPlanSetActive(maintainPlan1ID);
   }

	//Maintain hippikons (12)
   maintainPlan2ID=aiPlanCreate("Maintain 12 "+kbGetProtoUnitName(attackerUnitTypeID2), cPlanTrain);
   if (maintainPlan2ID >= 0)
   {
		//Must set the type of unit to train. 
      aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanUnitType, 0, attackerUnitTypeID2);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
      aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanNumberToMaintain, 0, 12);
      //Don't train units too fast
      aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanFrequency, 0, 30);
      //Set a gather point.
      aiPlanSetVariableVector(maintainPlan2ID, cTrainPlanGatherPoint, 0, gatherPointWest);
      //Activate the plan.
      aiPlanSetActive(maintainPlan2ID);
   }

	//Maintain toxotes (8)
   maintainPlan3ID=aiPlanCreate("Maintain 8 "+kbGetProtoUnitName(attackerUnitTypeID3), cPlanTrain);
   if (maintainPlan3ID >= 0)
   {
		//Must set the type of unit to train.
      aiPlanSetVariableInt(maintainPlan3ID, cTrainPlanUnitType, 0, attackerUnitTypeID3);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
      aiPlanSetVariableInt(maintainPlan3ID, cTrainPlanNumberToMaintain, 0, numberToMaintain);
      //Don't train units too fast
      aiPlanSetVariableInt(maintainPlan3ID, cTrainPlanFrequency, 0, 40);
      //Set a gather point.
      aiPlanSetVariableVector(maintainPlan3ID, cTrainPlanGatherPoint, 0, gatherPointEast);
      //Activate the plan.
      aiPlanSetActive(maintainPlan3ID);
   }

	//Maintain hypaspists(12)
   maintainPlan4ID=aiPlanCreate("Maintain 12 "+kbGetProtoUnitName(attackerUnitTypeID4), cPlanTrain);
   if (maintainPlan4ID >= 0)
   {
		//Must set the type of unit to train.
      aiPlanSetVariableInt(maintainPlan4ID, cTrainPlanUnitType, 0, attackerUnitTypeID4);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
      aiPlanSetVariableInt(maintainPlan4ID, cTrainPlanNumberToMaintain, 0, 12);
      //Don't train units too fast
      aiPlanSetVariableInt(maintainPlan4ID, cTrainPlanFrequency, 0, 45);
      //Set a gather point.
      aiPlanSetVariableVector(maintainPlan4ID, cTrainPlanGatherPoint, 0, gatherPointCenter);
      //Activate the plan.
      aiPlanSetActive(maintainPlan4ID);
   }
	
	//Maintain peltasts(6)
   maintainPlan5ID=aiPlanCreate("Maintain 4 "+kbGetProtoUnitName(attackerUnitTypeID5), cPlanTrain);
   if (maintainPlan5ID >= 0)
   {
		//Must set the type of unit to train.
      aiPlanSetVariableInt(maintainPlan5ID, cTrainPlanUnitType, 0, attackerUnitTypeID5);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
      aiPlanSetVariableInt(maintainPlan5ID, cTrainPlanNumberToMaintain, 0, 6);
      //Don't train units too fast
      aiPlanSetVariableInt(maintainPlan5ID, cTrainPlanFrequency, 0, 50);
      //Set a gather point.
      aiPlanSetVariableVector(maintainPlan5ID, cTrainPlanGatherPoint, 0, gatherPointEast);
      //Activate the plan.
      aiPlanSetActive(maintainPlan5ID);
   }

	// Myth Maintain Plan - three cyclopses
   maintainMythPlan1ID=aiPlanCreate("Maintain 3 "+kbGetProtoUnitName(attackerMythTypeID1), cPlanTrain);
   if (maintainMythPlan1ID >= 0)
   {
		//Must set the type of unit to train.
      aiPlanSetVariableInt(maintainMythPlan1ID, cTrainPlanUnitType, 0, attackerMythTypeID1);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
      aiPlanSetVariableInt(maintainMythPlan1ID, cTrainPlanNumberToMaintain, 0, 3);
      //Don't train units too fast
      aiPlanSetVariableInt(maintainMythPlan1ID, cTrainPlanFrequency, 0, 90);
      //Set a gather point.
      aiPlanSetVariableVector(maintainMythPlan1ID, cTrainPlanGatherPoint, 0, gatherPointTemple);
      //Activate the plan.
      aiPlanSetActive(maintainMythPlan1ID);
   }

	// Hero Maintain Plans
   maintainHeroPlan1ID=aiPlanCreate("Maintain "+kbGetProtoUnitName(attackerHeroTypeID1), cPlanTrain);
   if (maintainHeroPlan1ID >= 0)
   {
		//Must set the type of unit to train.
      aiPlanSetVariableInt(maintainHeroPlan1ID, cTrainPlanUnitType, 0, attackerHeroTypeID1);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
      aiPlanSetVariableInt(maintainHeroPlan1ID, cTrainPlanNumberToMaintain, 0, 1);
      //Don't train units too fast
      aiPlanSetVariableInt(maintainHeroPlan1ID, cTrainPlanFrequency, 0, 130);
      //Set a gather point.
      aiPlanSetVariableVector(maintainHeroPlan1ID, cTrainPlanGatherPoint, 0, gatherPointEast);
      //Activate the plan.
      aiPlanSetActive(maintainHeroPlan1ID);
   }

   maintainHeroPlan2ID=aiPlanCreate("Maintain "+kbGetProtoUnitName(attackerHeroTypeID2), cPlanTrain);
   if (maintainHeroPlan2ID >= 0)
   {
		//Must set the type of unit to train.
      aiPlanSetVariableInt(maintainHeroPlan2ID, cTrainPlanUnitType, 0, attackerHeroTypeID2);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
      aiPlanSetVariableInt(maintainHeroPlan2ID, cTrainPlanNumberToMaintain, 0, 1);
      //Don't train units too fast
      aiPlanSetVariableInt(maintainHeroPlan2ID, cTrainPlanFrequency, 0, 140);
      //Set a gather point.
      aiPlanSetVariableVector(maintainHeroPlan2ID, cTrainPlanGatherPoint, 0, gatherPointEast);
      //Activate the plan.
      aiPlanSetActive(maintainHeroPlan2ID);
   }
}

//==============================================================================
// Defend plan excitement.
//==============================================================================
void defendPlanSetup(void)
{
	/*
	defendPlan1ID=aiPlanCreate("West Defense", cPlanDefend);
   if (defendPlan1ID >= 0)
   {
      //choke point
      vector westChoke=kbGetBlockPosition("2452");

      //Add the unit(s).
      aiPlanAddUnitType(defendPlan1ID, attackerUnitTypeID2, 0, 4, 4);
				
      //Setup the vars.
      aiPlanSetDesiredPriority(defendPlan1ID, 40);
      aiPlanSetVariableVector(defendPlan1ID, cDefendPlanDefendPoint, 0, westChoke);
      aiPlanSetVariableFloat(defendPlan1ID, cDefendPlanEngageRange, 0, 20);
      aiPlanSetActive(defendPlan1ID);
	}
	*/

   defendPlan2ID=aiPlanCreate("Center Defense", cPlanDefend);
   if (defendPlan2ID >= 0)
   {
      //choke point
      vector centerChoke=kbGetBlockPosition("2450");

      //Add the unit(s).
      aiPlanAddUnitType(defendPlan2ID, attackerUnitTypeID4, 0, 6, 6);
		aiPlanAddUnitType(defendPlan2ID, attackerUnitTypeID5, 0, 3, 3);
		
      //Setup the vars.
      aiPlanSetDesiredPriority(defendPlan2ID, 40);
		aiPlanSetVariableVector(defendPlan2ID, cDefendPlanDefendPoint, 0, centerChoke);
      aiPlanSetVariableFloat(defendPlan2ID, cDefendPlanEngageRange, 0, 20);
      aiPlanSetActive(defendPlan2ID);
	}

	defendPlan3ID=aiPlanCreate("East Defense", cPlanDefend);
   if (defendPlan3ID >= 0)
   {
      //choke point
      vector eastChoke=kbGetBlockPosition("2449");

      //Add the unit(s).
		aiPlanAddUnitType(defendPlan2ID, attackerUnitTypeID4, 0, 6, 6);
      aiPlanAddUnitType(defendPlan3ID, attackerUnitTypeID5, 0, 3, 3);
		
      //Setup the vars.
      aiPlanSetDesiredPriority(defendPlan3ID, 90);
		aiPlanSetVariableVector(defendPlan3ID, cDefendPlanDefendPoint, 0, eastChoke);
      aiPlanSetVariableFloat(defendPlan3ID, cDefendPlanEngageRange, 0, 20);
      aiPlanSetActive(defendPlan3ID);
	}
}

//==============================================================================
// MAIN
//==============================================================================
void main(void)
{
   //Startup.
   miscStartup();
	
	//Set up maintain plans.
	maintainStuff();

	// Set up a couple of defend plans.
	defendPlanSetup();
}