//==============================================================================
// Scn31p2: AI Scenario Script for scenario 31 player
//==============================================================================
/*
   AI owner:  Dave Leary
   Scenario owner: Joe "The Golem" Gillum

   Overview: An AI to handle the massive hordes of spawned units that attack
	and drive the player back during the WTS segment of scneario 31 (after the
	player destroys the gate ram).
	
	This AI takes all units that are spawned and moves them to the 
	well (player entrance).  Pacing and size of attacks are controlled by the
	scenario designer via trigger.  Units spawning at the north gate head
	around the underworld mountains to the north; units spawning at the south
	gate head around the underworld mountains to the south.  Both groups end
	up at the bridge, and will cross to attack the well if not stopped.
*/
//==============================================================================
include "scn lib.xs";

// Used to search for spawned CP military units
int leftStartQuery = -1;
int rightStartQuery = -1;

int defend1Query = -1;
int defend2Query = -1;
int defend3Query = -1;
int defend4Query = -1;

// Route and path vars
int attackRoute1ID=-1;
int attackPath1ID=-1;
int attackRoute2ID=-1;
int attackPath2ID=-1;

int defendPlan1ID=-1;
int defendPlan2ID=-1;
int defendPlan3ID=-1;
int defendPlan4ID=-1;

//==============================================================================
// Set Town Location
//==============================================================================
void setTownLocation(void)
{
   //Look for the "Town Location" marker.
   kbSetTownLocation(kbGetBlockPosition("3050"));
}

//==============================================================================
// miscStartup
//==============================================================================
void miscStartup(void)
{
   //Startup message(s).
   aiEcho("");
   aiEcho("");
   aiEcho("Scn27P2 AI Start, filename='"+cFilename+"'.");
   //Spit out the map size.
   aiEcho("  Map size is ("+kbGetMapXSize()+", "+kbGetMapZSize()+").");
   //Cheat like a bastard.  Once only, though.
	// DAL - this AI uses revealers on the map to cheat.
   //kbLookAtAllUnitsOnMap();
   //Calculate some areas.
   kbAreaCalculate(1200.0);
   //Set our town location.
   setTownLocation();
	//Reset random seeds
	aiRandSetSeed();
   //Allocate all resources
   kbEscrowAllocateCurrentResources();

	// Attack path/route setup.

	//Setup attack path 1 - the northern route.
   attackPath1ID=kbPathCreate("Attack Path North");
   kbPathAddWaypoint(attackPath1ID, kbGetBlockPosition("3089"));
	kbPathAddWaypoint(attackPath1ID, kbGetBlockPosition("3090"));
	kbPathAddWaypoint(attackPath1ID, kbGetBlockPosition("3088"));
   //Create attack route 1.
   attackRoute1ID=kbCreateAttackRouteWithPath("Attack Route North", kbGetBlockPosition("3050"), kbGetBlockPosition("193"));
   
	if (attackRoute1ID >= 0)
      kbAttackRouteAddPath(attackRoute1ID, attackPath1ID);

   //Setup attack path 2 - the southern route
   kbPathAddWaypoint(attackPath2ID, kbGetBlockPosition("3086"));
	kbPathAddWaypoint(attackPath2ID, kbGetBlockPosition("3087"));
	kbPathAddWaypoint(attackPath2ID, kbGetBlockPosition("3088"));
   attackPath2ID=kbPathCreate("Attack Path South");
   
	//Create attack route 2.
   attackRoute2ID=kbCreateAttackRouteWithPath("Attack Route South", kbGetBlockPosition("3051"), kbGetBlockPosition("193"));

	if (attackRoute2ID >= 0)
      kbAttackRouteAddPath(attackRoute2ID, attackPath2ID);
}

void launchAttack(vector start=vector(-1,-1,-1), int query=-1, int count=-1)
{
   int attackID = aiPlanCreate("Attack at "+(xsGetTime()/1000), cPlanAttack);
	
	// Locations for spawning fun
	vector spawnLocationLeft=kbGetBlockPosition("3050");
	vector spawnLocationRight=kbGetBlockPosition("3051");


   if (attackID < 0)
      return;

   // Attack player #1.
	if (aiPlanSetVariableInt(attackID, cAttackPlanPlayerID, 0, 1) == false)
      return;

	// Set up the actual attack.

   aiPlanSetVariableVector(attackID, cAttackPlanGatherPoint, 0, start);
   aiPlanSetVariableFloat(attackID, cAttackPlanGatherDistance, 0, 50.0);
   aiPlanSetInitialPosition(attackID, start);
	aiPlanAddUnitType(attackID, cUnitTypeUnit, 1, count, count);

		// "Left" (north) means use Route 1; otherwise, use Route 2.
	if ( start == spawnLocationLeft )
	{
		aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, attackRoute2ID);
		aiEcho("Attack going south.");
	}
	else
	{
		aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, attackRoute1ID);
		aiEcho("Attack going north.");
	}

	//Target unit types to attack.
	aiPlanSetVariableInt(attackID, cAttackPlanTargetTypeID, 0, cUnitTypeBuilding);
   aiPlanSetVariableInt(attackID, cAttackPlanTargetTypeID, 1, cUnitTypeUnit);
	
	//Needs all units listed - get 'em all!
   aiPlanSetRequiresAllNeedUnits(attackID, true);
   aiPlanSetActive(attackID);
}

//==============================================================================
// TWO TRIGGERED FUNCTIONS - both called via AI FUNC triggers in the scenario.
//==============================================================================
// channelID indicates which channel has the units.
void spawnArmy(int channelID=-1)
{
	// Locations for spawning fun
	vector spawnLocationLeft=kbGetBlockPosition("3050");
	vector spawnLocationRight=kbGetBlockPosition("3051");

   int targetCount = -1;

   aiEcho("Spawn Army firing, channelID = "+channelID);

	// Destroy the defend plans so they don't suck any more.
	aiPlanDestroy(defendPlan1ID);
	aiPlanDestroy(defendPlan2ID);
	aiPlanDestroy(defendPlan3ID);
	aiPlanDestroy(defendPlan4ID);

   switch(channelID)
   {
		case 0:
      {
         //check left
         targetCount = getUnassignedUnitCount(spawnLocationLeft, 25.0, 2, cUnitTypeUnit);
         aiEcho("Found "+targetCount+" units near the left channel.");
         if (targetCount > 0)
         {
            launchAttack(spawnLocationLeft, leftStartQuery, targetCount);
         }
			break;
      }

		case 1:
      {
         //check right
         targetCount = getUnassignedUnitCount(spawnLocationRight, 25.0, 2, cUnitTypeUnit);
         aiEcho("Found "+targetCount+" units near the right channel.");
         if (targetCount > 0)
         {
            launchAttack(spawnLocationRight, rightStartQuery, targetCount);
         }
         break;
      }
   }
}

/*
// DAL - Don't think we need this
//
// Sets up the stuff
void counterAttack(int channelID=-1)
{
}
*/

//==============================================================================
// MAIN.
//==============================================================================
void main(void)
{
	// Locations for spawning fun
	int defendCount = -1;

	vector spawnLocationLeft=kbGetBlockPosition("3050");
	vector spawnLocationRight=kbGetBlockPosition("3051");

	// Defend plans
	vector defendLoc1=kbGetBlockPosition("3760");
	vector defendLoc2=kbGetBlockPosition("3761");
	vector defendLoc3=kbGetBlockPosition("3762");
	vector defendLoc4=kbGetBlockPosition("3763");

	miscStartup();

	// Set up the two queries
	leftStartQuery = kbUnitQueryCreate("checkLeftStart");    // Look for CP units 
   if ( configQuery(leftStartQuery, cUnitTypeMilitary, -1, cUnitStateAlive, 2, spawnLocationLeft, true, 30) == false)
      aiEcho("Query setup failed");

   rightStartQuery = kbUnitQueryCreate("checkRightStart");    // Look for CP units
   if ( configQuery(rightStartQuery, cUnitTypeMilitary, -1, cUnitStateAlive, 2, spawnLocationRight, true, 30) == false)
      aiEcho("Query setup failed");

	// Make low-priority defend plans for the various spots.
	defendCount = getUnassignedUnitCount(defendLoc1, 10.0, 2, cUnitTypeUnit);
	defendPlan1ID=aiPlanCreate("Defend 1", cPlanDefend);
	if (defendPlan1ID >= 0)
   {
      //Add the unit(s).
      aiPlanAddUnitType(defendPlan1ID, cUnitTypeUnit, 0, defendCount, defendCount);
		
      //Setup the vars.
      aiPlanSetDesiredPriority(defendPlan1ID, 30);
      aiPlanSetVariableVector(defendPlan1ID, cDefendPlanDefendPoint, 0, defendLoc1);
		aiPlanSetInitialPosition(defendPlan1ID, defendLoc1);
		aiPlanSetVariableFloat(defendPlan1ID, cDefendPlanGatherDistance, 0, 10.0);
      aiPlanSetVariableFloat(defendPlan1ID, cDefendPlanEngageRange, 0, 20);
		aiPlanSetUnitStance(defendPlan1ID, cUnitStanceDefensive);
		aiPlanSetAllowUnderAttackResponse(defendPlan1ID, false);
      aiPlanSetActive(defendPlan1ID);
	}

	defendCount = getUnassignedUnitCount(defendLoc2, 8.0, 2, cUnitTypeUnit);
	defendPlan2ID=aiPlanCreate("Defend 2", cPlanDefend);
   if (defendPlan2ID >= 0)
   {
      //Add the unit(s).
      aiPlanAddUnitType(defendPlan2ID, cUnitTypeUnit, 0, defendCount, defendCount);
		
      //Setup the vars.
      aiPlanSetDesiredPriority(defendPlan2ID, 30);
      aiPlanSetVariableVector(defendPlan2ID, cDefendPlanDefendPoint, 0, defendLoc2);
		aiPlanSetInitialPosition(defendPlan2ID, defendLoc2);
		aiPlanSetVariableFloat(defendPlan2ID, cDefendPlanGatherDistance, 0, 8.0);
      aiPlanSetVariableFloat(defendPlan2ID, cDefendPlanEngageRange, 0, 20);
		aiPlanSetUnitStance(defendPlan2ID, cUnitStanceDefensive);
		aiPlanSetAllowUnderAttackResponse(defendPlan2ID, false);
      aiPlanSetActive(defendPlan2ID);
	}

	defendCount = getUnassignedUnitCount(defendLoc3, 8.0, 2, cUnitTypeUnit);
	defendPlan3ID=aiPlanCreate("Defend 3", cPlanDefend);
   if (defendPlan3ID >= 0)
   {
      //Add the unit(s).
      aiPlanAddUnitType(defendPlan3ID, cUnitTypeUnit, 0, defendCount, defendCount);
		
      //Setup the vars.
      aiPlanSetDesiredPriority(defendPlan3ID, 30);
      aiPlanSetVariableVector(defendPlan3ID, cDefendPlanDefendPoint, 0, defendLoc3);
		aiPlanSetInitialPosition(defendPlan3ID, defendLoc3);
		aiPlanSetVariableFloat(defendPlan3ID, cDefendPlanGatherDistance, 0, 8.0);
      aiPlanSetVariableFloat(defendPlan3ID, cDefendPlanEngageRange, 0, 20);
		aiPlanSetUnitStance(defendPlan3ID, cUnitStanceDefensive);
		aiPlanSetAllowUnderAttackResponse(defendPlan3ID, false);
      aiPlanSetActive(defendPlan3ID);
	}

	defendCount = getUnassignedUnitCount(defendLoc4, 8.0, 2, cUnitTypeUnit);
	defendPlan4ID=aiPlanCreate("Defend 4", cPlanDefend);
   if (defendPlan4ID >= 0)
   {
      //Add the unit(s).
      aiPlanAddUnitType(defendPlan4ID, cUnitTypeUnit, 0, defendCount, defendCount);
		
      //Setup the vars.
      aiPlanSetDesiredPriority(defendPlan4ID, 30);
      aiPlanSetVariableVector(defendPlan4ID, cDefendPlanDefendPoint, 0, defendLoc4);
		aiPlanSetInitialPosition(defendPlan4ID, defendLoc4);
		aiPlanSetVariableFloat(defendPlan4ID, cDefendPlanGatherDistance, 0, 8.0);
      aiPlanSetVariableFloat(defendPlan4ID, cDefendPlanEngageRange, 0, 20);
		aiPlanSetUnitStance(defendPlan4ID, cUnitStanceDefensive);
		aiPlanSetAllowUnderAttackResponse(defendPlan4ID, false);
      aiPlanSetActive(defendPlan4ID);
	}
}