//==============================================================================
// Scn30p2: AI Scenario Script for scenario 30 player 2
//==============================================================================
/*
   AI owner:  Mike Kidd
   Scenario owner: Jeff Brown, with a momentary assist from Jerome Jones

   Overview:
   

  
   9/6/2002:  Disabled Nidhogg per JB request.

   9/13/2002:  Beefed up attack on moderate, hard and titan; added circular patrol defend plan.

   9/24/2002:  Modified longhouseMaintainQty, hillfortMaintainQty and mythMaintainQty for difficulty level.

*/
//==============================================================================


include "scn lib.xs";


// *****************************************************************************
//
// Globals
//
// *****************************************************************************

// Attack routes and queries
int   routeWest = -1;
int   routeWestCenter = -1;
int   routeEastCenter = -1;
int   routeEast = -1;



// Army control
int   lastAttackPlan = -1;       // Used to find "my army" for god power position info
int   defendPlan = -1;
bool  defendOnly = false;        // When true, cancels last attack plan, all military go to defense

                                 // The following are set in main() based on difficulty level.
int      nextAttackTime = 240000;   // Will be adjusted for the wakeup time
int      attackInterval = 240000;   // Attack every 4:00
float    attackSize = 6.0;
float    attackMultiplier = 1.2;
int      maxAttackSize = 25;

int   longhouseMaintainID = -1;      // Plan for maintaining population of longhouse units
int   longhouseMaintainQty = 20;     // How many to maintain
int   longhouseUnit = -1;            // Which unit type
int   longhouseMaintainDelay = 1;   // How many seconds between training units

int   hillfortMaintainID = -1;
int   hillfortMaintainQty = 10;
int   hillfortMaintainDelay = 1;
int   hillfortUnit = -1;

int   mythMaintainID = -1;
int   mythMaintainQty = 5;
int   mythUnit = -1;
int   mythMaintainDelay = 1;


// Cinematic blocks
const string cbFinalGate = "2782";
const string cbRouteWest1 = "2783";
const string cbRouteWest2 = "2784";
const string cbRouteWest3 = "2785";
const string cbRouteWestCenter1 = "2786";
const string cbRouteWestCenter2 = "2787";
const string cbRouteWestCenter3 = "2788";
const string cbRouteEastCenter1 = "2789";
const string cbRouteEastCenter2 = "2790";
const string cbRouteEastCenter3 = "2791";
const string cbRouteEast1 = "2792";
const string cbRouteEast2 = "2793";
const string cbRouteEast3 = "2794";
const string cbHillfortGather = "2795";
const string cbLonghouseGather = "2796";
const string cbTempleGather = "2797";
const string cbAttackGather = "2798";
const string cbP1TC = "2799";
const string cbP3TC = "2800";
const string cbP2TC = "2801";
const string cbPatrolEast = "2975";    // For use with cbFinalGate to make circular patrol for defend plan if needed
const string cbPatrolSouth = "2976";
const string cbPatrolWest = "2977";



// Misc.
int   age2Time = 420000;    // 7 min....will be adjusted in main() for difficulty
int   age3Time = 960000;   // 16 min
int   age4Time = 1620000;  // 27 min
int   startTime = -1;      // Time of the wakeup() function...will be added to the age times.

int   difficulty = -1;


// *****************************************************************************
//
//                                FUNCTIONS
//
// *****************************************************************************


// Called by trigger when the cinematics are done
void wakeup(int parm=-1)
{
   static bool alreadyRun = false;
   aiEcho("Wakeup running at "+timeString()+".");
   if (alreadyRun == true)
      return;
   alreadyRun = true;

   startTime = xsGetTime();
   age2Time = age2Time + startTime;
   xsEnableRule("goToAge2");
   age3Time = age3Time + startTime;    // Adjust for delay in wakeup. 
   age4Time = age4Time + startTime;
   nextAttackTime = nextAttackTime + startTime;

   // Init age 1 maintain plans
   maintainUnit(cUnitTypeRaidingCavalry, 1, kbGetBlockPosition(cbAttackGather), 10);   // For scouting


   // Init low-priority defend plan to manage all extra mil units
   defendPlan =aiPlanCreate("Defend Plan", cPlanDefend);
   if (defendPlan >= 0)
   {
//      vector pointA=gTownLocation;
//      pointA=xsVectorSetX(pointA, xsVectorGetX(gTownLocation)-50.0);
//      vector pointB=gTownLocation;
//      pointB=xsVectorSetZ(pointB, xsVectorGetZ(gTownLocation)-50.0);

      aiPlanAddUnitType(defendPlan, cUnitTypeMilitary, 0, 200, 200);    // All unassigned mil units
      aiPlanSetDesiredPriority(defendPlan, 20);                       // Way low, below scouting and attack
      aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbFinalGate));
//      aiPlanSetVariableInt(defendPlan, cDefendPlanDefendTargetID, 0, 1410);
      aiPlanSetVariableFloat(defendPlan, cDefendPlanEngageRange, 0, 60);
      aiPlanSetUnitStance(defendPlan, cUnitStanceDefensive);

      // Start with a simple 3-point patrol
      aiPlanSetNumberVariableValues(defendPlan, cDefendPlanPatrolWaypoint, 4, true);
      aiPlanSetVariableVector(defendPlan, cDefendPlanPatrolWaypoint, 0, kbGetBlockPosition("2782"));
      aiPlanSetVariableVector(defendPlan, cDefendPlanPatrolWaypoint, 1, kbGetBlockPosition("2977"));
      aiPlanSetVariableVector(defendPlan, cDefendPlanPatrolWaypoint, 2, kbGetBlockPosition("2797"));
      aiPlanSetVariableVector(defendPlan, cDefendPlanPatrolWaypoint, 3, kbGetBlockPosition("2975"));
      aiPlanSetVariableBool(defendPlan, cDefendPlanPatrol, 0, true);

      //aiPlanSetNumberVariableValues(defendPlan, cDefendPlanPatrolWaypoint, 2, true);
      //aiPlanSetVariableVector(defendPlan, cDefendPlanPatrolWaypoint, 0, pointA);
      //aiPlanSetVariableVector(defendPlan, cDefendPlanPatrolWaypoint, 1, pointB);

      aiPlanSetActive(defendPlan);
   }


   xsEnableRule("useSpy");
   xsEnableRule("scout");
   xsEnableRule("attackGenerator");
}


// Called via trigger, tells us to get wall/tower upgrades
void upgrade(int parm=-1)
{
   aiEcho("Upgrade function called");
   xsEnableRuleGroup("upgradeGroup");

}


// Called via trigger, cancel last offensive plan and put all units on defense.
void defend(int parm=-1)
{
   aiEcho("Defend function called.");
   defendOnly = true;
   aiPlanDestroy(lastAttackPlan);
}




// Used to delete units that are being replaced by a new type.
void deleteObsoleteUnits(int unitType=cUnitTypeUnit, int player=2, vector center=vector(-1,-1,-1), float radius = 20.0, float percent=1.00)
{
   // Make query
   int query = -1;
   int count = -1;

   query = kbUnitQueryCreate("Unit deletion query");
   if ( configQuery(query, unitType, -1, cUnitStateAlive, player, center, false, radius) == false)
      return;
   kbUnitQueryResetResults(query);
   count = kbUnitQueryExecute(query);
   
   // Iterate list, deleting percentage indicated
   float remainder=0.0; // Used to handle percentages, when this gets >= 1, it's time to delete a unit.
   
   for (i=0; <count)
   {
      remainder = remainder + percent;
      if (remainder >= 1.0)   // time to delete one
      {
         aiTaskUnitDelete(kbUnitQueryGetResult(query,i));
         remainder = remainder - 1.0;
      }
   }
}


void age2EventHandler(int bogus=-1)
{
   xsEnableRule("goToAge3");
   xsEnableRule("getAge2UnitUpgrades");
   xsEnableRule("getAge2ArmoryUpgrades");
//   int oldUnit = cUnitTypeSpearman;

   switch(aiRandInt(3)) // Select a rax unit
   {
   case 0:
      {
         longhouseUnit = cUnitTypeUlfsark;
         break;
      }
   case 1:
      {
         longhouseUnit = cUnitTypeRaidingCavalry;
         break;
      }
   case 2:
      {
         longhouseUnit = cUnitTypeThrowingAxeman;
         break;
      }
   }
   aiEcho("Longhouse unit is "+kbGetProtoUnitName(longhouseUnit));
   longhouseMaintainID = maintainUnit(longhouseUnit, longhouseMaintainQty, kbGetBlockPosition(cbLonghouseGather), longhouseMaintainDelay);
//   if (longhouseUnit != oldUnit)
//   {
//      deleteObsoleteUnits(oldUnit, 2, kbGetBlockPosition(cbLonghouseGather), 20, .5);   // Delete half of the old units
//      aiEcho("Deleting units: "+kbGetProtoUnitName(oldUnit));
//   }

   xsEnableRule("useUndermine");

}



void age3EventHandler(int bogus=-1)
{

   if (age4Time > 0) // May be suppressed for difficulty
      xsEnableRule("goToAge4");
   xsEnableRule("getAge3UnitUpgrades");
   xsEnableRule("getAge3ArmoryUpgrades");

   int oldUnit = longhouseUnit;
   switch(aiRandInt(3)) // Re-select a rax unit
   {
   case 0:
      {
         longhouseUnit = cUnitTypeUlfsark;
         break;
      }
   case 1:
      {
         longhouseUnit = cUnitTypeRaidingCavalry;
         break;
      }
   case 2:
      {
         longhouseUnit = cUnitTypeThrowingAxeman;
         break;
      }
   }
   aiEcho("Longhouse unit is "+kbGetProtoUnitName(longhouseUnit));
	aiPlanSetVariableInt(longhouseMaintainID, cTrainPlanUnitType, 0, longhouseUnit);
   if (longhouseUnit != oldUnit)
   {
      deleteObsoleteUnits(oldUnit, 2, kbGetBlockPosition(cbFinalGate), 50, .5);   // Delete half of the old units
      aiEcho("Deleting units: "+kbGetProtoUnitName(oldUnit));
   }

   switch(aiRandInt(3)) // Select a hillfort unit
   {
   case 0:
      {
         hillfortUnit = cUnitTypeJarl;
         break;
      }
   case 1:
      {
         hillfortUnit = cUnitTypeHuskarl;
         break;
      }
   case 2:
      {
         hillfortUnit = cUnitTypePortableRam;
         break;
      }
   }
   aiEcho("Hillfort unit is "+kbGetProtoUnitName(hillfortUnit));
   hillfortMaintainID = maintainUnit(hillfortUnit, hillfortMaintainQty, kbGetBlockPosition(cbHillfortGather), hillfortMaintainDelay);

   switch(aiRandInt(2)) // Select a myth unit
   {
   case 0:
      {
         mythUnit = cUnitTypeEinheriar;
         break;
      }
   case 1:
      {
         mythUnit = cUnitTypeBattleBoar;
         break;
      }
   }
   aiEcho("Myth unit is "+kbGetProtoUnitName(mythUnit));
   mythMaintainID = maintainUnit(mythUnit, mythMaintainQty, kbGetBlockPosition(cbTempleGather), mythMaintainDelay);

   xsEnableRule("useFlamingWeapons");
}



void age4EventHandler(int bogus=-1)
{
   xsEnableRule("getAge4UnitUpgrades");
   xsEnableRule("getAge4ArmoryUpgrades");



   int oldUnit = longhouseUnit;
   switch(aiRandInt(3)) // Re-select a rax unit
   {
   case 0:
      {
         longhouseUnit = cUnitTypeThrowingAxeman;
         break;
      }
   case 1:
      {
         longhouseUnit = cUnitTypeUlfsark;
         break;
      }
   case 2:
      {
         longhouseUnit = cUnitTypeRaidingCavalry;
         break;
      }
   }
   aiEcho("Longhouse unit is "+kbGetProtoUnitName(longhouseUnit));
	aiPlanSetVariableInt(longhouseMaintainID, cTrainPlanUnitType, 0, longhouseUnit);
   if (longhouseUnit != oldUnit)
   {
      deleteObsoleteUnits(oldUnit, 2, kbGetBlockPosition(cbFinalGate), 50, .5);   // Delete half of the old units
      aiEcho("Deleting units: "+kbGetProtoUnitName(oldUnit));
   }

   oldUnit = hillfortUnit;
   switch(aiRandInt(3)) // Re-select a hillfort unit
   {
   case 0:
      {
         hillfortUnit = cUnitTypeJarl;
         break;
      }
   case 1:
      {
         hillfortUnit = cUnitTypeHuskarl;
         break;
      }
   case 2:
      {
         hillfortUnit = cUnitTypePortableRam;
         break;
      }
   }
   aiEcho("Hillfort unit is "+kbGetProtoUnitName(hillfortUnit));
   aiPlanSetVariableInt(hillfortMaintainID, cTrainPlanUnitType, 0, hillfortUnit);
   if (hillfortUnit != oldUnit)
   {
      deleteObsoleteUnits(oldUnit, 2, kbGetBlockPosition(cbFinalGate), 50, .5);   // Delete half of the old units
      aiEcho("Deleting units: "+kbGetProtoUnitName(oldUnit));
   }


   oldUnit = mythUnit;
   switch(aiRandInt(3)) // Re-select a myth unit
   {
   case 0:
      {
         mythUnit = cUnitTypeEinheriar;
         break;
      }
   case 1:
      {
         mythUnit = cUnitTypeBattleBoar;
         break;
      }
   case 2:
      {
         mythUnit = cUnitTypeFrostGiant;
         break;
      }
   }
   aiEcho("Myth unit is "+kbGetProtoUnitName(hillfortUnit));
   aiPlanSetVariableInt(mythMaintainID, cTrainPlanUnitType, 0, mythUnit);
   if (mythUnit != oldUnit)
   {
      deleteObsoleteUnits(oldUnit, 2, kbGetBlockPosition(cbFinalGate), 50, .5);   // Delete half of the old units
      aiEcho("Deleting units: "+kbGetProtoUnitName(oldUnit));
   }



   //xsEnableRule("useNidhogg");  disabled 9/6/2002
}




void attack(int size=0)
{
   if (defendOnly == true)
      return;

   int   attackID=aiPlanCreate("Attack at "+timeString(true)+" ", cPlanAttack);
   if (attackID < 0)
      return;

   if (aiPlanSetVariableInt(attackID, cAttackPlanPlayerID, 0, 1) == false)
      return;

   if (aiPlanSetNumberVariableValues(attackID, cAttackPlanTargetTypeID, 3, true) == false)
      return;

   aiPlanSetVariableInt(attackID, cAttackPlanTargetTypeID, 0, cUnitTypeUnit);
   aiPlanSetVariableInt(attackID, cAttackPlanTargetTypeID, 1, cUnitTypeBuilding);
   aiPlanSetVariableInt(attackID, cAttackPlanTargetTypeID, 2, cUnitTypeAbstractWall);

   switch(aiRandInt(4))    // Pick a random path
   {
   case 0:
      {
         aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, routeWest);
         break;
      }
   case 1:
      {
         aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, routeWestCenter);
         break;
      }
   case 2:
      {
         aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, routeEastCenter);
         break;
      }
   case 3:
      {
         aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, routeEast);
         break;
      }
   }
 
   aiPlanSetVariableVector(attackID, cAttackPlanGatherPoint, 0, kbGetBlockPosition(cbAttackGather));
   aiPlanSetVariableFloat(attackID, cAttackPlanGatherDistance, 0, 20.0);

   switch(kbGetAge())      // Set the targets and unit composition
   {
   case cAge1:
      {  
         aiPlanAddUnitType(attackID, cUnitTypeMilitary, 1, size, size);
//         aiPlanAddUnitType(attackID, cUnitTypePriest, 1, 1, 1);
//         aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 0, queryP1Units);
         break;
      }
   case cAge2:
      {  // Longhouse unit
         aiPlanAddUnitType(attackID, longhouseUnit, 1, size, size);
//         aiPlanAddUnitType(attackID, cUnitTypePriest, 1, size/4, size/4);
//         aiPlanSetNumberVariableValues(attackID, cAttackPlanQueryID, 2);
 //        aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 0, queryP1Farms);
//         aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 1, queryP1Units);
         break;
      }
   case cAge3:
      {  // 
         aiPlanAddUnitType(attackID, longhouseUnit, 1, (size+1)/2, (size+1)/2);
         aiPlanAddUnitType(attackID, hillfortUnit, 1, (size+2)/4, (size+2)/4);
//         aiPlanAddUnitType(attackID, cUnitTypePriest, 0, 1, 1);
         aiPlanAddUnitType(attackID, cUnitTypeMythUnit, 0, (size+2)/4, (size+2)/4);
//         aiPlanSetNumberVariableValues(attackID, cAttackPlanQueryID, 3);
//         aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 0, queryP1Monuments);
//         aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 1, queryP1Units);        
//         aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 2, queryP1Buildings); 
         break;
      }
   case cAge4:
      {  
         aiPlanAddUnitType(attackID, longhouseUnit, 1, (size+1)/2, (size+1)/2);
         aiPlanAddUnitType(attackID, hillfortUnit, 1, (size+2)/4, (size+2)/4);
//         aiPlanAddUnitType(attackID, cUnitTypePriest, 0, 1, 1);
         aiPlanAddUnitType(attackID, cUnitTypeMythUnit, 0, (size+2)/4, (size+2)/4);
//         aiPlanSetNumberVariableValues(attackID, cAttackPlanQueryID, 3);
//         aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 0, queryP1Monuments);
//         aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 1, queryP1Units);        
//         aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 2, queryP1Buildings); 

         break;
      }
   }

   aiPlanSetUnitStance(attackID, cUnitStanceAggressive);

   aiPlanSetInitialPosition(attackID, kbGetBlockPosition(cbAttackGather));
   aiPlanSetRequiresAllNeedUnits(attackID, true);
   aiPlanSetDesiredPriority(attackID, 50);   // Less than scouting, more than defense
   aiPlanSetActive(attackID);
   aiEcho("Activating attack plan "+attackID+" with appx "+size+" units.");
   lastAttackPlan = attackID; // update the global var
}




void main()
{
   aiEcho("Starting Scn30p2.xs");

   //Calculate some areas.
   kbAreaCalculate(1200.0);
   aiRandSetSeed();
   kbSetTownLocation(kbGetBlockPosition(cbP2TC));

   aiSetAgeEventHandler(cAge2, "age2EventHandler");
   aiSetAgeEventHandler(cAge3, "age3EventHandler");
   aiSetAgeEventHandler(cAge4, "age4EventHandler");

   // Set difficulty vars
   difficulty = aiGetWorldDifficulty();
   aiEcho("Difficulty = "+difficulty);   

   switch(difficulty)      // Set up the attack control and age-up parameters
   {
   case 0:     // Easy
      {
         nextAttackTime = 300000;   // 5 min
         attackInterval = 240000;   // 4 min
         attackSize = 2.0;          
         attackMultiplier = 1.1;    // 10% per 4 min
         maxAttackSize = 7;
         longhouseMaintainQty = 6;
         hillfortMaintainQty = 3;
         mythMaintainQty = 2;
         age2Time = 900000;   // 15 min
         age3Time = 1800000;  // 30 min
         age4Time = -1;       // Not permitted
         break;
      }
   case 1:     // Moderate
      {
         nextAttackTime = 240000;
         attackInterval = 200000;
         attackSize = 3.0;
         attackMultiplier = 1.2;    // 20% per 4 min
         maxAttackSize = 15;
         longhouseMaintainQty = 10;
         hillfortMaintainQty = 5;
         mythMaintainQty = 3;
         age2Time = 360000;   // 6 min
         age3Time = 960000;  // 16 min
         age4Time = 1560000;  // 26 min
         break;
      }
   case 2:     // Difficult
      {
         nextAttackTime = 120000;
         attackInterval = 140000;
         attackSize = 6.0;
         attackMultiplier = 1.3;    // 30% n
         maxAttackSize = 20;
         longhouseMaintainQty = 20;
         hillfortMaintainQty = 10;
         mythMaintainQty = 5;
         age2Time = 180000;  // 3 min
         age3Time = 480000;  // 8 min
         age4Time = 1080000; // 18 min
         break;
      }
   case 3:     // Nightmare
      {
         nextAttackTime = 60000;
         attackInterval = 120000;
         attackSize = 8.0;
         attackMultiplier = 1.4;    // 40% per 2 min
         maxAttackSize = 30;
         longhouseMaintainQty = 20;
         hillfortMaintainQty = 12;
         mythMaintainQty = 8;
         age2Time = 60000;  // 1 min
         age3Time = 360000;  // 6 min
         age4Time = 720000;  // 12 min
         break;
      }
   }

   // Init attack routes
   routeWest = attackRoute("West Attack Route",cbAttackGather, cbRouteWest1, cbRouteWest2, cbRouteWest3);
   routeWestCenter = attackRoute("West Center Attack Route",cbAttackGather, cbRouteWestCenter1, cbRouteWestCenter2, cbRouteWestCenter3);
   routeEastCenter = attackRoute("East Center Attack Route",cbAttackGather, cbRouteEastCenter1, cbRouteEastCenter2, cbRouteEastCenter3);
   routeEast = attackRoute("East Attack Route",cbAttackGather, cbRouteEast1, cbRouteEast2, cbRouteEast3);


}







// *****************************************************************************
//
// RULES
//
// *****************************************************************************

rule scout
   inactive
   minInterval 5
{
   // just set up an explore plan
   int exploreID = aiPlanCreate("Explore", cPlanExplore);
   if(exploreID >= 0)
   {
      aiPlanSetVariableFloat( exploreID, cExplorePlanLOSMultiplier,  0, 4.0 );
      aiPlanAddUnitType(exploreID, cUnitTypeRaidingCavalry, 1, 1, 1);
      aiPlanSetDesiredPriority(exploreID, 90);
      aiPlanSetActive(exploreID);
   }
   xsDisableSelf();
}





rule getWatchTower
   inactive
   minInterval 10
   group upgradeGroup
{
   if (kbGetTechStatus(cTechWatchTower) == cTechStatusAvailable)
   {
      int x=-1;
      x = aiPlanCreate("WatchTower", cPlanResearch);
      aiPlanSetVariableInt(x, cResearchPlanTechID, 0, cTechWatchTower);
      aiPlanSetActive(x);
      xsDisableSelf();
      aiEcho("Getting Watch Tower");
   }
}


rule getGuardTower
   inactive
   minInterval 10
   group upgradeGroup
{
   if (kbGetTechStatus(cTechGuardTower) == cTechStatusAvailable)
   {
      int x=-1;
      x = aiPlanCreate("WatchTower", cPlanResearch);
      aiPlanSetVariableInt(x, cResearchPlanTechID, 0, cTechGuardTower);
      aiPlanSetActive(x);
      xsDisableSelf();
      aiEcho("Getting Guard Tower");
   }
}



rule getBoilingOil
   inactive
   minInterval 10
   group upgradeGroup
{
   if (kbGetTechStatus(cTechBoilingOil) == cTechStatusAvailable)
   {
      int x=-1;
      x = aiPlanCreate("WatchTower", cPlanResearch);
      aiPlanSetVariableInt(x, cResearchPlanTechID, 0, cTechBoilingOil);
      aiPlanSetActive(x);
      xsDisableSelf();
      aiEcho("Getting Boiling Oil");
   }
}



rule getSafeguard
   inactive
   minInterval 10
   group upgradeGroup
{
   if (kbGetTechStatus(cTechSafeguard) == cTechStatusAvailable)
   {
      int x=-1;
      x = aiPlanCreate("WatchTower", cPlanResearch);
      aiPlanSetVariableInt(x, cResearchPlanTechID, 0, cTechSafeguard);
      aiPlanSetActive(x);
      xsDisableSelf();
      aiEcho("Getting Safeguard");
   }
}



rule getFortifiedWall
   inactive
   minInterval 10
   group upgradeGroup
{
   if (kbGetTechStatus(cTechFortifiedWall) == cTechStatusAvailable)
   {
      int x=-1;
      x = aiPlanCreate("WatchTower", cPlanResearch);
      aiPlanSetVariableInt(x, cResearchPlanTechID, 0, cTechFortifiedWall);
      aiPlanSetActive(x);
      xsDisableSelf();
      aiEcho("Getting Fortified Wall");
   }
}



rule getMasons
   inactive
   minInterval 10
   group upgradeGroup
{
   if (kbGetTechStatus(cTechMasons) == cTechStatusAvailable)
   {
      int x=-1;
      x = aiPlanCreate("WatchTower", cPlanResearch);
      aiPlanSetVariableInt(x, cResearchPlanTechID, 0, cTechMasons);
      aiPlanSetActive(x);
      xsDisableSelf();
      aiEcho("Getting Masons");
   }
}



rule getStoneWall
   inactive
   minInterval 10
   group upgradeGroup
{
   if (kbGetTechStatus(cTechStoneWall) == cTechStatusAvailable)
   {
      int x=-1;
      x = aiPlanCreate("WatchTower", cPlanResearch);
      aiPlanSetVariableInt(x, cResearchPlanTechID, 0, cTechStoneWall);
      aiPlanSetActive(x);
      xsDisableSelf();
      aiEcho("Getting Stone Wall");
   }
}

rule getBallistaTower
   inactive
   minInterval 10
   group upgradeGroup
{
   if (kbGetTechStatus(cTechBallistaTower) == cTechStatusAvailable)
   {
      int x=-1;
      x = aiPlanCreate("WatchTower", cPlanResearch);
      aiPlanSetVariableInt(x, cResearchPlanTechID, 0, cTechBallistaTower);
      aiPlanSetActive(x);
      xsDisableSelf();
      aiEcho("Getting Ballista Tower");
   }
}




rule goToAge2
   inactive
   minInterval 10
{
   if ( xsGetTime() < age2Time)
      return;
   researchTech(cTechAge2Heimdall);
   xsDisableSelf();
}



rule goToAge3
   inactive
   mininterval 20
{
   if ( xsGetTime() < age3Time )
      return;
   researchTech(cTechAge3Bragi);
   xsDisableSelf();
}


rule goToAge4
   inactive
   mininterval 20
{
   if ( xsGetTime() < age4Time )
      return;
   researchTech(cTechAge4Hel);
   xsDisableSelf();
}



rule getAge2UnitUpgrades
   inactive
   minInterval 20
{
   if ( xsGetTime() < (age2Time + age2Time + age3Time)/3 )
      return;     // Wait till 1/3 to age3
   researchTech(cTechMediumInfantry);
   researchTech(cTechMediumCavalry);
   xsDisableSelf();
}

rule getAge2ArmoryUpgrades
   inactive
   minInterval 20
{
   if ( xsGetTime() < (age2Time + age3Time + age3Time)/3 )
      return;     // Wait till 2/3 to age3
   aiEcho("Getting age 2 armory upgrades");
   researchTech(cTechCopperWeapons);
   researchTech(cTechCopperMail);
   researchTech(cTechCopperShields);
   xsDisableSelf();
}

rule getAge3UnitUpgrades
   inactive
   minInterval 20
{
   if ( xsGetTime() < (age3Time+180000) )
      return;
   researchTech(cTechHeavyInfantry);
   researchTech(cTechHeavyCavalry);
   xsDisableSelf();
}

rule getAge3ArmoryUpgrades
   inactive
   minInterval 20
{
   if ( xsGetTime() < (age3Time+300000) )
      return;
   researchTech(cTechBronzeWeapons);
   researchTech(cTechBronzeMail);
   researchTech(cTechBronzeShields);
   xsDisableSelf();
}

rule getAge4UnitUpgrades
   inactive
   minInterval 20
{
   if ( xsGetTime() < (age4Time+300000) )
      return;
   researchTech(cTechChampionInfantry);
   researchTech(cTechChampionCavalry);
   xsDisableSelf();
}

rule getAge4ArmoryUpgrades
   inactive
   minInterval 20
{
   if ( xsGetTime() < (age4Time+600000) )
      return;
   researchTech(cTechIronWeapons);
   researchTech(cTechIronMail);
   researchTech(cTechIronShields);
   xsDisableSelf();
}



rule attackGenerator
   minInterval 10
   inactive
{
   //aiEcho("attack check running, next time is "+nextAttackTime);
   if ( xsGetTime() < nextAttackTime )
      return;

   attack(attackSize);
   nextAttackTime = xsGetTime() + attackInterval;
   attackSize = attackSize * attackMultiplier;
   if (attackSize > maxAttackSize)
      attackSize = maxAttackSize;
   aiEcho("Next attack size will be "+attackSize+".");
}


/*
// Checks to see if a large P1 army is near the prison, if so, set off a swarm attack.
rule armyNearPrison
   inactive
   minInterval 15
{
   static int queryPrison=-1; // Used for unit count and targeting.
   int   count=0;
   int   attackID=-1;
   
   if (queryPrison < 0)
   {
      // Create query
      queryPrison = kbUnitQueryCreate("Prison query");
      if ( configQuery(queryPrison, cUnitTypeUnit, -1, cUnitStateAlive, 1, kbGetBlockPosition(cbNearPrison), false, 50) == false)
         return;
   }

   // Check for enemies
   kbUnitQueryResetResults(queryPrison);
   count = kbUnitQueryExecute(queryPrison);

   if (count < 6)
      return;



   // Rally units to defend...all units within 100 meters, to a maximum of 30 units
   aiEcho("Outer wall emergency.");
   attackID = aiPlanCreate("Prison Attack", cPlanAttack);
   count = getUnassignedUnitCount(kbGetBlockPosition(cbAttackGather), 100.0, 2, cUnitTypeMilitary);
   if (count > 30)
      count = 30;
   
   if (attackID < 0)
      return;

   if (aiPlanSetVariableInt(attackID, cAttackPlanPlayerID, 0, 1) == false)
      return;

   aiPlanSetNumberVariableValues(attackID, cAttackPlanQueryID, 2);
   aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 0, queryPrison);     // Attack units near prison, then
   aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 1, queryP1Units);    // Attack any units

   aiPlanSetVariableVector(attackID, cAttackPlanGatherPoint, 0, kbGetBlockPosition(cbAttackGather));
   aiPlanSetVariableFloat(attackID, cAttackPlanGatherDistance, 0, 10.0);

   aiPlanAddUnitType(attackID, cUnitTypeMilitary, 1, count, count );

   aiEcho("Responding with "+count+" units.");
   aiPlanSetInitialPosition(attackID, kbGetBlockPosition(cbAttackGather));
   aiPlanSetRequiresAllNeedUnits(attackID, true);
   aiPlanSetActive(attackID);
   xsDisableSelf();
}
*/


rule useSpy
   minInterval 5
   inactive
{
   if ( kbUnitVisible(kbGetBlockID("8")) == true )
   {
      aiCastGodPowerAtUnit(cTechSpy, kbGetBlockID("8"));
      aiEcho("Casting spy on Ajax");
      xsDisableSelf();
      return;
   }

   if ( kbUnitVisible(kbGetBlockID("10")) == true )
   {
      aiCastGodPowerAtUnit(cTechSpy, kbGetBlockID("10"));
      aiEcho("Casting spy on Chiron");
      xsDisableSelf();
      return;
   }

   if ( kbUnitVisible(kbGetBlockID("7")) == true )
   {
      aiCastGodPowerAtUnit(cTechSpy, kbGetBlockID("7"));
      aiEcho("Casting spy on Arkantos");
      xsDisableSelf();
      return;
   }

   if ( kbUnitVisible(kbGetBlockID("9")) == true )
   {
      aiCastGodPowerAtUnit(cTechSpy, kbGetBlockID("9"));
      aiEcho("Casting spy on Amanra");
      xsDisableSelf();
      return;
   }

   if ( kbUnitVisible(kbGetBlockID("25")) == true )
   {
      aiCastGodPowerAtUnit(cTechSpy, kbGetBlockID("25"));
      aiEcho("Casting spy on Reginleif");
      xsDisableSelf();
      return;
   }

}



rule useUndermine // Look for 2 walls near my army
   minInterval 5
   inactive
{
   int targetUnit = -1;
   int attackArmyID = -1;

   if (lastAttackPlan < 0)
      return;
   vector pVec = aiPlanGetLocation(lastAttackPlan);
   if (xsVectorGetX(pVec)<0)
      return;

   static int tempQuery = -1;
   if (tempQuery < 0)
   {  // Doesn't exist, set it up
      tempQuery = kbUnitQueryCreate("useUndermine");

      if ( configQuery(tempQuery, cUnitTypeAbstractWall, -1, cUnitStateAliveOrBuilding, 1, pVec, true, 25) == false)
         return;
   }
   else
      kbUnitQuerySetPosition(tempQuery, pVec); // Because pVec changes as army moves

   kbUnitQueryResetResults(tempQuery);
   int targetCount = kbUnitQueryExecute(tempQuery);  

   if (targetCount < 2)
      return;
   targetUnit = kbUnitQueryGetResult(tempQuery, 0);  // grab first wall

   // confirm LOS
   if ( kbUnitVisible(targetUnit) != true )
   {
      aiEcho("Undermine: Don't have LOS for unit "+targetUnit+" "+kbGetProtoUnitName(targetUnit));
      return;
   }

   aiEcho("Using Undermine at "+kbUnitGetPosition(targetUnit));
   if ( aiCastGodPowerAtPosition(cTechUndermine, kbUnitGetPosition(targetUnit)) == true)
      xsDisableSelf();
   else 
      aiEcho("Undermine failed at "+kbUnitGetPosition(targetUnit));
}



rule useFlamingWeapons // Look for 6 military units near my army
   minInterval 5
   inactive
{
   int targetUnit = -1;
   int attackArmyID = -1;

   if (lastAttackPlan < 0)
      return;
   vector pVec = aiPlanGetLocation(lastAttackPlan);
   if (xsVectorGetX(pVec)<0)
      return;

   static int tempQuery = -1;
   if (tempQuery < 0)
   {  // Doesn't exist, set it up
      tempQuery = kbUnitQueryCreate("useFlamingWeapons");

      if ( configQuery(tempQuery, cUnitTypeMilitary, -1, cUnitStateAlive, 1, pVec, true, 50) == false)
         return;
   }
   else
      kbUnitQuerySetPosition(tempQuery, pVec); // Because pVec changes as army moves

   kbUnitQueryResetResults(tempQuery);
   int targetCount = kbUnitQueryExecute(tempQuery);  

   if (targetCount < 6)
      return;
//   targetUnit = kbUnitQueryGetResult(tempQuery, targetCount/2);  // grab middle farm

// confirm that we have at least 6 miltary units there
   static int query2 = -1;
   if (query2 < 0)
   {
      query2 = kbUnitQueryCreate("useFlamingWeapons2");
      configQuery(query2, cUnitTypeMilitary, -1, cUnitStateAlive, 2, pVec, true, 25);
   }
   kbUnitQuerySetPosition(query2, pVec);
   kbUnitQueryResetResults(query2);
   targetCount = kbUnitQueryExecute(query2);
   if (targetCount < 6)
      return;     // Army too small

   aiEcho("Using FlamingWeapons");
   if ( aiCastGodPowerAtPosition(cTechFlamingWeapons, kbUnitGetPosition(kbUnitQueryGetResult(query2, targetCount/2))) == true)
      xsDisableSelf();
   else 
      aiEcho("FlamingWeapons failed on "+kbUnitQueryGetResult(query2, targetCount/2));
}


rule useNidhogg
   minInterval 5
   inactive
{
   if (defendOnly == false)
      return;

   aiEcho("Invoking Nidhogg on final gate.");
   aiCastGodPowerAtPosition(cTechNidhogg, kbGetBlockPosition(cbFinalGate));
   xsDisableSelf();
}

