//==============================================================================
// Scn29p7: AI Scenario Script for scenario 29 player 7
//==============================================================================
/*
   AI owner:  Dave Leary
   Scenario owner: Joe Gillum/Jerome Jones

   Difficulty Level Notes: Trains ballistae in increasing numbers on higher
	levels.  Size of giant armies is also increased.
*/
//==============================================================================
// Difficulty Level check predeclared.
//==============================================================================
int difflevel=-1;		

// Variable for main base.
int gMainBaseID=-1;

//Shared variables.
int numberAttacks=0;
int attackPlayerID=-1;

//Attack 1 vars.
int attackPlan1ID=-1;
int maintainPlan1ID=-1;

// Route and path vars.
int attackRoute1ID=-1;
int attackPath1ID=-1;

// Unit types
int attackerUnitTypeID1=cUnitTypeMountainGiant;
int attackerUnitTypeID2=cUnitTypeFrostGiant;

//==============================================================================
// Set Town Location
//==============================================================================
void setTownLocation(void)
{
   //Look for the "Town Location" marker.
   kbSetTownLocation(kbGetBlockPosition("365585"));
}

//==============================================================================
// miscStartup
//==============================================================================
void miscStartup(void)
{
	// Get the difficulty level.
	difflevel=aiGetWorldDifficulty();

   //Startup message(s).
   aiEcho("");
   aiEcho("");
   aiEcho("Scn29P7 AI Start, filename='"+cFilename+"'.");
   //Spit out the map size.
   aiEcho("Map size is ("+kbGetMapXSize()+", "+kbGetMapZSize()+").");
	aiEcho("Difficulty Level="+difflevel+".");

   //Cheat like a bastard.  Once only, though.
   kbLookAtAllUnitsOnMap();
   //Calculate some areas.
   kbAreaCalculate(1200.0);
   //Set our town location.
   setTownLocation();
	
	//Allocate all resources to the root escrow by setting percentage of military/economy to 0.
	kbEscrowSetPercentage( cEconomyEscrowID, cAllResources, 0.0 );
	kbEscrowSetPercentage( cMilitaryEscrowID, cAllResources, 0.0 );

	//Allocate all resources 
   kbEscrowAllocateCurrentResources();

	//Reset random seed
	aiRandSetSeed();

	// Diff level adjustments
	if ( difflevel > 0 )
	{
		attackerUnitTypeID2=cUnitTypeMountainGiant;
	}

	if ( difflevel > 1 )
	{
		attackerUnitTypeID1=cUnitTypeMountainGiant;
		attackerUnitTypeID2=cUnitTypeFireGiant;
	}

	if ( difflevel == 3 )
	{
		attackerUnitTypeID1=cUnitTypeFireGiant;
		attackerUnitTypeID2=cUnitTypeFrostGiant;
	}
}

//==============================================================================
//==============================================================================
// Attack stuff.
//==============================================================================
//==============================================================================

//==============================================================================
// initAttack: Creates attack routes, etc.
//==============================================================================
void initAttack(int playerID=-1)
{
   //Destroy all previous attacks (if this isn't the player we're already attacking.
   if (playerID != attackPlayerID)
   {
      //Reset the attack player ID.
      attackPlayerID=-1;
      //Destroy any previous attack plan.
      aiPlanDestroy(attackPlan1ID);
      attackPlan1ID=-1;

      //Destroy our previous attack paths.
      kbPathDestroy(attackPath1ID);
      attackPath1ID=-1;

      //Destroy our previous attack routes.  
      attackRoute1ID=-1;

      //Reset the number of attacks.
      numberAttacks=0;
   }

   //Save the player to attack.
   attackPlayerID=playerID;

   vector gatherPoint=kbGetBlockPosition("365585");
   
	//Setup attack path 1 - go left
   attackPath1ID=kbPathCreate("Attack Path 1");
   kbPathAddWaypoint(attackPath1ID, kbGetBlockPosition("365586"));
   //Create attack route 1.
   attackRoute1ID=kbCreateAttackRouteWithPath("Attack Route 1", gatherPoint, kbGetBlockPosition("365587"));
   
	if (attackRoute1ID >= 0)
      kbAttackRouteAddPath(attackRoute1ID, attackPath1ID);

}

//==============================================================================
// setupBaseAttack - the primary attack setup.
// Prioritizes enemy units instead of buildings.
//==============================================================================
bool setupBaseAttack(int playerID=-1)
{
	difflevel=aiGetWorldDifficulty();

   // If we have enough unassigned military units of the core type, bail.
   int numberAvailableUnits1=aiNumberUnassignedUnits(attackerUnitTypeID1);
	vector gatherPoint=kbGetBlockPosition("365585");
   
	// Bail if things ain't looking right, to avoid nasty idle attack plans.
	aiEcho("There are "+numberAvailableUnits1+" base giants available for a new attack.");
	if (numberAvailableUnits1 < 1)
		return( false );
	   
	//Info.
	aiEcho("Attacking Player "+playerID+".");

   //If the player to attack doesn't match, init the attack.
   if (attackPlayerID != playerID)
   {
      initAttack(playerID);
      if (attackPlayerID < 0)
         return(false);
   }

   //Create an attack plan.
   int newAttackPlanID=aiPlanCreate("Attack Player"+attackPlayerID+" Attempt"+numberAttacks, cPlanAttack);
   if (newAttackPlanID < 0)
      return(false);

   //Target player (required).  This must work.
   if (aiPlanSetVariableInt(newAttackPlanID, cAttackPlanPlayerID, 0, attackPlayerID) == false)
      return(false);

	//Set the target type.  This must work.
   if (aiPlanSetNumberVariableValues(newAttackPlanID, cAttackPlanTargetTypeID, 2, true) == false)
      return(false);

   //Unit types to attack.
   aiPlanSetVariableInt(newAttackPlanID, cAttackPlanTargetTypeID, 0, cUnitTypeBuilding);
	aiPlanSetVariableInt(newAttackPlanID, cAttackPlanTargetTypeID, 1, cUnitTypeUnit);

	aiPlanSetVariableInt(newAttackPlanID, cAttackPlanAttackRouteID, 0, attackRoute1ID);
	aiPlanSetVariableVector(newAttackPlanID, cAttackPlanGatherPoint, 0, gatherPoint);
   aiPlanSetInitialPosition(newAttackPlanID, gatherPoint);

   //Set the gather point distance
   aiPlanSetVariableFloat(newAttackPlanID, cAttackPlanGatherDistance, 0, 20.0);

   //Set up the attack route usage pattern
   aiPlanSetVariableInt(newAttackPlanID, cAttackPlanAttackRoutePattern, 0, cAttackPlanAttackRoutePatternRandom);
   
	//Add the unit types to the plan.  Difflevel affects what's up here.
	if ( difflevel < 2 )
	{
		aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID1, 1, 2, 2);
	}
	else
	{
		aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID1, 1, 4, 4);
	}

	if ( difflevel < 3 )
	{
		aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID2, 0, 1, 1);
	}
	else
	{
		aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID2, 0, 2, 2);
	}

	// Add ballista if you got any.
	aiPlanAddUnitType(newAttackPlanID, cUnitTypeBallista, 0, 3, 3);
	
   //Plan requires all need units to work (can be false)
   aiPlanSetRequiresAllNeedUnits(newAttackPlanID, true);
   //Activate the plan.
   aiPlanSetActive(newAttackPlanID);

   //Now, save the attack plan ID appropriately
   aiPlanSetOrphan(attackPlan1ID, true);
   attackPlan1ID=newAttackPlanID;

   //Increment our overall number of attacks
   numberAttacks++;
}

//==============================================================================
// Attack Generator 1 - Base attack, every two minutes, once activated.
//==============================================================================
rule attackGenerator1
   minInterval 150
   inactive
   group AttackRules
{
   // See how many "idle" attack plans we have.  Don't create any more if we have
   // idle plans.
   int numberIdleAttackPlans=aiGetNumberIdlePlans(cPlanAttack);

   if (numberIdleAttackPlans > 0)
      return;

	setupBaseAttack(1);
}

//==============================================================================
// Favor cheat - grant 30 favor every 45 seconds.
//==============================================================================
rule favorCheat
   minInterval 45
   inactive
   group AttackRules
{
	// Cheat for favor.  It's tough to be Norse.
	aiResourceCheat( 7, cResourceFavor, 45.0 );
}


//==============================================================================
// templeActivate - triggered with an AI FUNC to get everything rolling.
//==============================================================================
void templeActivate( int parameter=-1 )
{
	aiEcho("*** PLAYER 7 AI: Temple activated, training and sending giant groups.");
	// Enable favor generation and training fun.
	xsEnableRule("attackGenerator1");
	xsEnableRule("favorCheat");
}

//==============================================================================
// MAIN 
//==============================================================================
void main(void)
{
	difflevel=aiGetWorldDifficulty();

   //Startup.
   miscStartup();

   //Share a common gather point.
   vector gatherPoint=kbGetBlockPosition("365585");
	vector gatherPoint2=kbGetBlockPosition("367253");

   //Maintain 2 of the first giant type...unless diff level is higher.
   int maintainPlan1ID=aiPlanCreate("Maintain 2 "+kbGetProtoUnitName(attackerUnitTypeID1), cPlanTrain);
   if (maintainPlan1ID >= 0)
   {
		//Must set the type of unit to train.
      aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanUnitType, 0, attackerUnitTypeID1);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
		if ( difflevel < 2 )
		{
			aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanNumberToMaintain, 0, 2);
		}
		else
		{
			aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanNumberToMaintain, 0, 4);
		}
      //Don't train units faster than every 25 seconds.
		if ( difflevel < 2 )
		{
			aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanFrequency, 0, 60);
		}
		else
		{
			aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanFrequency, 0, 30);
		}
      //Set a gather point.
      aiPlanSetVariableVector(maintainPlan1ID, cTrainPlanGatherPoint, 0, gatherPoint);
      //Activate the plan.
      aiPlanSetActive(maintainPlan1ID);
   }

	//Maintain 2 of the second giant type (though we only ever send one in an attack group).
   int maintainPlan2ID=aiPlanCreate("Maintain 1 "+kbGetProtoUnitName(attackerUnitTypeID2), cPlanTrain);
   if (maintainPlan2ID >= 0)
   {
		//Must set the type of unit to train.
      aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanUnitType, 0, attackerUnitTypeID2);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
      aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanNumberToMaintain, 0, 2);
     //Don't train units faster than every 40 seconds
      aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanFrequency, 0, 120);
      //Set a gather point.
      aiPlanSetVariableVector(maintainPlan2ID, cTrainPlanGatherPoint, 0, gatherPoint);
      //Activate the plan.
      aiPlanSetActive(maintainPlan2ID);
   }

	if ( difflevel > 0 )
	{
		//Maintain ballistae!
		int maintainPlan3ID=aiPlanCreate("Maintain "+kbGetProtoUnitName(cUnitTypeBallista), cPlanTrain);
		if (maintainPlan3ID >= 0)
		{
			//Must set the type of unit to train.
			aiPlanSetVariableInt(maintainPlan3ID, cTrainPlanUnitType, 0, cUnitTypeBallista);
			//Set the number of units to maintain in the world at one time.
			if ( difflevel == 1 )
			{
				aiPlanSetVariableInt(maintainPlan3ID, cTrainPlanNumberToMaintain, 0, 1);
				aiPlanSetVariableInt(maintainPlan3ID, cTrainPlanFrequency, 0, 90);
			}
			else if ( difflevel == 2 )
			{
				aiPlanSetVariableInt(maintainPlan3ID, cTrainPlanNumberToMaintain, 0, 2);
				aiPlanSetVariableInt(maintainPlan3ID, cTrainPlanFrequency, 0, 60);
			}
			else if ( difflevel == 3 )
			{
				aiPlanSetVariableInt(maintainPlan3ID, cTrainPlanNumberToMaintain, 0, 3);
				aiPlanSetVariableInt(maintainPlan3ID, cTrainPlanFrequency, 0, 45);
			}
			//Set a gather point.
			aiPlanSetVariableVector(maintainPlan3ID, cTrainPlanGatherPoint, 0, gatherPoint);
			//Activate the plan.
			aiPlanSetActive(maintainPlan3ID);
		}
	}
}