//==============================================================================
// Scn27p6: AI Scenario Script for scenario 27 player 6
//==============================================================================
/*
   AI owner:  Dave Leary
   Scenario owner: Joe "The Golem" Gillum

   Overview: Very basic AI script to handle the units (giants) that spawn
	in the channels to the west and east. It also handles the big "giant pushes"
	at the end of the scenario.
	
	The early giant attacks as the player first moves up the pass are handled 
	with triggers.

   This AI simply takes all units that are spawned and moves them to the 
	player's town center.  Pacing and size of attacks are controlled by the
	scenario designer via trigger.

*/
//==============================================================================
include "scn lib.xs";

// Used to search for spawned CP military units
int westStartQuery = -1;
int eastStartQuery = -1;

int westFinalStartQuery = -1;
int eastFinalStartQuery = -1;
int southFinalStartQuery = -1;

//==============================================================================
// Set Town Location
//==============================================================================
void setTownLocation(void)
{
   //Look for the "Town Location" marker.
   kbSetTownLocation(kbGetBlockPosition("3989"));
}

//==============================================================================
// miscStartup
//==============================================================================
void miscStartup(void)
{
   //Startup message(s).
   aiEcho("");
   aiEcho("");
   aiEcho("Scn27P2 AI Start, filename='"+cFilename+"'.");
   //Spit out the map size.
   aiEcho("  Map size is ("+kbGetMapXSize()+", "+kbGetMapZSize()+").");
   //Cheat like a bastard.  Once only, though.
   kbLookAtAllUnitsOnMap();
   //Calculate some areas.
   kbAreaCalculate(1200.0);
   //Set our town location.
   setTownLocation();
	//Reset random seeds
	aiRandSetSeed();
   //Allocate all resources
   kbEscrowAllocateCurrentResources();
}

//==============================================================================
// FUNCTIONS
//==============================================================================
void launchAttack(vector start=vector(-1,-1,-1), int query=-1, int count=-1)
{
   int attackID = aiPlanCreate("Attack at "+(xsGetTime()/1000), cPlanAttack);

   if (attackID < 0)
      return;

   // Attack player #1.
	if (aiPlanSetVariableInt(attackID, cAttackPlanPlayerID, 0, 1) == false)
      return;

   aiPlanSetVariableVector(attackID, cAttackPlanGatherPoint, 0, start);
   aiPlanSetVariableFloat(attackID, cAttackPlanGatherDistance, 0, 50.0);
   aiPlanSetInitialPosition( attackID, start);
   aiPlanAddUnitType(attackID, cUnitTypeMythUnit, 1, count, count);

	aiPlanSetNumberVariableValues(attackID, cAttackPlanTargetTypeID, 2, true);

	//Target unit types to attack 
	aiPlanSetVariableInt(attackID, cAttackPlanTargetTypeID, 0, cUnitTypeBuilding);
	aiPlanSetVariableInt(attackID, cAttackPlanTargetTypeID, 1, cUnitTypeUnit);
   
	// Needs all units listed - get 'em all!
   aiPlanSetRequiresAllNeedUnits(attackID, true);
   aiPlanSetActive(attackID);
}

// MAIN SPAWN GIANTS AI FUNC - called via trigger when an army is available in one of the channels.
// ChannelID indicates which channel has the units.
void spawnGiants(int channelID=-1)
{
	// Locations for spawning fun
	vector spawnLocationWest=kbGetBlockPosition("1571350");
	vector spawnLocationEast=kbGetBlockPosition("1571349");
	
	vector spawnLocationWestFinal=kbGetBlockPosition("1571802");
	vector spawnLocationSouthFinal=kbGetBlockPosition("1571803");
	vector spawnLocationEastFinal=kbGetBlockPosition("1571804");

   int targetCount = -1;

   aiEcho("Spawn Giants firing, channelID = "+channelID);
   switch(channelID)
   {
		case 0:
      {
         //check west
         targetCount = getUnassignedUnitCount(spawnLocationWest, 50.0, 6, cUnitTypeMythUnit);
         aiEcho("Found "+targetCount+" myth units in the west channel.");
         if (targetCount > 0)
         {
            launchAttack(spawnLocationWest, westStartQuery, targetCount);
         }
			break;
      }
		case 1:
      {
         //check east
         targetCount = getUnassignedUnitCount(spawnLocationEast, 50.0, 6, cUnitTypeMythUnit);
         aiEcho("Found "+targetCount+" myth units in the east channel.");
         if (targetCount > 0)
         {
            launchAttack(spawnLocationEast, eastStartQuery, targetCount);
         }
         break;
      }
		case 2:
		{
			//west final version
         targetCount = getUnassignedUnitCount(spawnLocationWestFinal, 50.0, 6, cUnitTypeMythUnit);
         aiEcho("Found "+targetCount+" myth units in the west (final) channel.");
         if (targetCount > 0)
         {
            launchAttack(spawnLocationWestFinal, westFinalStartQuery, targetCount);
         }
			break;
		}
		case 3:
		{
			//south final version
         targetCount = getUnassignedUnitCount(spawnLocationSouthFinal, 50.0, 6, cUnitTypeMythUnit);
         aiEcho("Found "+targetCount+" myth units in the south (final) channel.");
         if (targetCount > 0)
         {
            launchAttack(spawnLocationSouthFinal, southFinalStartQuery, targetCount);
         }
         break;
		}

		case 4:
		{
			//east final version
         targetCount = getUnassignedUnitCount(spawnLocationEastFinal, 50.0, 6, cUnitTypeMythUnit);
         aiEcho("Found "+targetCount+" myth units in the east (final) channel.");
         if (targetCount > 0)
         {
            launchAttack(spawnLocationEastFinal, eastFinalStartQuery, targetCount);
         }
         break;
		}
   }
}

//==============================================================================
// MAIN.
//==============================================================================
void main(void)
{
	// Locations for spawning fun
	vector spawnLocationWest=kbGetBlockPosition("1571350");
	vector spawnLocationEast=kbGetBlockPosition("1571349");

	vector spawnLocationWestFinal=kbGetBlockPosition("1571802");
	vector spawnLocationSouthFinal=kbGetBlockPosition("1571803");
	vector spawnLocationEastFinal=kbGetBlockPosition("1571804");


	miscStartup();

	// Set up the two queries.
	westStartQuery = kbUnitQueryCreate("checkWestStart");    // Look for CP units
   if ( configQuery(westStartQuery, cUnitTypeMythUnit, -1, cUnitStateAlive, 2, spawnLocationWest, true, 30) == false)
      aiEcho("Query failed");

   eastStartQuery = kbUnitQueryCreate("checkEastStart");    // Look for CP units
   if ( configQuery(eastStartQuery, cUnitTypeMythUnit, -1, cUnitStateAlive, 2, spawnLocationEast, true, 30) == false)
      aiEcho("Query failed");

	westFinalStartQuery = kbUnitQueryCreate("checkWestFinalStart");  // Look for CP units
   if ( configQuery(westFinalStartQuery, cUnitTypeMythUnit, -1, cUnitStateAlive, 2, spawnLocationWestFinal, true, 30) == false)
      aiEcho("Query failed");

	eastFinalStartQuery = kbUnitQueryCreate("checkEastFinalStart");  // Look for CP units
   if ( configQuery(eastFinalStartQuery, cUnitTypeMythUnit, -1, cUnitStateAlive, 2, spawnLocationEastFinal, true, 30) == false)
      aiEcho("Query failed");

	southFinalStartQuery = kbUnitQueryCreate("checkSouthFinalStart");  // Look for CP units
   if ( configQuery(southFinalStartQuery, cUnitTypeMythUnit, -1, cUnitStateAlive, 2, spawnLocationSouthFinal, true, 30) == false)
      aiEcho("Query failed");
}