//==============================================================================
// Scn25p2: AI Scenario Script for scenario 25 player 2
//==============================================================================
/*
   AI owner:  Dave Leary
   Scenario owner: Joe "the Golem" Gillum

	Overview: A semi-cheating AI for the "back field" main player in scenario
	25.  This guy does actually use villagers and such, but on higher levels and
	at particular points, he'll get extra resources to kick ass with.  Note that
	some difficulty-level adjustments for this scenario are made in the other AIs
	as well (for players 3 and 4).

  								*** DIFFICULTY LEVEL NOTES ***

   Easy level - Fewer researches.

   Moderate level - Base level.

   Difficult level - More ulfsarks and wolves. More resource cheating.

   Nightmare - More ulfsarks and wolves. More resource cheating.  Possible
	Fimbulwinter (ow).
*/
//==============================================================================
// Need scn lib for some stuff here.
include "scn lib.xs";

// Variable for main base.
int gMainBaseID=-1;


//==============================================================================
// Set Town Location
//==============================================================================
void setTownLocation(void)
{
   //Look for the "Town Location" marker.
   kbSetTownLocation(kbGetBlockPosition("8088"));
}

//==============================================================================
// miscStartup
//==============================================================================
void miscStartup(void)
{
	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

   //Startup message(s).
   aiEcho("");
   aiEcho("");
   aiEcho("Scn25P2 AI Start, filename='"+cFilename+"'.");
	aiEcho("Difficulty Level="+difflevel+".");
   //Spit out the map size.
   aiEcho("  Map size is ("+kbGetMapXSize()+", "+kbGetMapZSize()+").");
   //Cheat like a bastard.  Once only, though.
   kbLookAtAllUnitsOnMap();
   //Calculate some areas.
   kbAreaCalculate(1200.0);
   //Set our town location.
   setTownLocation();
	//Reset random seed
	aiRandSetSeed();

	//Set the base location.
	gMainBaseID=kbBaseGetMainID(cMyID);

	//Workarounds for crazy Ruediger bugs.
	kbTechTreeAddMinorGodPref( cTechAge3Njord );
	kbTechTreeAddMinorGodPref( cTechAge4Tyr );
}

//==============================================================================
//==============================================================================
// Attack stuff.
//==============================================================================
//==============================================================================
//Shared variables.
int numberAttacks=0;
int attackPlayerID=-1;
bool goingAge4=false;

//TODO: Decide how to rep attack group size.
//int attackMinimumGroupSize=3;
//int attackMaximumGroupSize=5;

//Attack 1 vars.
int attackPlan1ID=-1;

//Attack 2 vars.
int attackPlan2ID=-1;

// Route and path vars
int attackRoute1ID=-1;
int attackPath1ID=-1;
int attackRoute2ID=-1;
int attackPath2ID=-1;

// Saved plan IDs
int maintainPlan1ID=-1;
int maintainPlan2ID=-1;
int maintainPlan3ID=-1;
int maintainPlan4ID=-1;
int exploreID1=-1;

// Unit types
int attackerUnitTypeID1=cUnitTypeVillagerNorse;
int attackerUnitTypeID2=cUnitTypeUlfsark;
int attackerUnitTypeID3=cUnitTypeRaidingCavalry;
int attackerUnitTypeID4=cUnitTypeFenrisWolf;

// Initial gather percentages
float totalFoodGathererPercentage  = 0.6;
float totalWoodGathererPercentage  = 0.2;
float totalGoldGathererPercentage  = 0.2;
float totalFavorGathererPercentage = 0.0;


//==============================================================================
// initMainBase - Mike's spiffy function to relocate the main base.
//==============================================================================
void initMainBase()
{
	vector basePosition=kbGetBlockPosition("8153");

   // Nuke bases, add one base to rule them all
   kbBaseDestroyAll(cMyID);

   gMainBaseID = kbBaseCreate(cMyID, "Base "+kbBaseGetNextID(), basePosition, 50.0);
   
	if (gMainBaseID < 0)
      aiEcho("***** Main base creation failed. *****");

   vector baseFront=xsVectorNormalize(kbGetMapCenter()-basePosition);     // Set front
   kbBaseSetFrontVector(cMyID, gMainBaseID, baseFront);                 
   kbBaseSetMaximumResourceDistance(cMyID, gMainBaseID, 50.0);
   kbBaseSetMain(cMyID, gMainBaseID, true);     // Make this the main base

   // Add the buildings
   int buildingQuery = -1;
   int count = 0;
   buildingQuery = kbUnitQueryCreate("Building Query");     // All buildings in the base
   configQuery(buildingQuery, cUnitTypeBuilding, -1, cUnitStateAliveOrBuilding, cMyID, basePosition, false, 50.0);
   kbUnitQueryResetResults(buildingQuery);
   count = kbUnitQueryExecute(buildingQuery);

   int i = 0;
   int buildingID = -1;
	echoQuery(buildingID);
   for (i=0; < count)
   {
      buildingID = kbUnitQueryGetResult(buildingQuery, i);
      // Add it to the base
      kbBaseAddUnit( cMyID, gMainBaseID, buildingID );
   }
}

//==============================================================================
// initEcon
//
// Set Up the initial Econonomy.
//==============================================================================
void initEcon()
{
   aiEcho("Economy Init.");

	/* Don't need this for what we're doing here.
   // Set our update resource handler.
   aiSetUpdateResourceEventHandler("updateResourceHandler");
	*/

	// Set oxcarts as the trainable dropsite.
	aiSetTrainedDropsiteUnitTypeID(cUnitTypeOxCart);

   //-- Setup AI Cost weights.
   kbSetAICostWeight(cResourceFood, 1.5);
   kbSetAICostWeight(cResourceWood, 1.0);
   kbSetAICostWeight(cResourceGold, 1.5);
   kbSetAICostWeight(cResourceFavor, 10.0);

   //-- Dont auto gather favor
   //totalFavorGathererPercentage = 0;

   //-- Set initial gatherer percentages.
   aiSetResourceGathererPercentage(cResourceFood, totalFoodGathererPercentage, false, cRGPScript);
   aiSetResourceGathererPercentage(cResourceWood, totalWoodGathererPercentage, false, cRGPScript);
   aiSetResourceGathererPercentage(cResourceGold, totalGoldGathererPercentage, false, cRGPScript);
   aiSetResourceGathererPercentage(cResourceFavor, totalFavorGathererPercentage, false, cRGPScript);
   aiNormalizeResourceGathererPercentages(cRGPScript);

   //-- Set up the initial resource subtype break downs.
	aiSetResourceBreakdown(cResourceFood, cAIResourceSubTypeEasy, 1, 50, 0.4, gMainBaseID);
	aiSetResourceBreakdown(cResourceFood, cAIResourceSubTypeHunt, 1, 50, 0.1, gMainBaseID);
	aiSetResourceBreakdown(cResourceFood, cAIResourceSubTypeFarm, 1, 50, 0.5, gMainBaseID);
	aiSetResourceBreakdown(cResourceWood, cAIResourceSubTypeEasy, 1, 50, 1.0, gMainBaseID);
	aiSetResourceBreakdown(cResourceGold, cAIResourceSubTypeEasy, 1, 50, 1.0, gMainBaseID);
   aiSetResourceBreakdown(cResourceFavor, cAIResourceSubTypeEasy, 1, 50, 1.0, gMainBaseID);
	
   //-- Set up auto-gather escrows
   aiSetAutoGatherEscrowID(cRootEscrowID);
   aiSetAutoFarmEscrowID(cRootEscrowID);

	//Allocate all resources to the root escrow by setting percentage of military/economy to 0.
	kbEscrowSetPercentage( cEconomyEscrowID, cAllResources, 0.0 );
	kbEscrowSetPercentage( cMilitaryEscrowID, cAllResources, 0.0 );

	//-- create a herd plan to gather all herdables that we ecounter.
   int herdPlanID=aiPlanCreate("HerdTest", cPlanHerd);
   if (herdPlanID >= 0)
   {
      aiPlanAddUnitType(herdPlanID, cUnitTypeHerdable, 0, 100, 100);
      aiPlanSetVariableInt(herdPlanID, cHerdPlanBuildingTypeID, 0, cUnitTypeSettlementLevel1);
      aiPlanSetActive(herdPlanID);
   }

	//Allocate all resources
   kbEscrowAllocateCurrentResources();
}

//==============================================================================
// initAttack: Creates attack routes, etc.
//==============================================================================
void initAttack(int playerID=-1)
{
   //Destroy all previous attacks (if this isn't the player we're already attacking.
   if (playerID != attackPlayerID)
   {
      //Reset the attack player ID.
      attackPlayerID=-1;
      //Destroy any previous attack plan.
      aiPlanDestroy(attackPlan1ID);
      attackPlan1ID=-1;
      aiPlanDestroy(attackPlan2ID);
      attackPlan2ID=-1;
  
      //Destroy our previous attack paths.
      kbPathDestroy(attackPath1ID);
      attackPath1ID=-1;
      kbPathDestroy(attackPath2ID);
      attackPath2ID=-1;

      //Destroy our previous attack routes.
      attackRoute1ID=-1;
      attackRoute2ID=-1;

      //Reset the number of attacks.
      numberAttacks=0;
   }

   //Save the player to attack.
   attackPlayerID=playerID;
}

//==============================================================================
// setupAttack1 - Ulfsark Attack
//==============================================================================
bool setupAttack1(int playerID=-1)
{
	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

   //Info.
	aiEcho("Ulfsarks attacking Player "+playerID+".");

   //If the player to attack doesn't match, init the attack.
   if (attackPlayerID != playerID)
   {
      initAttack(playerID);
      if (attackPlayerID < 0)
         return(false);
   }

   //Create an attack plan.
   int newAttackPlanID=aiPlanCreate("Attack Player"+attackPlayerID+" Attempt"+numberAttacks, cPlanAttack);
   if (newAttackPlanID < 0)
      return(false);

   //Target player (required).  This must work.
   if (aiPlanSetVariableInt(newAttackPlanID, cAttackPlanPlayerID, 0, attackPlayerID) == false)
      return(false);

   //Gather point.
	vector gatherPoint=kbGetBlockPosition("8088");

	//Set the target type.  This must work.
   if (aiPlanSetNumberVariableValues(newAttackPlanID, cAttackPlanTargetTypeID, 2, true) == false)
      return(false);

   //Unit types to attack.
   aiPlanSetVariableInt(newAttackPlanID, cAttackPlanTargetTypeID, 0, cUnitTypeUnit);
	aiPlanSetVariableInt(newAttackPlanID, cAttackPlanTargetTypeID, 1, cUnitTypeBuilding);

   //Set the gather point and gather point distance.
   aiPlanSetVariableVector(newAttackPlanID, cAttackPlanGatherPoint, 0, gatherPoint);
   aiPlanSetVariableFloat(newAttackPlanID, cAttackPlanGatherDistance, 0, 40.0);

	//Add the unit types to the plan - ulfsarks, at least four (depending on age)
	if ( goingAge4 == true || difflevel > 1 )
	{
		aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID2, 8, 10, 16);
	}
	else
	{
		aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID2, 4, 4, 8);
	}
	
	//Set the initial position.
   aiPlanSetInitialPosition(newAttackPlanID, gatherPoint);
   //Plan requires all need units to work (can be false).
   aiPlanSetRequiresAllNeedUnits(newAttackPlanID, true);
   //Activate the plan.
   aiPlanSetActive(newAttackPlanID);

   //Now, save the attack plan ID appropriately.
   aiPlanSetOrphan(attackPlan1ID, true);
   attackPlan1ID=newAttackPlanID;

   //Increment our overall number of attacks.
   numberAttacks++;
}


//==============================================================================
// setupAttack2 - Wolf Attack
//==============================================================================
bool setupAttack2(int playerID=-1)
{
	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

   //Info.
	aiEcho("Wolves attacking Player "+playerID+".");

   //If the player to attack doesn't match, init the attack.
   if (attackPlayerID != playerID)
   {
      initAttack(playerID);
      if (attackPlayerID < 0)
         return(false);
   }

   //Create an attack plan.
   int newAttackPlanID=aiPlanCreate("Attack Player"+attackPlayerID+" Attempt"+numberAttacks, cPlanAttack);
   if (newAttackPlanID < 0)
      return(false);

   //Target player (required).  This must work.
   if (aiPlanSetVariableInt(newAttackPlanID, cAttackPlanPlayerID, 0, attackPlayerID) == false)
      return(false);

   //Gather point.
	vector gatherPoint=kbGetBlockPosition("8153");

	//Set the target type.  This must work.
   if (aiPlanSetNumberVariableValues(newAttackPlanID, cAttackPlanTargetTypeID, 2, true) == false)
      return(false);

   //Unit types to attack.
   aiPlanSetVariableInt(newAttackPlanID, cAttackPlanTargetTypeID, 0, cUnitTypeUnit);
	aiPlanSetVariableInt(newAttackPlanID, cAttackPlanTargetTypeID, 1, cUnitTypeBuilding);

   //Set the gather point and gather point distance.
   aiPlanSetVariableVector(newAttackPlanID, cAttackPlanGatherPoint, 0, gatherPoint);
   aiPlanSetVariableFloat(newAttackPlanID, cAttackPlanGatherDistance, 0, 40.0);

	//Add the unit types to the plan - wolves
	if ( difflevel < 2 )
	{
		aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID4, 4, 4, 4);
	}
	else
	{
		aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID4, 4, 8, 8);
	}

   //Set the initial position.
   aiPlanSetInitialPosition(newAttackPlanID, gatherPoint);
   //Plan requires all need units to work (can be false).
   aiPlanSetRequiresAllNeedUnits(newAttackPlanID, true);
   //Activate the plan.
   aiPlanSetActive(newAttackPlanID);

   //Now, save the attack plan ID appropriately.
   aiPlanSetOrphan(attackPlan2ID, true);
   attackPlan2ID=newAttackPlanID;

   //Increment our overall number of attacks.
   numberAttacks++;
}

//==============================================================================
// createUnitProgression
//==============================================================================
int createUnitProgression(int unitTypeID=-1, string name="BUG")
{
   int pID=aiPlanCreate(name, cPlanProgression);
   
	if (pID < 0)
      return(-1);

   //This is a military plan.
   //aiPlanSetMilitary(pID, true);
   //Set it for the building that we get our unit from.
   aiPlanSetVariableInt(pID, cProgressionPlanGoalUnitID, 0, kbTechTreeGetUnitIDByTrain(unitTypeID, cMyCiv));
   
	//Build it in our main base using the root escrow.
	aiPlanSetBaseID(pID, gMainBaseID);
	aiPlanSetEscrowID(pID, cRootEscrowID);
   
	//Go.
   aiPlanSetActive(pID);
   return(pID);
}

//==============================================================================
// createTechProgression
//==============================================================================
int createTechProgression(int techID=-1, string name="BUG", int researchFromProto=-1)
{
   //Check for old plan.
	int oldPlanID=aiPlanGetIDByTypeAndVariableType(cPlanProgression, cProgressionPlanGoalTechID, techID);
   if(oldPlanID != -1)
   {
      aiEcho("createTechProgression: already have a plan("+oldPlanID+") for this Tech("+techID+").");
      return(oldPlanID);
   }
   
	//Create a new one.
   int pID=aiPlanCreate(name, cPlanProgression);
   if (pID < 0)
   {
      aiEcho("createTechProgression: couldn't create Progression.");
      return(-1);
   }
   //This is a military plan.
   //aiPlanSetMilitary(pID, true);
   aiPlanSetVariableInt(pID, cProgressionPlanGoalTechID, 0, techID);
   aiPlanSetVariableInt(pID, cProgressionPlanBuildingPref, 0, researchFromProto);
   
	//Build it in our main base using the root escrow.
   aiPlanSetBaseID(pID, gMainBaseID);
	aiPlanSetEscrowID(pID, cRootEscrowID);

   //Go.
   aiPlanSetActive(pID);
   aiEcho("createTechProgression: creating Tech Progression("+name+") to TechID("+techID+").");
   return(pID);
}

//==============================================================================
// Attack Generator 1 - Send dudes now!  Or, well, soon.
//==============================================================================
rule attackGenerator1
   minInterval 90
   inactive
   group AttackRules
{
	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

   //See how many "idle" attack plans we have.  Don't create any more if we have
   //idle plans.
   int numberIdleAttackPlans=aiGetNumberIdlePlans(cPlanAttack);

   if (numberIdleAttackPlans > 0)
      return;

   //If we have enough unassigned military units, create a new attack plan.
   int numberAvailableUnits=aiNumberUnassignedUnits(attackerUnitTypeID2);
   aiEcho("There are "+numberAvailableUnits+" ulfsarks available for a new attack.");
   
	if ( goingAge4 == true || difflevel > 1 )
	{
		if (numberAvailableUnits >= 8 )
			setupAttack1(1);
	}
	else 
	{
		if (numberAvailableUnits >= 4 )
			setupAttack1(1);
	}
}

//==============================================================================
// Attack Generator 2 - Send wolves
//==============================================================================
rule attackGenerator2
   minInterval 120
   inactive
   group AttackRules
{
   //See how many "idle" attack plans we have.  Don't create any more if we have
   //idle plans.
   int numberIdleAttackPlans=aiGetNumberIdlePlans(cPlanAttack);

   if (numberIdleAttackPlans > 0)
      return;

   //If we have enough unassigned military units, create a new attack plan.
   int numberAvailableUnits=aiNumberUnassignedUnits(attackerUnitTypeID4);
   aiEcho("There are "+numberAvailableUnits+" wolves available for a new attack.");
   
	if (numberAvailableUnits >= 4)
		setupAttack2(1);
}

//==============================================================================
// Fimbulwinter Fun
//==============================================================================
rule fimbulwinterFun
	minInterval 240
	inactive
	group GodPowers
{
	vector fimbulPoint=kbGetBlockPosition("8088");
	aiEcho("*** TIME FOR FIMBULWINTER - EAT IT!!! ***");
	if ( aiCastGodPowerAtPosition(cTechSnowStorm, fimbulPoint) == true )
		xsDisableSelf();
	else
		aiEcho("Fimbulwinter failed - try again later.");
}

//==============================================================================
// Favor cheat
//==============================================================================
rule favorCheat
   minInterval 120
   inactive
   group AttackRules
{
	// Cheat for favor.  It's tough to be Norse.
	aiResourceCheat( 2, cResourceFavor, 25.0 );
}

//==============================================================================
// Resource Cheat: periodic boosts at higher levels.
//==============================================================================
rule diffResourceCheat
   minInterval 90
   active
   group DifficultyStuff
{
	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

	if ( difflevel == 2 )
	{
		aiResourceCheat( 2, cResourceFood, 100.0 );
		aiResourceCheat( 2, cResourceWood, 100.0 );
		aiResourceCheat( 2, cResourceGold, 100.0 );
	}
	else if ( difflevel == 3 )
	{
		aiResourceCheat( 2, cResourceFood, 150.0 );
		aiResourceCheat( 2, cResourceWood, 150.0 );
		aiResourceCheat( 2, cResourceGold, 150.0 );
	}
	else
	{
		xsDisableSelf();
	}
}

//==============================================================================
// mapCheat; look at the map at the five-minute mark (once).
//==============================================================================
rule mapCheat
	minInterval 300
	active
{
   kbLookAtAllUnitsOnMap();	
	xsDisableSelf();
}

//==============================================================================
// hillFortBuilt - called with an AI FUNC when he has one hill fort.
// This fires off the next progression, and starts some basic attacks up.
//==============================================================================
void hillFortBuilt( int parameter=-1 )
{
	// Slightly more villagers.
	aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanNumberToMaintain, 0, 20);
	
	// More ulfsarks maintained.  We're going to start raiding the player with
	// groups of 6-8.  We'll maintain 10 to provide for the scout plan and
	// a little town defense.
	aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanNumberToMaintain, 0, 10);

   //-- Mostly farms now that we've got the thing built
	aiSetResourceBreakdown(cResourceFood, cAIResourceSubTypeEasy, 1, 50, 0.1, gMainBaseID);
	aiSetResourceBreakdown(cResourceFood, cAIResourceSubTypeHunt, 1, 50, 0.1, gMainBaseID);
	aiSetResourceBreakdown(cResourceFood, cAIResourceSubTypeFarm, 1, 50, 0.8, gMainBaseID);

	// Change percentage of who's on what.
   aiSetResourceGathererPercentage(cResourceFood, 0.5, false, cRGPScript);
   aiSetResourceGathererPercentage(cResourceWood, 0.2, false, cRGPScript);
   aiSetResourceGathererPercentage(cResourceGold, 0.3, false, cRGPScript);
	
	// Enable basic attacks
	xsEnableRule("attackGenerator1");

	// Cheat!!
	aiResourceCheat( 2, cResourceFood, 750.0 );
	aiResourceCheat( 2, cResourceGold, 750.0 );

	// Get some stone wall action going on
	createTechProgression(cTechStoneWall, "Research Stone Walls", cUnitTypeWallLong);

	// Get better weapons
	createTechProgression(cTechBronzeWeapons, "Progress to Bronze Weapons", cUnitTypeArmory);

	// Progression to Omniscience.  Should get us to Age 4, yes?
	createTechProgression(cTechOmniscience, "Progress Age 4 (Omniscience)", cUnitTypeTemple);

	// Go to heavy infantry
	createTechProgression(cTechHeavyInfantry, "Progress to Heavy Infantry", cUnitTypeLonghouse);
}

//==============================================================================
// researchingFourthAge - called with an AI FUNC when the player starts
// researching fourth age (duh).  Changes up some attacks and starts maintaining
// Fenris Wolves.  Also sets things up for the player to launch Fimbulwinter
// four minutes from now, and shifts more wood resource gatherers to gold.
//==============================================================================
void researchingFourthAge( int parameter=-1 )
{
	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

	vector gatherPointMilitary=kbGetBlockPosition("8153");

   //Maintain Fenris Wolves.
   maintainPlan4ID=aiPlanCreate("Maintain 4 "+kbGetProtoUnitName(attackerUnitTypeID1), cPlanTrain);
   if (maintainPlan4ID >= 0)
   {
		//Must set the type of unit to train.
      aiPlanSetVariableInt(maintainPlan4ID, cTrainPlanUnitType, 0, attackerUnitTypeID4);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
		if ( difflevel < 2 )
		{
			aiPlanSetVariableInt(maintainPlan4ID, cTrainPlanNumberToMaintain, 0, 4);
		}
		else
		{
			aiPlanSetVariableInt(maintainPlan4ID, cTrainPlanNumberToMaintain, 0, 8);
		}
      //Don't train units too quickly.
		if ( difflevel < 2 )
		{
			aiPlanSetVariableInt(maintainPlan4ID, cTrainPlanFrequency, 0, 30);
		}
		else if ( difflevel == 2 )
		{
			aiPlanSetVariableInt(maintainPlan4ID, cTrainPlanFrequency, 0, 20);
		}
		else if ( difflevel == 3 )
		{
			aiPlanSetVariableInt(maintainPlan4ID, cTrainPlanFrequency, 0, 10);
		}
      //Set a gather point.
      aiPlanSetVariableVector(maintainPlan4ID, cTrainPlanGatherPoint, 0, gatherPointMilitary);
      //Activate the plan.
      aiPlanSetActive(maintainPlan4ID);
   }

	// Change percentage of who's on what.
   aiSetResourceGathererPercentage(cResourceFood, 0.5, false, cRGPScript);
   aiSetResourceGathererPercentage(cResourceWood, 0.1, false, cRGPScript);
   aiSetResourceGathererPercentage(cResourceGold, 0.4, false, cRGPScript);

	// Cheats!!
	aiResourceCheat( 2, cResourceFood, 750.0 );
	aiResourceCheat( 2, cResourceWood, 750.0 );
	aiResourceCheat( 2, cResourceGold, 750.0 );

	// Upgrade like mad.  Except on easy.
	if ( difflevel > 0 )
	{
		createTechProgression(cTechIronWeapons, "Progress to Iron Weapons", cUnitTypeArmory);
		createTechProgression(cTechIronMail, "Progress to Iron Mail", cUnitTypeArmory);
		createTechProgression(cTechIronShields, "Progress to Iron Shields", cUnitTypeArmory);
		createTechProgression(cTechChampionInfantry, "Progress to Champion Infantry", cUnitTypeLonghouse);
	}

	// More ulfsarks maintained, and fewer villagers...we've already done this on higher levels.
	if ( difflevel < 2 )
	{
		aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanNumberToMaintain, 0, 10);
	}
	aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanNumberToMaintain, 0, 20);

	// Start cheating for favor.
	xsEnableRule("favorCheat");

	// Enable Fimbulwinter...  Nightmare only, now.
	if ( difflevel == 3 )
	{
		xsEnableRule("fimbulwinterFun");
	}

	// Enable attacks by the scary wolf things
	xsEnableRule("attackGenerator2");

	// Set a saved boolean so we know what's up.
	goingAge4 = true;
}


//==============================================================================
// MAIN.
//==============================================================================
void main(void)
{
	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

   //Startup.
   miscStartup();
	initMainBase();
	initEcon();

   //A couple o' gather points.
   vector gatherPointVillager=kbGetBlockPosition("8153");
	vector gatherPointMilitary=kbGetBlockPosition("8088");

	// Cheat up some favor.  It's tough to be Norse.
	aiResourceCheat( 2, cResourceFavor, 45.0 );
	
   //Maintain villagers.  Fifteen should be plenty.
   maintainPlan1ID=aiPlanCreate("Maintain 15 "+kbGetProtoUnitName(attackerUnitTypeID1), cPlanTrain);
   if (maintainPlan1ID >= 0)
   {
		// Up the desired priority of this plan a litte.
		aiPlanSetDesiredPriority(maintainPlan1ID, 60);
		//Must set the type of unit to train.
      aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanUnitType, 0, attackerUnitTypeID1);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
      aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanNumberToMaintain, 0, 15);
      //Don't train units faster than every 15 seconds
      aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanFrequency, 0, 15);
      //Set a gather point.
      aiPlanSetVariableVector(maintainPlan1ID, cTrainPlanGatherPoint, 0, gatherPointVillager);
      //Activate the plan.
      aiPlanSetActive(maintainPlan1ID);
   }

	//Maintain ulfsarks!  Five for now, except on higher diff levels.
   maintainPlan2ID=aiPlanCreate("Maintain 5 "+kbGetProtoUnitName(attackerUnitTypeID2), cPlanTrain);
   if (maintainPlan2ID >= 0)
   {
		//Must set the type of unit to train.
      aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanUnitType, 0, attackerUnitTypeID2);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
		if ( difflevel < 2 )
		{
			aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanNumberToMaintain, 0, 5);
		}
		else
		{
			aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanNumberToMaintain, 0, 12);
		}
      //Don't train units faster than every 20 seconds
      aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanFrequency, 0, 20);
      //Set a gather point.
      aiPlanSetVariableVector(maintainPlan2ID, cTrainPlanGatherPoint, 0, gatherPointMilitary);
      //Activate the plan.
      aiPlanSetActive(maintainPlan2ID);
   }

	// Explore plan 1
   exploreID1 = aiPlanCreate("Explore 1", cPlanExplore);
   if(exploreID1 >= 0)
   {
      aiPlanAddUnitType(exploreID1, cUnitTypeUlfsark, 1, 1);
      aiPlanSetActive(exploreID1);
   }

	// Progress to Huskarls - kind of a hack, used to get him to build a hill fort and advance to Age 3.
	createUnitProgression(cUnitTypeHuskarl, "Progression to Huskarls");
}
