//==============================================================================
// Scn15p2: AI Scenario Script for scenario 15 player 2
//==============================================================================
/*
   AI owner:  Mike Kidd
   Scenario owner: Jeff Brown

   Overview:
   This player controls "Kemset's Army", which is the ominous, unstoppable force
   that embodies the time limit for the human player.  (The HP must accomplish
   his/her objective before Kemset's army returns.)

   Units are spawned into the defend plan (via trigger) early in the scenario, and
   the HP can see them destroying the first of three towns on the perimeter of the
   map.  Over time, the army moves on, under the control of the move() AIFunc.  

   Finally, Kemset's army reaches the fortress.   A trigger teleports some specific 
   units into Kemset's army just before this, and if those units reach the fortress,
   the loss condition is triggered.
*/

include "scn lib.xs";



// Cinematic blocks
const string cbTown1 = "3260";
const string cbTown12 = "3266";
const string cbTown2 = "3261";
const string cbTown23 = "3267";
const string cbTown3 = "3262";
const string cbCourtyard = "3263";     // Inside player 3's town
int defendPlan = -1;


void wakeup(int ignore = 1)
{
   aiEcho("Wakeup running at "+timeString());
   defendPlan =aiPlanCreate("Defend Plan", cPlanDefend);
   if (defendPlan >= 0)
   {
      aiPlanAddUnitType(defendPlan, cUnitTypeMilitary, 0, 200, 200);    // All unassigned mil units
      aiPlanSetDesiredPriority(defendPlan, 10);                       // Way low, below scouting and attack
      aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbTown1));
      aiPlanSetVariableFloat(defendPlan, cDefendPlanEngageRange, 0, 20.0);
      aiPlanSetVariableBool(defendPlan, cDefendPlanPatrol, 0, false);
      aiPlanSetVariableFloat(defendPlan, cDefendPlanGatherDistance, 0, 20.0);
      aiPlanSetInitialPosition(defendPlan, kbGetBlockPosition(cbTown1));
      aiPlanSetUnitStance(defendPlan, cUnitStanceDefensive);

      aiPlanSetVariableInt(defendPlan, cDefendPlanRefreshFrequency, 0, 5);
      aiPlanSetNumberVariableValues(defendPlan, cDefendPlanAttackTypeID, 2, true);
      aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
      aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);

      aiPlanSetActive(defendPlan); 
      aiEcho("Creating defend plan");
   }
}

void move(int ingore=-1)
{
   static int town=1;

   switch(town)
   {
   case 1:
      {  // Move between towns 1 and 2
         aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbTown12));
         town = town+1;
         aiEcho("Moving between towns 1 and 2.");
         break;
      }
   case 2:
      {  // Move to town 2
         aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbTown2));
         town = town+1;
         aiEcho("Moving to city 2.");
         break;
      }
   case 3:
      {  // Move between towns 2 and 3
         aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbTown23));
         town = town+1;
         aiEcho("Moving between towns 2 and 3.");
         break;
      }
   case 4:
      {  // Move to town 3
         aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbTown3));
         town = town+1;
         aiEcho("Moving to city 3.");
         break;
      }
   case 5:
      {  // Move to player 2's town, attack anything
         aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbCourtyard));
         aiSetAttackResponseDistance(5.0);
         aiPlanSetVariableFloat(defendPlan, cDefendPlanEngageRange, 0, 15.0);
         aiPlanSetUnitStance(defendPlan, cUnitStanceDefensive);
         aiEcho("Moving to main fortress.");
         town = town+1;
         break;
      }
   }
}



void main()
{
   aiEcho("Starting Scn15p2.xs");
   aiRandSetSeed();
   kbSetTownLocation(kbGetBlockPosition(cbTown1));
   //Calculate some areas.
   kbAreaCalculate(1200.0);

   aiSetAttackResponseDistance(10.0);



}







