//==============================================================================
// AOMDefaultAIMilitary.xs
//==============================================================================

//==============================================================================
// createSimpleAttackGoal
//==============================================================================
int createSimpleAttackGoal(string name="BUG", int attackPlayerID=-1,
   int unitPickerID=-1, int repeat=-1, int minAge=-1, int maxAge=-1,
   int baseID=-1, bool allowRetreat=false)
{
   aiEcho("CreateSimpleAttackGoal:  Name="+name+", AttackPlayerID="+attackPlayerID+".");
   aiEcho("  UnitPickerID="+unitPickerID+", Repeat="+repeat+", baseID="+baseID+".");
   aiEcho("  MinAge="+minAge+", maxAge="+maxAge+", allowRetreat="+allowRetreat+".");

   //Create the goal.
   int goalID=aiPlanCreate(name, cPlanGoal);
   if (goalID < 0)
      return(-1);

   //Priority.
   aiPlanSetDesiredPriority(goalID, 90);
   //Attack player ID.
   if (attackPlayerID >= 0)
      aiPlanSetVariableInt(goalID, cGoalPlanAttackPlayerID, 0, attackPlayerID);
   else
      aiPlanSetVariableBool(goalID, cGoalPlanAutoUpdateAttackPlayerID, 0, true);
   //Base.
   if (baseID >= 0)
      aiPlanSetBaseID(goalID, baseID);
   else
      aiPlanSetVariableBool(goalID, cGoalPlanAutoUpdateBase, 0, true);
   //Attack.
   aiPlanSetAttack(goalID, true);
   aiPlanSetVariableInt(goalID, cGoalPlanGoalType, 0, cGoalPlanGoalTypeAttack);
   //Military.
   aiPlanSetMilitary(goalID, true);
   aiPlanSetEscrowID(goalID, cMilitaryEscrowID);
   //Ages.
   aiPlanSetVariableInt(goalID, cGoalPlanMinAge, 0, minAge);
   aiPlanSetVariableInt(goalID, cGoalPlanMaxAge, 0, maxAge);
   //Repeat.
   aiPlanSetVariableInt(goalID, cGoalPlanRepeat, 0, repeat);
   //Unit Picker.
   aiPlanSetVariableInt(goalID, cGoalPlanUnitPickerID, 0, unitPickerID);
   //Retreat.
   aiPlanSetVariableBool(goalID, cGoalPlanAllowRetreat, 0, allowRetreat);
   // Upgrade Building prefs.
   aiPlanSetNumberVariableValues(goalID, cGoalPlanUpgradeBuilding, 3, true);
   aiPlanSetVariableInt(goalID, cGoalPlanUpgradeBuilding, 0, cUnitTypeTemple);
   aiPlanSetVariableInt(goalID, cGoalPlanUpgradeBuilding, 1, cUnitTypeSettlementLevel1);
   if(cMyCiv == cCivThor)
      aiPlanSetVariableInt(goalID, cGoalPlanUpgradeBuilding, 2, cUnitTypeDwarfFoundry);
   else
      aiPlanSetVariableInt(goalID, cGoalPlanUpgradeBuilding, 2, cUnitTypeArmory);
   //Handle maps where the enemy player is usually on a diff island.
   if ((cRandomMapName == "archipelago") ||
      (cRandomMapName == "river nile") ||
      (cRandomMapName == "vinlandsaga") ||
      (cRandomMapName == "team migration") ||
      (cRandomMapName == "river styx") ||
      (cRandomMapName == "black sea"))
   {
      aiPlanSetVariableBool(goalID, cGoalPlanSetAreaGroups, 0, true);
      aiPlanSetVariableInt(goalID, cGoalPlanAttackRoutePatternType, 0, cAttackPlanAttackRoutePatternRandom);
   }

   //Done.
   return(goalID);
}

//==============================================================================
// createBaseGoal
//==============================================================================
int createBaseGoal(string name="BUG", int goalType=-1, int attackPlayerID=-1,
   int repeat=-1, int minAge=-1, int maxAge=-1, int parentBaseID=-1)
{
   aiEcho("CreateBaseGoal:  Name="+name+", AttackPlayerID="+attackPlayerID+".");
   aiEcho("  GoalType="+goalType+", Repeat="+repeat+", parentBaseID="+parentBaseID+".");
   aiEcho("  MinAge="+minAge+", maxAge="+maxAge+".");

   //Create the goal.
   int goalID=aiPlanCreate(name, cPlanGoal);
   if (goalID < 0)
      return(-1);

   //Priority.
   aiPlanSetDesiredPriority(goalID, 90);
   //"Parent" Base.
   aiPlanSetBaseID(goalID, parentBaseID);
   //Base Type.
   aiPlanSetVariableInt(goalID, cGoalPlanGoalType, 0, goalType);
   if (goalType == cGoalPlanGoalTypeForwardBase)
   {
      //Attack player ID.
      if (attackPlayerID >= 0)
         aiPlanSetVariableInt(goalID, cGoalPlanAttackPlayerID, 0, attackPlayerID);
      else
         aiPlanSetVariableBool(goalID, cGoalPlanAutoUpdateAttackPlayerID, 0, true);
      //Military.
      aiPlanSetMilitary(goalID, true);
      aiPlanSetEscrowID(goalID, cMilitaryEscrowID);
      //Active health.
      aiPlanSetVariableInt(goalID, cGoalPlanActiveHealthTypeID, 0, cUnitTypeBuilding);
      aiPlanSetVariableFloat(goalID, cGoalPlanActiveHealth, 0, 0.25);
   }
   //Ages.
   aiPlanSetVariableInt(goalID, cGoalPlanMinAge, 0, minAge);
   aiPlanSetVariableInt(goalID, cGoalPlanMaxAge, 0, maxAge);
   //Repeat.
   aiPlanSetVariableInt(goalID, cGoalPlanRepeat, 0, repeat);

   //Done.
   return(goalID);
}

//==============================================================================
// createCallbackGoal
//==============================================================================
int createCallbackGoal(string name="BUG", string callbackName="BUG", int repeat=-1,
   int minAge=-1, int maxAge=-1, bool autoUpdate=false)
{
   aiEcho("CreateCallbackGoal:  Name="+name+", CallbackName="+callbackName+".");
   aiEcho("  Repeat="+repeat+", MinAge="+minAge+", maxAge="+maxAge+".");

   //Get the callbackFID.
   int callbackFID=xsGetFunctionID(callbackName);
   if (callbackFID < 0)
      return(-1);

   //Create the goal.
   int goalID=aiPlanCreate(name, cPlanGoal);
   if (goalID < 0)
      return(-1);

   //Goal Type.
   aiPlanSetVariableInt(goalID, cGoalPlanGoalType, 0, cGoalPlanGoalTypeCallback);
   //Auto update.
   aiPlanSetVariableBool(goalID, cGoalPlanAutoUpdateState, 0, autoUpdate);
   //Callback FID.
   aiPlanSetVariableInt(goalID, cGoalPlanFunctionID, 0, callbackFID);
   //Priority.
   aiPlanSetDesiredPriority(goalID, 90);
   //Ages.
   aiPlanSetVariableInt(goalID, cGoalPlanMinAge, 0, minAge);
   aiPlanSetVariableInt(goalID, cGoalPlanMaxAge, 0, maxAge);
   //Repeat.
   aiPlanSetVariableInt(goalID, cGoalPlanRepeat, 0, repeat);

   //Done.
   return(goalID);
}

//==============================================================================
// createBuildBuildingGoal
//==============================================================================
int createBuildBuildingGoal(string name="BUG", int buildingTypeID=-1, int repeat=-1,
   int minAge=-1, int maxAge=-1, int baseID=-1, int numberUnits=1, int builderUnitTypeID=-1,
   bool autoUpdate=true, int pri=90, int buildingPlacementID = -1)
{
   aiEcho("CreateBuildBuildingGoal:  Name="+name+", BuildingType="+kbGetUnitTypeName(buildingTypeID)+".");
   aiEcho("  Repeat="+repeat+", MinAge="+minAge+", maxAge="+maxAge+".");

   //Create the goal.
   int goalID=aiPlanCreate(name, cPlanGoal);
   if (goalID < 0)
      return(-1);

   //Goal Type.
   aiPlanSetVariableInt(goalID, cGoalPlanGoalType, 0, cGoalPlanGoalTypeBuilding);
   //Base ID.
   aiPlanSetBaseID(goalID, baseID);
   //Auto update.
   aiPlanSetVariableBool(goalID, cGoalPlanAutoUpdateState, 0, autoUpdate);
   //Building Type ID.
   aiPlanSetVariableInt(goalID, cGoalPlanBuildingTypeID, 0, buildingTypeID);
   //Building Placement ID.
   aiPlanSetVariableInt(goalID, cGoalPlanBuildingPlacementID, 0, buildingPlacementID);
   //Set the builder parms.
   aiPlanSetVariableInt(goalID, cGoalPlanMinUnitNumber, 0, 1);
   aiPlanSetVariableInt(goalID, cGoalPlanMaxUnitNumber, 0, numberUnits);
   aiPlanSetVariableInt(goalID, cGoalPlanUnitTypeID, 0, builderUnitTypeID);
   
   //Priority.
   aiPlanSetDesiredPriority(goalID, pri);
   //Ages.
   aiPlanSetVariableInt(goalID, cGoalPlanMinAge, 0, minAge);
   aiPlanSetVariableInt(goalID, cGoalPlanMaxAge, 0, maxAge);
   //Repeat.
   aiPlanSetVariableInt(goalID, cGoalPlanRepeat, 0, repeat);

   //Done.
   return(goalID);
}

//==============================================================================
// createBuildSettlementGoal
//==============================================================================
int createBuildSettlementGoal(string name="BUG", int minAge=-1, int maxAge=-1, int baseID=-1, int numberUnits=1, int builderUnitTypeID=-1,
   bool autoUpdate=true, int pri=90)
{
   int buildingTypeID = cUnitTypeSettlementLevel1;

   aiEcho("CreateBuildSettlementGoal:  Name="+name+", BuildingType="+kbGetUnitTypeName(buildingTypeID)+".");
   aiEcho("  MinAge="+minAge+", maxAge="+maxAge+".");

   //Create the goal.
   int goalID=aiPlanCreate(name, cPlanGoal);
   if (goalID < 0)
      return(-1);

   //Goal Type.
   aiPlanSetVariableInt(goalID, cGoalPlanGoalType, 0, cGoalPlanGoalTypeBuildSettlement);
   //Base ID.
   aiPlanSetBaseID(goalID, baseID);
   //Auto update.
   aiPlanSetVariableBool(goalID, cGoalPlanAutoUpdateState, 0, autoUpdate);
   //Building Type ID.
   aiPlanSetVariableInt(goalID, cGoalPlanBuildingTypeID, 0, buildingTypeID);
   //Building Search ID.
   aiPlanSetVariableInt(goalID, cGoalPlanBuildingSearchID, 0, cUnitTypeSettlement);
   //Set the builder parms.
   aiPlanSetVariableInt(goalID, cGoalPlanMinUnitNumber, 0, 1);
   aiPlanSetVariableInt(goalID, cGoalPlanMaxUnitNumber, 0, numberUnits);
   aiPlanSetVariableInt(goalID, cGoalPlanUnitTypeID, 0, builderUnitTypeID);
   
   //Priority.
   aiPlanSetDesiredPriority(goalID, pri);
   //Ages.
   aiPlanSetVariableInt(goalID, cGoalPlanMinAge, 0, minAge);
   aiPlanSetVariableInt(goalID, cGoalPlanMaxAge, 0, maxAge);
   //Repeat.
   aiPlanSetVariableInt(goalID, cGoalPlanRepeat, 0, 1);

   //Done.
   return(goalID);
}

//==============================================================================
// createTransportPlan
//==============================================================================
int createTransportPlan(string name="BUG", int startAreaID=-1, int goalAreaID=-1,
   bool persistent=false, int transportPUID=-1, int pri=-1, int baseID=-1)
{
   aiEcho("CreateTransportPlan:  Name="+name+", Priority="+pri+".");
   aiEcho("  StartAreaID="+startAreaID+", GoalAreaID="+goalAreaID+", Persistent="+persistent+".");
   aiEcho("  TransportType="+kbGetUnitTypeName(transportPUID)+", BaseID="+baseID+".");

   //Create the plan.
   int planID=aiPlanCreate(name, cPlanTransport);
   if (planID < 0)
      return(-1);

   //Priority.
   aiPlanSetDesiredPriority(planID, pri);
   //Base.
   aiPlanSetBaseID(planID, baseID);
   //Set the areas.
   aiPlanSetVariableInt(planID, cTransportPlanPathType, 0, 1);
   aiPlanSetVariableInt(planID, cTransportPlanGatherArea, 0, startAreaID);
   aiPlanSetVariableInt(planID, cTransportPlanTargetArea, 0, goalAreaID);
   //Default the initial position to the start area's location.
   aiPlanSetInitialPosition(planID, kbAreaGetCenter(startAreaID));
   //Transport type.
   aiPlanSetVariableInt(planID, cTransportPlanTransportTypeID, 0, transportPUID);
   //Persistent.
   aiPlanSetVariableBool(planID, cTransportPlanPersistent, 0, persistent);
   //Always add the transport unit type.
   aiPlanAddUnitType(planID, transportPUID, 1, 1, 1);
   //Activate.
   aiPlanSetActive(planID);

   //Done.
   return(planID);
}
