if (not skipIncludes) then
	dofile("script/rooms/room5.lua")
end

levelDesc.productSettings =
{
	["#lattemacchiato"]						= {consumeAnimation="drink",	chance=75,	big=25, 	elderly=200,	kid=0,	 veg=true,	hard=true,						},
	["#greentea"]							= {consumeAnimation="drink",	chance=100,	big=25,		elderly=200,	kid=50,	 veg=true,									},
	["#bagel"]								= {								chance=100,	big=175,	elderly=100,	kid=200, veg=true,			   	dessert=true,		},
	["#applepie"]							= {								chance=100,	big=175,	elderly=100,	kid=150, veg=true,			   	dessert=true,		},
	["#egg#cup"]							= {								chance=100,	big=50,		elderly=200,	kid=100, veg=true,			 						},
	["#clubsandwich_third"]					= {								chance=100,	big=0,		elderly=150,	kid=150, veg=true,			 	cheeseProduct=true,	},
	["#clubsandwich_twothird"]				= {								chance=100,	big=100,	elderly=75,		kid=75,	 veg=true,			 	cheeseProduct=true,	},
	["#clubsandwich_whole"]					= {								chance=100,	big=150,	elderly=50,		kid=0,	 veg=true,			 	cheeseProduct=true,	},

	["#basket#banana#apple#pear"]			= {								chance=100,	big=0,		elderly=200,	kid=50,	 veg=true, 	hard=true,	edible=false		},
	["#basket#banana#banana#banana"]		= {								chance=100,	big=0,		elderly=200,	kid=50,	 veg=true, 	hard=true,	edible=false		},
	["#basket#apple#apple#apple"]			= {								chance=100,	big=0,		elderly=200,	kid=50,	 veg=true, 	hard=true,	edible=false		},
	["#basket#pear#pear#pear"]				= {								chance=100,	big=0,		elderly=200,	kid=50,	 veg=true, 	hard=true,	edible=false		},

	["#pancake#cherry"]						= {								chance=100,	big=100,	elderly=100,	kid=200, veg=true,			 	dessert=true,		},
	["#pancake#chocolate"]					= {								chance=100,	big=200,	elderly=100,	kid=200, veg=true,				dessert=true,		},

	["#lasagna#red#lasagna#topping.ready"]					= {				chance=75,	big=75, 	elderly=150,	kid=0,	 veg=false,	hard=true, },
	["#lasagna#green#lasagna#topping.ready"]				= {				chance=75,	big=75, 	elderly=150,	kid=0,	 veg=false,	hard=true, 						},
	["#lasagna#red#lasagna#red#lasagna#topping.ready"]		= {				chance=75,	big=200, 	elderly=100,	kid=0,	 veg=false,	hard=true, },
	["#lasagna#green#lasagna#green#lasagna#topping.ready"]	= {				chance=75,	big=200, 	elderly=100,	kid=0,	 veg=false,	hard=true, 						},
	["#lasagna#red#lasagna#green#lasagna#topping.ready"]	= {				chance=75,	big=200, 	elderly=100,	kid=0,	 veg=false,	hard=true, 						},
}	

function levelDesc:getExitPositionForCharacter(character, hasWon)
	if (character.name == "emily") then
		return {x=884, y=107}
	end
	if (character.name == "puppy") then
		return {x=884, y=107}
	end
	return nil
end

function levelDesc:defaultOnInitialized()
	self.old_elapsedTime = -2000
end

function levelDesc:handleTrigger(trigger, data)
	if (trigger == "door_onLeave") then		
		if (self.elapsedTime - levelDesc.old_elapsedTime > 2000) then
			if (data and data.triggerObject) then
				data.triggerObject:playSample("customer_enters:sound")
			end
			levelDesc.old_elapsedTime = self.elapsedTime
		end
	end	
	return self.class.handleTrigger(self, trigger, data)
end
