if (not skipIncludes) then
	dofile("script/rooms/room4.lua")
end

levelDesc.productSettings =
{
	["#cremebrulee"]				= { 						 chance=100,	big=75,   elderyly=200,	kid=100,	veg=true,				dessert=true,		},
	["#fruitcake"]					= { 						 chance=100,	big=150,  elderyly=200,	kid=150,	veg=true,				dessert=true,		},
	["#chocolatecake"]				= { 						 chance=100,	big=250,  elderyly=100,	kid=100,	veg=true,				dessert=true,		},
	["#oyster"]						= { 						 chance=75,		big=100,  elderyly=150,	kid=0,		veg=false,									},
	["#caviar"]						= { 						 chance=100,	big=100,  elderyly=200,	kid=0,		veg=false,									},
	["#lemonwater"]					= {consumeAnimation="drink", chance=150,	big=100,  elderyly=100,	kid=75,		veg=true,									},
	["#lobster.ready"]				= { 						 chance=75,		big=150,  elderyly=100,	kid=0,		veg=false,	hard=true,						},
	["#crab.ready"]					= { 						 chance=75,		big=150,  elderyly=100,	kid=0,		veg=false,	hard=true,						},
	["#soup#parsley"]				= { 						 chance=100,	big=50,   elderyly=200,	kid=0,		veg=true,	hard=true, 						},
	["#soup#bread"]					= { 						 chance=100,	big=50,   elderyly=200,	kid=50,		veg=true,	hard=true, 						},
	["#lam#redsauce"]				= { 						 chance=100,	big=200,  elderyly=100,	kid=0,		veg=false,									},
	["#lam#whitesauce"]				= { 						 chance=100,	big=100,  elderyly=150,	kid=0,		veg=false,									},
	["#salmon#redsauce"]			= { 						 chance=100,	big=200,  elderyly=100,	kid=0,		veg=false,									},
	["#salmon#whitesauce"]			= { 						 chance=100,	big=100,  elderyly=150,	kid=0,		veg=false,									},
	["#asparagus#redsauce"]			= { 						 chance=100,	big=100,  elderyly=200,	kid=0,		veg=true,									},
	["#asparagus#whitesauce"]		= { 						 chance=100,	big=100,  elderyly=200,	kid=0,		veg=true, 									},
}

levelDesc.drawerProductNames = {"lobster", "crab"}

function levelDesc:onInitialized()
	--' If level >= drawerProductIntroductionLevel
	local drawer = level:getObject("drawer")
	if (not drawer) then drawer = level:getObject("drawer_lobster") end
	if (not drawer) then drawer = level:getObject("drawer_lobster_crab") end

	--'assert(drawer, "Could not find \'drawer\' in the level!")
	if (not drawer) then
		print("Could not find \'drawer\' in the level! Should it be available here?")
	end
	level.drawer = drawer

	if (drawer) then
		local closedY = drawer.y
		local openY = 612
		local drawerOpenDistance = openY - closedY
		local drawerOpenDuration = 50
		local drawerTopCutoff = 71
		local drawerTop = drawer.y - drawer.anchor.y + drawerTopCutoff
		local drawerY = drawer.y
		drawer.clickable = true
		drawer.clipRect = { x=drawer.x - drawer.anchor.x, y=drawerTop, width=drawer.width, height=drawer.height }

--' Limit clickable surface to the front of the drawer
		drawer.isInside = function(self, x, y)
			local inside = false
			if (y > drawer.y - drawer.anchor.y + drawerTopCutoff) then
				inside = true
			end
			return (inside and drawer:def_isInside(x, y))
		end

		self.drawerProducts = {}
		for _,v in ipairs(self.drawerProductNames) do
			local product = level:getObject(v)
			if (product) then
				table.insert(self.drawerProducts, product)
				product:becomeChildOf(drawer)
				product.visible = false
			end
		end

		function handleDrawer(drawerClosing, task)
			local distance = 0
			if (drawer.forceOpen) then
				drawerClosing = false
				drawer.forceOpen = false
			elseif (drawer.forceClose) then
				drawerClosing = true
				drawer.forceClose = false
			end

			for _,product in ipairs(level.drawerProducts) do
				product.visible = not drawerClosing
			end
			if (not drawerClosing) then
				distance = drawerOpenDistance
			end

			local refY = (drawerClosing and closedY) or openY
			task.duration = drawerOpenDuration * ((drawer.y-refY)/drawerOpenDistance) + 50

			drawer.shouldClose = not drawerClosing
			drawer:animate({y=drawerY + distance, duration=drawerOpenDuration})
		end

		drawer.old_onWorkStart = drawer.onWorkStart
		drawer.onWorkStart = function(self, task)
			drawer.old_onWorkStart(drawer, task)

			handleDrawer(drawer.shouldClose, task)
--' If emily stands beside the drawer; floor needs to be changed mid animation.
--'			hero.direction = drawer.workDirection or "up"
--'			hero:playAnimation(drawer.workAnimation or "work", drawer.workCycles or -1, drawer.workFrameTime or 50, drawer.workWhenFinished or "default")
			return true
		end

--'		drawer.onWorkFinish = function(self, task)
--'			hero:playDefaultAnimation()
--'		end
--'		drawer.onClick = function()
			--'handleDrawer(drawer.shouldClose)
--'			Object.onClick(drawer)
--'			if (#self.drawerProducts > 0) then
--'				level.drawerWasEverClicked = true
--'			end
--'			return true
--'		end
	end

	--' Fish
	local roamX = 45
	local roamY = 11
	for i=1,10 do
		local fish = self:getSpriteExt("fish"..i)
		if (fish) then
			if (not self.fish) then
				self.fish = {}
			end
			--fish:playAnimation("swim", -1)
			table.insert(self.fish, fish)

			fish.originalX = fish.x
			fish.originalY = fish.y
			fish.roamX = roamX
			fish.roamY = roamY
			if (fish.name == "fish1") then
				fish.roamX = 35
				fish.roamY = 3
			end
			if (fish.name == "fish2") then
				fish.roamX = 27
				fish.roamY = 8
			end
			fish:animate({delay=math.Random(750)}, {call=function() levelDesc.fishSwim(fish) end})			
		end
	end
end

function levelDesc.fishSwim(fish)
	if (level and not level.shiftstateShiftFinished) then
		--' Since fish images are pointing left, but we name it right anyway, invert logic
		local goingRight = fish.flipHorizontal
		local targetX = fish.originalX
		local roamX = math.Random(fish.roamX)
		if goingRight then targetX = targetX + roamX else targetX = targetX - roamX end
		local targetPos = {x=targetX, y= fish.originalY + math.Random(fish.roamY*2)-fish.roamY}
		--fish:addTask({class="PositionTask", target=targetPos, duration=math.Random(3000)+8000})
		--fish:addTask({class="Task", duration= math.Random(100)+30})
		--fish:addTask({class="CallTask",
		--	func=function()
		--		fish.flipHorizontal = not fish.flipHorizontal
		--		levelDesc.fishSwim(fish)
		--	end})
		local swimtime = math.Random(3000)+8000
		fish:animate({x=targetPos.x, duration=swimtime})
		fish:animate({y=targetPos.y, duration=swimtime},
					{delay=math.Random(100)+30},
					{call=function()
						fish.flipHorizontal = not fish.flipHorizontal
						levelDesc.fishSwim(fish)
					end})
	end
end

function levelDesc:onTick(time)
	self:tick(time)
	if (self and self.fish and self.shiftstateShiftFinished) then
		for _,fish in ipairs(self.fish) do
			fish.currentCycles = 0
			fish:removeAllModifiers()
		end
	end
end

function levelDesc.beforeAddWorkTaskOnClick(self, obj, actor)
	local drawer = level.drawer
	if (drawer and actor == hero and drawer ~= obj) then
		local drawerProduct = false
		for _,product in ipairs(self.drawerProducts) do
			if (obj == product) then
				drawerProduct = true
			end
		end
		if (drawerProduct) then
			hero:addTask({class="CallTask", func=function() drawer.forceOpen = true end,})
			hero:addTask({class="WorkTask", target=drawer})--' Make sure drawer is open
			hero:addTask({class="CallTask", func=function()
				hero:addTask({class="CallTask", func=function()
					hero:addTask({class="CallTask", func=function() drawer.forceClose = true end,})
					hero:addTask({class="WorkTask", target=drawer})--' Close it afterward
				end,})
			end,})
		elseif (obj == level:getObject("lobster_cooked")) then
			hero:addTask({class="CallTask", func=function()
				if (drawer.shouldClose) then
					hero:addTaskAtFront({class="WorkTask", target=drawer})
				end
			end,})
--'		else
--'			hero:addTask({class="CallTask", func=function()
--'				if (drawer.shouldClose) then
--'					hero:addTaskAtFront({class="WorkTask", target=drawer})
--'				end
--'			end,})
		end
	end
end
