if (not skipIncludes) then
	dofile("script/rooms/room3.lua")
end

levelDesc.productSettings =
{
	["#toast.ready#cheese"]						= { 							chance=100,	big=50,		elderyly=100,	kid=75,		veg=true,	hard=true,	cheeseProduct=true,	},
	["#toast.ready#ham"]						= { 							chance=100,	big=50,		elderyly=100,	kid=75,		veg=false,	hard=true,						},
	["#toast.ready#marmelade"]					= { 							chance=100,	big=50,		elderyly=150,	kid=200,	veg=true,	hard=true,						},
	["#kiwi.ready#glass"]						= { consumeAnimation="drink",	chance=100,	big=0,		elderyly=150,	kid=150,	veg=true,	hard=true,						},
	["#strawberry.ready#glass"]					= { consumeAnimation="drink",	chance=100,	big=0,		elderyly=150,	kid=150,	veg=true,	hard=true,						},
	["#orange.ready#glass"]						= { consumeAnimation="drink",	chance=100,	big=50,		elderyly=100,	kid=75,		veg=true,	hard=true,						},
	["#kiwi.ready#vanillaice"]					= { 							chance=100,	big=150,	elderyly=100,	kid=200,	veg=true,	hard=true,	dessert=true,		},
	["#strawberry.ready#vanillaice"]			= { 							chance=100,	big=150,	elderyly=100,	kid=150,	veg=true,	hard=true,	dessert=true,		},
	["#orange.ready#vanillaice"]				= { 							chance=100,	big=150,	elderyly=100,	kid=150,	veg=true,	hard=true,	dessert=true,		},
	["#lettuce#cucumber#shrimp"]				= { 							chance=100,	big=25,		elderyly=200,	kid=0,		veg=false,	hard=true,						},
	["#lettuce#carrot#cucumber#shrimp"]			= { 							chance=100,	big=25,		elderyly=200,	kid=0,		veg=false,	hard=true,						},
	["#lettuce#carrot#cucumber#tomato#shrimp"]	= { 							chance=100,	big=25,		elderyly=200,	kid=0,		veg=false,	hard=true,						},
	["#croissant"]								= { 							chance=100,	big=100,	elderyly=200,	kid=100,	veg=true,									},
	["#baguette"]								= { 							chance=100,	big=100,	elderyly=100,	kid=100,	veg=true,									},
	["#milk"]									= { consumeAnimation="drink",	chance=100,	big=0,		elderyly=100,	kid=200,	veg=true,									},
	["#magazine"]								= { consumeAnimation="paper",	chance=75,	big=75,	    elderyly=100,	kid=50,		veg=true,									},
}				


function levelDesc:getExitPositionForCharacter(character, hasWon)
	if (character.name == "monkey") then
		return {x=663, y=201}
		--'return hasWon and {x=884, y=107} or nil
	end
	return nil
end


levelDesc.doBump = false
function levelDesc:onTrainBump(parallaxObject, parallaxLayer)
	self.doBump = not self.doBump
	if (self.doBump) then
		local count = 0
		local down = false
		local howMuch
		self:doEvery(0, function()
			down = not down
			if (down) then
				howMuch = math.Random(0.6, 1.0)
				--self.gameLayer.y = self.gameLayer.y + howMuch
				parallaxObject.y = parallaxObject.y - howMuch
				return 60
			end
			--self.gameLayer.y = self.gameLayer.y - howMuch
			parallaxObject.y = parallaxObject.y + howMuch

			--' bump 2 times
			count = count + 1
			if (count > 1) then
				return false
			end

			return 80
		end)
	end
end
--[[
function levelDesc:onInitialized()
--'	DelLevel.onLevelInitialized(self)
	level.climbingLadderQueued = false
	level.ladderClimbSpeed = 200/1000
	level.ladderTopY = 207
	local magazineShelf = level:getObject("magazine_stock")
	level.magazineShelf = magazineShelf
	--'assert(magazineShelf, "Could not find \'magazine_stock\' in the level!")
	if (not magazineShelf) then
		print("Could not find \'magazine_stock\' in the level! Should it be available here?")
	end
	if (magazineShelf and level:getObject("magazine")) then
		magazineShelf.old_onWorkStart = magazineShelf.onWorkStart
		magazineShelf.old_onWorkUpdate = magazineShelf.onWorkUpdate
		magazineShelf.old_onWorkFinish = magazineShelf.onWorkFinish

		magazineShelf.onClick = function(self)
			magazineShelf.super.onClick(magazineShelf)
			level.climbingLadderQueued = true
		end

		magazineShelf.onWorkStart = function(self, task)
			level.holdAnimation = true

			if (hero.topOfLadder) then
				return magazineShelf:old_onWorkStart(task)
			end
			if (not hero.climbingLadder) then
				task.old_duration = task.duration
				task.duration = -1
				hero.climbingLadder = true
				hero.topOfLadder = false
				hero.origFloor = hero.floor
				task.climbDistance = magazineShelf.workPos.y - level.ladderTopY
				hero:playAnimation("climbing", -1, 50, "stay")
				hero.frame = 3--'Skip a few frames.. (Still looks weird)
				--'hero:playAnimation("climb_ladder", -1, 150, "stay")
			end
			return true
		end

		magazineShelf.onWorkUpdate = function(self, task, time)
			if (not hero.topOfLadder and hero.climbingLadder) then
				if (hero.floor - hero.origFloor >= task.climbDistance) then
					hero.floor = hero.origFloor + task.climbDistance
					hero.topOfLadder = true
					task.duration = task.old_duration
					magazineShelf:old_onWorkStart(task)
				else
					moveHeroAlongLadder(time, false)
					return false
				end
			end
			return magazineShelf:old_onWorkUpdate(task, time)
		end

		magazineShelf.onWorkFinish = function(self, task)

			level:beforeAddWorkTaskOnClick(nil, task.actor)

			hero:addTask({class="PlayDefaultAnimationTask"})
			magazineShelf:old_onWorkFinish(task)
		end
	end
end

function levelDesc.beforeAddWorkTaskOnClick(self, obj, actor)

	local magazineShelf = level.magazineShelf
	if (magazineShelf and actor == hero and magazineShelf ~= obj and level:getObject("magazine")) then
		if (level.climbingLadderQueued) then
			hero:addTask({class="PlayAnimationTask", animation="climbing", cycles=-1, reverse=true, frameTime=100})
			--'hero:addTask({class="PlayAnimationTask", animation="climb_ladder", cycles=-1, reverse=true,})
			hero:addTask({class="CallTask", func = function() hero.topOfLadder = false end,})
			hero:addTask({class="LuaTask",
				update=function(self, time)
					moveHeroAlongLadder(time, true)
					if (hero.floor <= hero.origFloor) then
						hero.floor = hero.origFloor
						return true
					end
					return false
				end,})
			hero:addTask({class="PlayDefaultAnimationTask"})
			hero:addTask({class="CallTask", func = function()
				hero.climbingLadder = false
				level.climbingLadderQueued = false
				level.holdAnimation = false
			end,})
		end
	end
end

function moveHeroAlongLadder(time, goingDown)
	local frameDistance = level.ladderClimbSpeed * time
	if (goingDown) then
		frameDistance = -frameDistance
	end
	hero.floor = hero.floor + frameDistance
	--' TODO: Fix shadow disappearing when floor is being animated; reappears when done..
end
]]