if (not skipIncludes) then
	dofile("script/rooms/room2.lua")
end

levelDesc.productSettings =
{
	["#sangria"]					= {consumeAnimation="drink",	chance=75,	big=100, 	elderly=25,		kid=0,		veg=true,								},
	["#coffeecup"]					= {consumeAnimation="drink",	chance=100,	big=50,		elderly=150,	kid=0,		veg=true,								},
	["#fan"]						= {								chance=75,	big=100,	elderly=200, 	kid=25,		veg=true, 				edible=false	},
	["#sunglasses"]					= {								chance=75,	big=100 ,	elderly=75, 	kid=50,		veg=true, 				edible=false	},
	["#spanishhat"]					= {								chance=75,	big=100,	elderly=200, 	kid=50,		veg=true, 				edible=false	},
	["#rice#vegetarian.ready"]		= {								chance=75,	big=25, 	elderly=100,	kid=0,		veg=true,	hard=true,					},
	["#rice#seafood.ready"]			= {								chance=75,	big=50, 	elderly=150,	kid=0,		veg=false,	hard=true,					},
	["#rice#chicken.ready"]			= {								chance=75,	big=50, 	elderly=100,	kid=0,		veg=false,	hard=true,					},
	["#calamari.ready#redsauce"]	= {								chance=75,	big=125, 	elderly=100,	kid=25,		veg=false,	hard=true,					},
	["#patatas.ready#redsauce"]		= {								chance=75,	big=125, 	elderly=100,	kid=150,	veg=true,	hard=true,					},
	["#jamon"]						= {								chance=100,	big=200, 	elderly=200,	kid=100,	veg=false,								},
	["#sausage"]					= {								chance=75,	big=100, 	elderly=75,		kid=75,		veg=false,								},
	["#palmera#chocolate"]			= {								chance=100,	big=200, 	elderly=100,	kid=200,	veg=true,				dessert=true,	},
	["#churro#chocolate"]			= {								chance=100,	big=200, 	elderly=100,	kid=200,	veg=true,				dessert=true,	},
}	

levelDesc.showSuitcases = true
levelDesc.suitcaseEntrancePositions = { {x=723, y=20}, }
levelDesc.suitcaseExitPositions = { {x=1162, y=118}, }
levelDesc.suitcases = {"suitcase_1", "suitcase_2", "suitcase_3", "suitcase_4", "suitcase_5", "suitcase_6", "suitcase_7", "suitcase_8", "suitcase_9", "suitcase_10", "suitcase_11", "suitcase_12", "suitcase_13", "suitcase_14"}
levelDesc.suitcaseDuration = 1000

function levelDesc:onTick(time)
	self:tick(time)
	if (self.showSuitcases and not (self.isShiftClosed or self.hasShiftFinished)) then
		self.suitcaseDuration = self.suitcaseDuration - time
		if (self.createCharacter and self.suitcaseDuration <= 0) then
			local suitcaseBaseAnim = self.suitcases[math.Random(#self.suitcases)]
			local suitcase = self:createCharacter({base="default", walkSpeed=44, defaultSection="room2_icons",
						baseAnimation=suitcaseBaseAnim, --'shadowResource=suitcaseBaseAnim.."_walk_shadow", --'TODO: Flag to not change shadow offset relative to floor
						x=self.suitcaseEntrancePositions[1].x, y=self.suitcaseEntrancePositions[1].y})
			suitcase:addTask({class="WalkToTask", target=self.suitcaseExitPositions[1]})
			suitcase:addTask({class="RemoveTask"})
			self.suitcaseDuration = math.Random(4000, 7000)
		end
	end
end

function levelDesc:defaultOnInitialized()
	local phone_keys = level:getObject("phone_keys");
	if (phone_keys) then
		phone_keys.onClick = function()
			phone_keys:playSample("SOUND_CASH_REGISTER_CUSTOMER")
		end
	end

--'	Match3Egg.initSource("phone_keys")
end
