--' ************************************ TriggerObject ************************************ '--
TriggerObject = deriveLuaClass("TriggerObject", "SpriteExt")

function TriggerObject:init(desc)
	TriggerObject.superInit(self, desc)

	self.triggerPrefix = desc.triggerPrefix or "trigger"
	self.active = desc.active ~= false
	self.charactersInside = {}
end

function TriggerObject:onLevelInitialized()
	TriggerObject.super.onLevelInitialized(self)
end

function TriggerObject:onTick(time)
	self:tick(time)

	local currentCharactersInside = {}
	for _,character in ipairs(level:getCharacters()) do		
		if (self:def_isInside(character.x, character.y)) then
			currentCharactersInside[character.name] = true
		end
	end

	if (self.active == false) then
		return
	end

	--' check for new characters
	local someoneEntered = false
	for enterCharacterName,_ in pairs(currentCharactersInside) do
		if (not self.charactersInside[enterCharacterName]) then
			someoneEntered = true
			self:fireTrigger("onEnter", enterCharacterName)
		end
	end

	--' check for characters gone
	local someoneLeft = false
	for leaveCharacterName,_ in pairs(self.charactersInside) do
		if (not currentCharactersInside[leaveCharacterName]) then
			someoneLeft = true
			self:fireTrigger("onLeave", leaveCharacterName)
		end
	end

	if (someoneEntered and table.count(self.charactersInside) == 0) then
		self:fireTrigger("onEntered")
	end

	if (someoneLeft and table.count(currentCharactersInside) == 0) then
		self:fireTrigger("onEmpty")
	end
	
	--' assign new character table
	self.charactersInside = currentCharactersInside
end

function TriggerObject:fireTrigger(postfix, characterName)
	for i=1,20 do
		local objName = self["objectToTrigger"..i]
		if (objName) then
			level:fireTrigger("object", {type=self.triggerPrefix.."_"..postfix, name=objName, triggerObject=self, characterName=characterName})
		end
	end
	
	if (self.fireToLevel == true) then
		level:fireTrigger(self.triggerPrefix.."_"..postfix, {triggerObject=self, characterName=characterName})
	end
end

function TriggerObject:getNumCharactersInside()
	return table.count(self.charactersInside)
end