--' ************************************ Tree ************************************ '--
Tree = deriveLuaClass("Tree", "IngredientButton")

function Tree:init(desc)
	Tree.superInit(self, desc)
	self.regrowDelayMin = self.regrowDelayMin or 0
	self.regrowDelayMax = self.regrowDelayMax or 0
	self.regrowDelay = self.regrowDelay or 0
	self.rotationMin = self.rotationMin or 0
	self.rotationMax = self.rotationMax or 0
	self.startFruitAvailable = self.startFruitAvailable ~= false --' Default TRUE
	self.pickIndividual = self.pickIndividual or false --' Default false
	self.doRepositionFruits = self.doRepositionFruits ~= false --' Default TRUE

	self.clickable = true
end

function Tree:onLevelInitialized()
	 --' *** pi("Tree level initialized")
	Tree.super.onLevelInitialized(self)

	self.fruits = {}
	for i=1,20 do
		local fruit = self["fruit"..i]
		if (fruit) then
			fruit = level:getSpriteExt(fruit)
			 --' *** pb("fruit"..ts(i)..": "..self["fruit"..i].." = "..ts(fruit)..",")
			if (fruit) then
				fruit.state = "inactive"
				table.push_back(self.fruits, fruit)
			end
		end
	end

	if (not self.growPositions or #self.growPositions < #self.fruits) then
		self.growPositions = self.growPositions or {}
		for _,v in ipairs(self.fruits) do
			table.push_back(self.growPositions, v.location)
		end
	end

	for _,v in ipairs(self.fruits) do
		v:becomeChildOf(self)
	end

	if (table.empty(self.fruits)) then
		 --' *** pr("Empty tree.")
		self.clickable = false
	end

	if (self.startFruitAvailable) then
		for _,v in ipairs(self.fruits) do
			self:showFruit(v)
			v.state = "available"
		end
		self:resetRegrowDelay()
	end
	 --' *** pd()
end

function Tree:resetRegrowDelay()
	self.regrowDelay = math.Random(self.regrowDelayMin, self.regrowDelayMax)
end

function Tree:getNewFruitPos()
	local selfPos = self.screenLocation
	local pos = {x=0, y=0}
	local maxDist = 0
	if (self.growPositions and #self.growPositions > 0) then
		local num = #self.growPositions
		local idxOffset = math.Random(num)
		for i=1,num do
			local loc = self.growPositions[((i + idxOffset) % num) + 1]
			local minDist
			for _,v in ipairs(self.fruits) do
				if (v.state ~= "inactive") then
					local dist = {x=v.x - (loc.x-selfPos.x), y=v.y - (loc.y-selfPos.y)}
					dist = dist.x*dist.x + dist.y*dist.y
					if (not minDist or dist < minDist) then
						minDist = dist
					end
				end
			end
			if (not minDist) then
				return loc
			end
			if (minDist > maxDist) then
				maxDist = minDist
				pos = loc
			end
			i = i + 1
		end
	end
	return pos
end

function Tree:showFruit(fruit)
	if (self.doRepositionFruits) then
		local pos = self:getNewFruitPos()
		fruit.location = {x=pos.x - self.worldX, y=pos.y - self.worldY}
	end
	fruit.rotation = math.Random(self.rotationMin, self.rotationMax)
	fruit.flipGrowth = self.allowFlipFruit and math.Random(1000) < 500
	fruit.scaleX = self.allowFlipFruit and ((fruit.flipGrowth and -1) or 1) or fruit.scaleX
end

function Tree:onTick(time)
	self:tick(time)
	if (self.fruits) then
		local offset = math.Random(#self.fruits)
		local count = 0;
		for i = 1,#self.fruits do
			local v = self.fruits[((i + offset) % #self.fruits) + 1]
			if (v.state == "available") then
				count = count+1
				if (count == #self.fruits) then
					self:resetRegrowDelay()
				end
			end
			if (v.state == "inactive") then
				self.regrowDelay = self.regrowDelay - time
				if (self.regrowDelay <= 0) then
					self:showFruit(v)
					v.state = "prepare"
					self:resetRegrowDelay()
					self.regrowDelay = self.regrowDelay + v.prepareDuration
				end
				break
			end
		end
	end
end

function Tree:notify_onClick(ing)
	if (not self.pickIndividual) then
		--' Catch the click and handle it yourself
		self:onClick()
		return true
	end
end

function Tree:allowWork(actor)
	 --' *** pb("Tree allow work? "..tostring(isTable(self.notifyObject)))
	return isTable(self.notifyObject)
end

function Tree:allowIngredientWork(actor)
	return true
end

function Tree:onWorkStart(task)
	self.todoFruits = {}
	for _,v in ipairs(self.fruits) do
		if (v.state == "available") then
			table.push_back(self.todoFruits, v)
		end
	end

	if (table.empty(self.todoFruits)) then
		self:defaultOnWorkFinish(task, false)
		return false
	end

	self:playSample("SOUND_PICK_FROM_BUSH:sound")

	return Tree.super.onWorkStart(self, task)
end

function Tree:defaultOnWorkStart(task)
	Tree.super.defaultOnWorkStart(self, task)
	task.duration = task.duration * #self.todoFruits
end

function Tree:onWorkFinish(task,success)
	self:defaultOnWorkFinish(task, success)
end

function Tree:commitFruits(num)
	-- --' *** pi("["..self.name.."] Commit fruits:")
	if (self.notifyObject) then
		-- --' *** pr("-> notifyObject")
		for i=1,num do
			local v = self.todoFruits[i]
			if (v and v.state == "available") then
				-- --' *** pr("#"..ts(i))
				local pos = v.screenCenter
				v.flipGrowth = false
				v.scaleX = math.abs(v.scaleX)
				self.notifyObject:notify_onCommit(v, v.ingredientName, pos.x, pos.y)
			end
		end
	end
	-- --' *** pd()
end

function Tree:onWorkUpdate(task, time)
	 --' *** pb("Tree work update")
	self:commitFruits(#self.todoFruits * task.timer.fraction)
	return Tree.super.onWorkUpdate(self, task, time)
end

function Tree:onCommit(productName, x, y)
	 --' *** pi("Tree on commit")
	self:commitFruits(#self.todoFruits)
	 --' *** pd()
end
