--' ************************************ Tap ************************************ '--
Tap = deriveLuaClass("Tap", "IngredientButton")

function Tap:onLevelInitialized()
	Tap.super.onLevelInitialized(self)

	self.blockInputDuringWork = true

	self.productAppend = self.productAppend or ""
	self.tapTimer = level:getSpriteExt(self.timerId or "")
	self.container = level:getSpriteExt(self.containerId or "")
	 --' *** pi("["..self.name.."] Level initialized:")
	 --' *** pr("timer: "..self.timerId.."="..tostring(self.tapTimer ~= nil))
	 --' *** pr("container: "..self.containerId.."="..tostring(self.container ~= nil))

	self.originalIngredientName = self.ingredientName
	
	if (self.container) then
		self.oneThirdWorkDuration = self:calcValue("workDuration") / 3
		self.container.state = "inactive"
		self.container.prepareDuration = self.oneThirdWorkDuration
		self.container.decayDelay = self.oneThirdWorkDuration
		self.container.decayDuration = -1 --' Infinite
		if (not self.matchContainerProduct) then
			self.originalIngredientName = self.container.ingredientName or ""
			 --' *** pr("ingredientName by container = "..self.originalIngredientName)
		end
	end
	self:setIngredientName(self.originalIngredientName)
	 --' *** pd()

	self.acceptObjects = {}
	for i=1,20 do
		local obj = self["acceptObject"..i]
		if (obj) then
			obj = level:getSpriteExt(obj)
			if (obj) then
				table.push_back(self.acceptObjects, obj)
			end
		end
	end
end

function Tap:listPossibleIngredients()
	if (self.matchContainerProduct) then
		return {self.originalIngredientName or self.ingredientName or ""}
	end
	return {self.container and self.container.ingredientName or ""}
end

function Tap:setIngredientName(ingredientName)
	self.ingredientName = ingredientName
	if (self.productAppend and #self.productAppend > 0) then
		self.ingredientName = self.ingredientName.."."..self.productAppend
	end
	if (self.matchContainerProduct) then
		if (self.container) then
			self.container:setIngredientAndResource(self.ingredientName)
		end
	else
	end
end

function Tap:onWorkStart(task)
	self.clickedObject = nil

	if (Tap.super.onWorkStart(self, task)) then
		--'hintManager:openHint({hintId="CoffeeReady"})

		if (self.container) then
			self.container.visible = true
			self.container.state = "prepare"
			self:setIngredientName(self.originalIngredientName)
		end
		if (self.hideDuringWork) then
			self.visible = false
		end
	end
	self.clicked = false
	return true
end

function Tap:onWorkClick(task, x, y)
print("DDDDD")
	self.clicked = true
	for _,v in ipairs(self.acceptObjects) do
print("DDDDD")
		if (v:isInside(x, y)) then
print("DDDDD")
			self.clickedObject = v
		end
	end
	return true
end

function Tap:isSuccess(time)
	return time >= self.oneThirdWorkDuration and
		time <= self.oneThirdWorkDuration * 2
end

function Tap:onWorkUpdate(task, time)
--'	if (not self.clicked) then
--'		if (task.timer.time >= self.oneThirdWorkDuration * 1.2) then
--'			hintManager:openHint({hintId="TapMissed", showButton=false, closeOnClickAnywhere=true, blockInputToLevel=false})
--'		elseif (task.timer.time >= self.oneThirdWorkDuration and string.find(self.ingredientName, ".pulp")) then
--'			hintManager:openHint({hintId="CupOverflowGlass", showButton=false, closeOnClickAnywhere=true, blockInputToLevel=false})
--'		end
--'	end

	if (self.tapTimer) then
		self.tapTimer:setFraction(task.timer.fraction)
	end
	if (Tap.super.onWorkUpdate(self, task, time)) then
		return true
	end
	return self.clicked
end

function Tap:getProductCenter()
	if (self.container) then
		return self.container.screenCenter
	end
	return self.screenCenter
end

function Tap:onWorkFinish(task)
	if (self:isSuccess(task.timer.time)) then
		Tap.super.onWorkFinish(self, task)
		player:setNeverShowHint("CoffeeReady")
		player:setNeverShowHint("TapMissed")
--'		player.gameStats:incTimesNotSpilled()	
	else
		tray:clearCurrentIngredients()
		self:defaultOnWorkFinish(task, success)
	end

	if (self.container) then
		self.container.visible = false
		self.container.state = "inactive"
	end
	if (self.hideDuringWork) then
		self.visible = true
	end

	if (self.tapTimer) then
		self.tapTimer:setFraction(0.0)
	end

	if (self.clickedObject) then
		self.clickedObject:onClick()
		self.clickedObject = nil
	end
end

function Tap:characterOnWorkFinish(task, success)
	if (not self.clickedObject) then
		Tap.super.characterOnWorkFinish(self, task, success)
	end
end

--' ************************************ Tap Timer ************************************ '--
TapTimer = deriveLuaClass("TapTimer", "Object")

function TapTimer:init(desc)
	TapTimer.superInit(self, desc)
end

function TapTimer:onLevelInitialized()
	self.pointer = level:getSpriteExt(self.pointerId or "")
end

function TapTimer:setFraction(frac)
	if (self.pointer) then
		self.pointer.rotation = 360 * frac
	end
end
