--' ************************************ Tap Timer ************************************ '--
StatusTimer = deriveLuaClass("StatusTimer", "StatusObject")

function StatusTimer:init(desc)
	StatusTimer.superInit(self, desc)
end

function StatusTimer:onLevelInitialized()
	self.pointer = level:getSpriteExt(self.pointerId or "")
	assert(self.pointer)
end

function StatusTimer:statusUpdate(status, init, ing)
	StatusTimer.super.statusUpdate(self, status, init, ing)
	if (not self.pointer) then
		return
	end
	if (status == "inactive") then
		self.pointer.rotation = 0
	end
end

function StatusTimer:status_onUpdateStatusFraction(frac)
	local totalFrac = 0
	if (self.pointer) then
		if (self.curStatus == "prepare") then
			totalFrac = frac/3
		elseif (self.curStatus == "ready") then
			totalFrac = 1/3 + frac/3
		elseif (self.curStatus == "decay") then
			totalFrac = 2/3 + frac/3
		end		
		self.pointer.rotation = 360 * totalFrac
	end
end

