--' ************************************ Status Object ************************************ '--
StatusObject = deriveLuaClass("StatusObject", "SpriteExt")

StatusObject.statusTables = {
	{ "prepare", "ready", "decay", "inactive", },
	{ "empty", "stocked", "maxstock" },
	{ "workstart", "workfinish" },
}

function StatusObject:init(desc)
	StatusObject.superInit(self, desc)

	self.useBaseFromIngredient = desc.useBaseFromIngredient
	self.startState = self.startState or "inactive"
	self.curStatus = self.startState
	for _,t in ipairs(self.statusTables) do
		for _,v in ipairs(t) do
			self:statusInit(v)
			if (v == self.startState) then
				self.statusTable = t
			end
		end
	end

	self.start_baseAnimation = self.baseAnimation
	self:statusUpdate(self.startState, true, nil)
end

function StatusObject:shouldShowState(state)
	return table.contains(self.statusTable, state)
end

function StatusObject:statusInit(status)
	self[status.."Visible"] = self[status.."Visible"] ~= false
	self[status.."Alpha"] = self[status.."Alpha"] or 1
	self[status.."FadeTime"] = self[status.."FadeTime"] or 120
	self[status.."Animation"] = self[status.."Animation"] or ""
	self[status.."BaseFromIngredient"] = self[status.."BaseFromIngredient"] or false
end

function StatusObject:statusUpdate(status, init, ing)
	if (init or self:shouldShowState(status)) then
		self.curStatus = status
		self:cancelAnimations()
		self.visible = self[status.."Visible"]
		if (init) then
			self.alpha = self[status.."Alpha"]
		else
			self:animate({alpha=self[status.."Alpha"], duration=self[status.."FadeTime"]})
		end
		if (self[status.."BaseFromIngredient"]) then
			assert(self.baseAnimationPrefix, "no baseAnimation Prefix set")
			self.baseAnimation = self.baseAnimationPrefix..ing.ingredientName
		else
			self.baseAnimation = self.start_baseAnimation
		end
		if (self[status.."Frame"] and self[status.."Frame"] >= 0) then
			self.frame = self[status.."Frame"]
		end
		if (self[status.."DoAnimation"]) then
			self:playAnimation(self[status.."Animation"], self[status.."Cycles"], self[status.."FrameTime"], self[status.."WhenFinished"])
		end
	end
end

function StatusObject:status_onStartPreparing(ing)
	self:statusUpdate("prepare", nil, ing)
end

function StatusObject:status_onBecomeAvailable(ing)
	self:statusUpdate("ready", nil, ing)
end

function StatusObject:status_onDecay(ing)
	self:statusUpdate("decay", nil, ing)
end

function StatusObject:status_onDeactivate(ing)
	self:statusUpdate("inactive", nil, ing)
end

function StatusObject:status_onDisplayStockChange(obj, ing)
	if (obj.usesStock) then
		if (not obj:checkStock()) then
			self:statusUpdate("empty", nil, ing)
		elseif (obj.stock == obj.maxStock) then
			self:statusUpdate("maxstock", nil, ing)
		else
			self:statusUpdate("stocked", nil, ing)
		end
	end
end

function StatusObject:status_onWorkStart(ing)
	self:statusUpdate("workstart", nil, ing)
end

function StatusObject:status_onWorkFinish(ing)
	self:statusUpdate("workfinish", nil, ing)
end

function StatusObject:status_onUpdateStatusFraction(frac)
end