--' ************************************ Station ************************************ '--
Station = getClass("Station")

function Station:addSelectedObjectToStationTasks()
	local obj = level.selectedObject
	obj:addTask({class="CallTask", func=function()
		self:comeIn(obj)
		if (level.selectedObject == obj or level.selectedObject == self) then
			level:resetSelectedObject()
		end
		obj:removeOverhead(false)
	end})
	obj:addTask({class="LeaveStationTask"})
	obj:addTask({class="PlaceCustomerTask", target=self})
end

function Station:addToStationTask()
	if (level.selectedObject) then
		if (self:canWalkToStation(level.selectedObject)) then
			self:stopFaultySelectionBlink()
			self:addSelectedObjectToStationTasks()
			return true
		else
			self:blinkFaultySelection()
			level:cancelSelectedObject()
			return false
		end
	end
	return false
end

function Station:canWalkToStation(character)
	assert(character)
	if (self:canPlace(character) and
		self.totalOccupants < self.maxOccupants and
		character:getState() ~= "waiting at checkout") then
		return true
	end
	return false
end
