--' ************************************ Tap ************************************ '--
SpecialTap = deriveLuaClass("SpecialTap", "IngredientButton")

function SpecialTap:onLevelInitialized()
	SpecialTap.super.onLevelInitialized(self)

	self.productAppend = self.productAppend or ""
	self.tapTimer = level:getSpriteExt(self.timerId or "")
	self.container = level:getSpriteExt(self.containerId or "")
	 --' *** pi("["..self.name.."] Level initialized:")
	 --' *** pr("timer: "..self.timerId.."="..tostring(self.tapTimer ~= nil))
	 --' *** pr("container: "..self.containerId.."="..tostring(self.container ~= nil))

	self.originalIngredientName = self.ingredientName


	if (self.container) then
		self.oneThirdWorkDuration = self.preparationTime or 1250--'tapDuration--'self:calcValue("preparationTime") / 3
		self.container.state = "inactive"
		self.container.prepareDuration = self.oneThirdWorkDuration
		self.container.decayDelay = self.oneThirdWorkDuration
		self.container.decayDuration = self.oneThirdWorkDuration
		if (not self.matchContainerProduct) then
			self.originalIngredientName = self.container.ingredientName or ""
			 --' *** pr("ingredientName by container = "..self.originalIngredientName)
		end
	end

	self:setIngredientName(self.originalIngredientName)
	 --' *** pd()

	self.acceptObjects = {}
	for i=1,20 do
		local obj = self["acceptObject"..i]
		if (obj) then
			obj = level:getSpriteExt(obj)
			if (obj) then
				table.push_back(self.acceptObjects, obj)
			end
		end
	end
end

function SpecialTap:listPossibleIngredients()
	if (self.matchContainerProduct) then
		return {self.originalIngredientName or self.ingredientName or ""}
	end
	return {self.container and self.container.ingredientName or ""}
end

function SpecialTap:setIngredientName(ingredientName)
	self.ingredientName = ingredientName
	if (self.productAppend and #self.productAppend > 0) then
		self.ingredientName = self.ingredientName.."."..self.productAppend
	end
	if (self.matchContainerProduct) then
		if (self.container) then
			self.container:setIngredientAndResource(self.ingredientName)
		end
	else
	end
end

function SpecialTap:getProductCenter()
	if (self.container) then
		return self.container.screenCenter
	end
	return self.screenCenter
end

function SpecialTap:onWorkFinish(task)
	--'SpecialTap.super.onWorkFinish(self, task)

	self:defaultOnWorkFinish(task, success)
	self.container.state = "prepare"
	if (self.hideDuringWork) then
		self.visible = false
	end
	self.done = false
	self.timePassed = 0
	self.tapTimer:addTask({class="LuaTask",
		update=function(obj, time)
			if (self.done) then
				return true
			end
			self.timePassed = self.timePassed + time
			local frac = self.timePassed/(self.oneThirdWorkDuration * 3)
			self.tapTimer:setFraction(frac)

			if (frac > 1) then
				self.tapTimer:setFraction(1)
				return true
			end
			return false
		end})
end

function SpecialTap:notify_onCommit(ing, productName, x, y)
	--if (self.hideDuringWork) then
		self.visible = true
	--end
	self.done = true
	self.tapTimer:setFraction(1)
end

function SpecialTap:notify_onBecomeAvailable()
	if (player:mayShowHint("TapMissed")) then
		self:animate({delay=self.oneThirdWorkDuration*0.95},
			{call=function()
				if (not self.done) then
					hintManager:openHint({hintId="TapMissed", target=self, subject=self, showButton=false})
				end
			end})
	end
end

function SpecialTap:notify_onDeactivate()
	self.visible = true
	self.done = true
	self.tapTimer:setFraction(1)
end

function SpecialTap:notify_onClick()
	self.done = true
end

function SpecialTap:notify_onWorkFinish()
	self.tapTimer:setFraction(1)
end

