--' ************************************ Shelf ************************************ '--
Shelf = deriveLuaClass("Shelf", "IngredientButton")

function Shelf:init(desc)
	Shelf.superInit(self, desc)

	self.allowBreak = self.allowBreak ~= false --' Default true
	self.onlyWhenEmpty = self.onlyWhenEmpty or false --' Default FALSE
	self.alwaysCompleteOne = self.alwaysCompleteOne ~= false
	self.clickable = true
end

function Shelf:onLevelInitialized()
	Shelf.super.onLevelInitialized(self)

	self.items = {}
	for i=1,20 do
		local item = self["item"..i]
		if (item) then
			item = level:getSpriteExt(item)
			if (item) then
				assert(isNumber(item.stock))
				assert(isNumber(item.maxStock))
				assert(item.usesStock)
				table.push_back(self.items, item)
			end
		end
	end
end

function Shelf:getIngredientNameForLogic()
	return ""
end

function Shelf:hasWorkTodo()
	return self:getLevelsToRestock() > 0
end

function Shelf:allowIngredientWork(actor)
	return true
end

function Shelf:isStockEmpty()
	for _,v in ipairs(self.items) do
		if (v.usesStock and v.stock == 0) then
			return true
		end
	end
	return false
end

function Shelf:getLevelsToRestock()
	local levels = 0
	for _,v in ipairs(self.items) do
		if (v.usesStock and not self.onlyWhenEmpty or v.stock == 0) then
			levels = levels + v.maxStock - v.stock
		end
	end
	return levels
end

function Shelf:getWorkDurationWith(actor)
	self.levelDuration = Shelf.super.getWorkDurationWith(self, actor)
	return self.levelDuration * self:getLevelsToRestock()
end

function Shelf:onWorkStart(task)
	local num = self:getLevelsToRestock()
	if (num > 0) then
		if (self.workFrameTime == nil or self.workFrameTime < 0) then
			self.workCycles = num
		end
		self:defaultOnWorkStart(task)
		self.currentLevel = 1
		return true
	end
	return false
end

function Shelf:getSmallestStock()
	local smalleststock
	for k,v in ipairs(self.items) do
		if (v.usesStock and
			v.stock < v.maxStock and
			(not smalleststock or v.stock < smalleststock.stock))
		then
			smalleststock = v
			self.currentResourceIndex = k
		end
	end
	return smalleststock
end

function Shelf:incRestockLevel(currentTime)
	while (self:calcValue("workDuration") * self.currentLevel <= currentTime) do
		local v = self:getSmallestStock()
		if (not v) then return end
		self.currentLevel = self.currentLevel + 1
		local pos = self.throwPos or {x=self.width/2, y=self.height/2}
		v:animate(
			{call=function() v:throwCopy(self.left + pos.x - v.width/2, self.top + pos.y - v.height/2, level.topLayer, true) end},
			{delay=throwDuration},
			{call=function() v:incDisplayStock() end}
		)
		v:incStock()
	end
end

function Shelf:onWorkUpdate(task, time)
	self:incRestockLevel(task.timer.time)
	return self.allowBreak and taskSystem:hasTaskFor(task.actor) and (not self.alwaysCompleteOne or self.currentLevel > 1)
end

function Shelf:onWorkFinish(task)
	self:defaultOnWorkFinish(task, true)
	self:incRestockLevel(task.timer.time + 1)
end
