--' ************************************ Progress Bar ************************************ '--
ProgressBar = deriveLuaClass("ProgressBar", "SpriteExt")

function ProgressBar:init(desc)
	self.horizontal = true
	self.progress = 0

	ProgressBar.superInit(self, desc)

	if (desc.back) then
		self.back = self:newChild(desc.back)
	end
	if (desc.front) then
		self.front = self:newChild(desc.front)
	end
	if (desc.label) then
		self.label = self:newChild(desc.label)
	end

	self:update()
end

function ProgressBar:setProgress(progress)
	self.progress = progress
	if (self.label) then
		if (progress == 1) then
			self.label.text = "100%"
		else		
			self.label.text = string.format("%.0f",progress*99).."%"
		end
	end
	self:update()
end

function ProgressBar:update()
	local s = self.front
	if (s) then
		local anchor = s.anchor
		if (self.horizontal) then
			s.clipRect = { x=s.x - anchor.x, y=s.y - anchor.y, width=s.width * self.progress, height=s.height }
		else
			local h = s.height * self.progress
			s.clipRect = { x=s.x - anchor.x, y=s.y - anchor.y + s.height - h, width=s.width, height=h }
		end
	end
end

function ProgressBar:finish()
	self.progress = 1
	self.label.text = "100%"
	self:update()
end