PortionIngredient = deriveLuaClass("PortionIngredient", "IngredientButton")

function PortionIngredient:init(desc)
	PortionIngredient.superInit(self, desc)
	
	self.ingredients = {}
	self.old_highlighted = false
	self.old_isDown = false
	self.selectedIdx = 0
end

function PortionIngredient:onLevelInitialized()
	PortionIngredient.super.onLevelInitialized(self)
	for i=1, 20 do
		local ingName = self["ingredients"..i]
		if (ingName) then
			table.push_back(self.ingredients, level:getObject(ingName))
			assert(self.ingredients[i], "ingredient does not exist: "..ingName)
		end
	end
end

function PortionIngredient:onTick(time)
	self:tick(time)

	local selected = not self.highlighted and not self.isDown and self.highlightTargetAlpha > 0
	if (self.old_selected ~= selected) then
		self.old_selected = selected
		
		for _,v in ipairs(self.ingredients) do
			if (selected == true) then
				v.selectedIdx = v.selectedIdx + 1
			else
				v.selectedIdx = v.selectedIdx - 1
				v.selectedIdx = math.max(0, v.selectedIdx)
			end
			v.selected = v.selectedIdx > 0
		end

	else
		local down = self.isDown
		if (self.old_isDown ~= down) then
			self.old_isDown = down

			for _,v in ipairs(self.ingredients) do
				v.isDown = down
			end

			if (down == false) then
				local p = ghf.getMouseCursorPos()
				for _,v in ipairs(self.ingredients) do
	--'				if (level.mouseDownObject and level.mouseDownObject.name == v.name) then
					if (v:isInside(p.x, p.y)) then
						v.isDown = true
						v.old_isDown = false
						v:onTick(0)
						break
					end
				end
			end
		else
			local highlighted = self.highlighted
			if (self.old_highlighted ~= highlighted) then
				self.old_highlighted = highlighted

				for _,v in ipairs(self.ingredients) do
					v.highlighted = highlighted
				end

				if (highlighted == false) then
	--'				local p = ghf.getMouseCursorPos()
					for _,v in ipairs(self.ingredients) do
						if (level.mouseOverObject and level.mouseOverObject.name == v.name) then
							v.highlighted = true
							v.old_highlighted = false
							v:onTick(0)
							break
						end
					end
				end
			end	
		end
	end
end