--' ************************************ Operator ************************************ '--
Operator = deriveLuaClass("Operator", "Object")

function Operator:init(desc)
	Operator.superInit(self, desc)
	self.timeOut = self.timeOut or 200
	self.timeOutTimer = 0
end

function Operator:onLevelInitialized()
	Operator.super.onLevelInitialized(self)

	if (isString(self.appliance)) then
		self.appliance = level:getSpriteExt(self.appliance)
	end
	if (not isTable(self.appliance)) then
		self.appliance = self
	end

	if (isString(self.operator)) then
		self.operator = level:getSpriteExt(self.operator)
	end
	if (isTable(self.operator)) then
		self.operator.onClick = function()
			self:operate()
			return true
		end
	end
end

function Operator:onTick(time)
	self:tick(time)

	if (self.operator) then
		self.operator.clickable = not taskSystem:hasAnimationFor(self.operator)
	else
		if (self.timeOutTimer > 0) then
			self.timeOutTimer = self.timeOutTimer - time
		end
		if (self.timeOutTimer <= 0) then
			self:operate()
		end
	end
end

function Operator:operate()
	if (self:hasWorkTodo() and self.appliance.pendingWorkTaskCount == 0) then
		self.appliance:onClick()
		self.timeOutTimer = self.timeOut
	end
end

function Operator:hasWorkTodo()
	local ap = self.appliance
	if (ap) then
		if (self.whenStockEmpty) then
			if (ap.usesStock and ap.stock == 0) then
				return true
			elseif (ap.isStockEmpty and ap:isStockEmpty()) then
				return true
			end
		elseif (ap.hasWorkTodo and ap:hasWorkTodo() and ap.pendingWorkTaskCount == 0) then
			return true
		end
	end
	return false
end
