--' ************************************ Mouse ************************************ '--
Mouse = deriveLuaClass("Mouse", "Object")

function Mouse:init(desc)
	desc.defaultSection = desc.defaultSection or "gamescene"

	desc.hitMaskThreshold = -1
	Mouse.superInit(self, desc)
	self.hitMaskThreshold = -1

	self.showing = false
	self.visible = false
	self.clickable = true
	self.baseAnimation = desc.baseAnimation or "MOUSE"
	self.moveType = self.moveType or "POP_UP"
	self.showTime = self.showTime or 5000
	self.minShowDelay = self.minShowDelay or 30000
	self.maxShowDelay = self.maxShowDelay or 120000
	self.floaterPosition = self.floaterPosition or {x=0,y=-30}
	self.scoreWhenFound = self.scoreWhenFound or 100

	self:pickNewShowDelay()
	self:hideMouse()

	if (self.targetPos) then
		self.location = self.targetPos
	end

	self.shadowResource = ""
end

function Mouse:onClick()
	if (self.visible and self.clickable) then
		self.clickable = false
		player:foundMouse()

		taskSystem:cancelAllTasksFor(self)
		self:addTask({class="PlayAnimationTask", animation=self.moveType.."_HIT", cycles=1, frameTime=1000, whenFinished="stay", wait=true})
		self:addTask({class="PlayAnimationTask", animation=self.moveType, cycles=1, frameTime=100, whenFinished="stay", wait=true, reversed=true})
		self:addTask({class="CallTask", func=function() self:hideMouse() end})

		--'local tmp = level:add({
		--'	class="SpriteExt", x=self.x, y=self.y,
		--'	children={
		--'		{class="ParticleEffect", library="MINIGAME_GOOD:objects", start=true},
		--'		{class="ParticleEffect", library="FOUND_GUINEAPIG:objects", start=true},
		--'		{class="ParticleEffect", library="FOUND_GUINEAPIG:objects", start=true, rotation=180},
		--'	},
		--'})
		--'tmp:animate({ {delay=4000}, {remove=true} })

		self:playSample("SOUND_MOUSE_HIT:sound")

		local pos = {x=self.left + self.width/2, y=self.top}
		level:handleScore(self.scoreWhenFound, pos.x, pos.y, false, 0)
		effects.createDefaultFloater(level.floaterLayer, string.format(ghf.getText("MOUSE_FOUND"), self.scoreWhenFound), pos.x, pos.y, 0)

		if (level.BM_mouseScore) then level:BM_mouseScore(self.scoreWhenFound) end
	end
	return true
end

function Mouse:doShow()
	self:pickNewShowDelay()
	self:addTask({class="SetTask", visible=true, showing=true})
	self:addTask({class="PlaySoundTask", sound="MOUSE_SQUEAK:sound"})
	self:addTask({class="PlayAnimationTask", animation=self.moveType, cycles=1, frameTime=100, whenFinished="stay", wait=true})
	self:addTask({class="Task", duration=self.showTime})
	self:addTask({class="PlayAnimationTask", animation=self.moveType, cycles=1, frameTime=100, whenFinished="stay", wait=true, reversed=true})
	self:addTask({class="CallTask", func=function() self:hideMouse() end})
end

function Mouse:hideMouse()
	self.showing = false
	self.visible = false
end

function Mouse:pickNewShowDelay()
	self.showDelay = math.Random(self.minShowDelay, self.maxShowDelay)
end

function Mouse:onTick(time)
	self:tick(time)
	if (self.clickable and not self.showing and self.showDelay > 0 and level.needsToAddLevelTime and not level.isShiftClosed) then
		self.showDelay = self.showDelay - time
		if (self.showDelay <= 0) then
			self:doShow()
		end
	end
end
