--' ************************************ Match 3 Easter Egg ************************************ '--
Match3Egg = deriveLuaClass("Match3Egg", "DelDialog")

dialogs = dialogs or {}
dialogs.match3_egg = {
	class = "Match3Egg", background = "background:easter", autoCenter = true,
	components = {
		{class="Sprite", x=22, y=298, name="bar", image="bar:easter"},
		{class="Label", x=700, y=731, name="moves_left", anchor="top"},
		{class="Button", x=512, y=731, name="back", image="BUTTON_BACK:default", anchor="top", setup=setups.btn},
	}
}

function Match3Egg.initSource(obj)
	if (isString(obj)) then
		obj = level:getChild(obj)
	end
	if (isTable(obj)) then
		obj.easter_onClick = obj.easter_onClick or obj.onClick
		if (not obj.easter_onClick or obj.easter_onClick == Object.onClick) then
			obj.easter_onClick = function() end
		end
		obj.clickable = true
		obj.doHighlight = false
		obj.onClick = function()
			obj.numEasterClicks = (obj.numEasterClicks or 0) + 1
			if (obj.numEasterClicks >= 4) then
				local dlg = scene:createDialog("match3_egg")
				scene:openDialog(dlg)
				obj.numEasterClicks = 0

				if (player.trophyManager and not player.trophyManager:isAwarded(8)) then
					player.trophyManager:awardTrophy(8, true)
				end
			else
				return obj:easter_onClick()
			end
			return true
		end
	end
end

function Match3Egg:init(desc)
	Match3Egg.superInit(self, desc)
end

function Match3Egg:createHeaderAnimation(delay, type)
	self:animate({delay=delay},{call=function()
		if (type == 1) then
			local head1 = scene:newChild({class="Label", font="FONT_DIALOG_HEADER", textId="MATCH3_WELCOME", anchor="center", x=1024+200, y=200, scale=1.3, roundPos=false})
			head1:animate(
				{delay=0}, {x=512, duration=400, style="easeOut"},
				{delay=2000}, {x=-200, duration=400, style="easeIn"},
				{remove=true})
		end
		local head2 = scene:newChild({class="Label", font="FONT_DIALOG_HEADER:default", scale=0.75, skewX=-0.3, color0=0x8fff8f, textId="MATCH3_TITLE", anchor="center", x=1024+200, y=240, scale=1.3, roundPos=false})
		head2:animate(
			{delay=200}, {x=512, duration=400, style="easeOut"},
			{delay=2000}, {x=-200, duration=400, style="easeIn"},
			{remove=true})

		local head3 = scene:newChild({class="Label", font="FONT_DIALOG_HEADER", textId="MATCH3_MEMORY", anchor="center", x=1024+200, y=270, scale=1.3, roundPos=false})
		head3:animate(
			{delay=400}, {x=512, duration=400, style="easeOut"},
			{delay=2000}, {x=-200, duration=400, style="easeIn"},
			{remove=true})

		if (type == 2) then

			--' TODO: give a decoration score of:
			--'local decoMoney = 10 * (self.level - 1)
			
			local solved = scene:newChild({class="Label", font="FONT_DIALOG_HEADER", textId="MATCH3_TIME_UP", anchor="center", x=512, y=220, scale=0, roundPos=false})
			solved:animate({delay=1000},{scale=1.8, duration=300, dy=-30, style="easeIn"},{delay=1800},{alpha=0, duration=1000},{remove=true})
			self:animate({delay=2400},{call=function() self:close() end})
			scene:animate(
				{delay=200},
				{particle="DAISIES:particles", emitter="expert_reached", ex=240, ey=220},
				{delay=200},
				{particle="DAISIES:particles", emitter="expert_reached", ex=784, ey=220},
				{delay=200},
				{particle="DAISIES:particles", emitter="expert_reached", ex=512, ey=560},
				{delay=1000},
				{particle="DAISIES:particles", emitter="expert_reached", ex=240, ey=220},
				{delay=200},
				{particle="DAISIES:particles", emitter="expert_reached", ex=784, ey=220},
				{delay=200},
				{particle="DAISIES:particles", emitter="expert_reached", ex=512, ey=560}
			)
			scene:animate(
				{delay=2400},
				{call=function() level:handleScore(1, 240, 220, false, 0) end},
				{delay=200},
				{call=function() level:handleScore(1, 784, 220, false, 0) end},
				{delay=200},
				{call=function() level:handleScore(1, 512, 560, false, 0) end},
				{delay=200},
				{call=function() level:handleScore(1, 240, 220, false, 0) end},
				{delay=200},
				{call=function() level:handleScore(1, 784, 220, false, 0) end}
			)
		end
	end})
end

function Match3Egg:getPos(gx, gy)
	return {
		x=self.gStart.x + (gx-1)*self.gSpace.x,
		y=self.gStart.y + (gy-1)*self.gSpace.y}
end

function Match3Egg:toGrid(sx, sy)
	return {
		x=(sx - self.gStart.x) / self.gSpace.x + 1,
		y=(sx - self.gStart.y) / self.gSpace.y + 1}
end

function Match3Egg:onShow()
	if (level and level.incPaused) then level:incPaused() end

	self.gStart = {x=187,y=175}
	self.gSpace = {x=130,y=105}
	self.startSpeed = 0.3
	self.accel = 0.002
	self.numX = 6
	self.numY = 5
	self.swapBackDelay = 500
	self.room = (player and player.room) or -1
	if (self.room < 1 or self.room > 5) then self.room = math.Random(5) end

	--' 200, 500, 800, 1100
	self.timeForMatch = 200
	self.timePerMatchSize = 300

	--' 600, 1200
	self.timeForMultiple = 600
	self.timePerMultipleSize = 600

	--' 600, 1200, 1800, 2400
	self.timeForCombo = 300
	self.timePerComboSize = 300

	self.timeForSquareFlip = 1000

	self.durationDecPerLevel = 500

	self.duration = (11 + 30*self.room) * 1000
	self.level = 1

	self.numPicks = 5
	--'if (self.room >= 3) then self.numPicks = 5 end

	self.sets = {}
	local suitcases = table.push_back(self.sets, {})
	for i=1,14 do
		table.push_back(suitcases, "suitcase_"..i.."_walk:room2_icons")
	end
	--'local event_icons = table.push_back(self.sets, {})
	--'for i=1,5 do
	--'	table.push_back(event_icons, "event_icon"..i..":room"..self.room.."_icons")
	--'end

	self:pickASet()

	self.items = {}
	for x=1,self.numX do
		table.push_back(self.items, {})
		for y=1,self.numY do
			table.push_back(self.items[x], {})
		end
	end

	self.time = 0
	self.score = 0
	self.startedGame = false
	self.closing = false
	self.dragging = false
	self.comboCount = 0

	self.squaresLayer = self:addChild({class="GameNode"})
	self.selectStar = self:addChild({class="Sprite", image="new_unlock_star:gamescene",
		frameTime=70, visible=false, blendMode="additive", anchor="center", alpha=0.9})
	self.itemsLayer = self:addChild({class="GameNode"})
	self.movesLeft = self:getChild("moves_left")

	self.squares = {}
	local newItems = self:createNewItems(true)
	for _,item in ipairs(newItems) do
		self.squares[item.x] = self.squares[item.x] or {}
		self.squares[item.x][item.y] = self.squaresLayer:addChild(
			{class="Sprite", image="square:easter", x=item.s.x, y=item.s.y, anchor="center"})
		item.s.y = item.s.y - 300
		item.s.alpha = 0
		item.s:animate({alpha=1, duration=1000})
	end
	self:createHeaderAnimation(0, 1)
	self.startedGame = true

	self:handleMatchesAndCollapse()
end

function Match3Egg:pickASet()
	if (#self.sets == 1) then
		self.setPick = 1
	else
		local prevPick = self.setPick
		repeat
			self.setPick = math.Random(#self.sets)
		until (prevPick ~= self.setPick)
	end

	local toPickFrom = self.sets[self.setPick]
	assert(#toPickFrom >= self.numPicks)
	self.picks = {}
	while (#self.picks < self.numPicks) do
		local picked = toPickFrom[math.Random(#toPickFrom)]
		table.insert_if_unique(self.picks, picked)
	end
end

function Match3Egg:forItems(itemFunc, rowFuncPre, rowFuncPost)
	for x=1,self.numX do
		if (rowFuncPre) then
			local r = rowFuncPre(self.items[x], x, 0)
			if (r == true) then
				return x, 0, self.items[x]
			elseif (r) then
				return r
			end
		end
		for y=1,self.numY do
			local r = itemFunc(self.items[x][y], x, y)
			if (r == true) then
				return x, y, self.items[x][y]
			elseif (r) then
				return r
			end
			table.push_back(self.items[x], item)
		end
		if (rowFuncPost) then
			local r = rowFuncPost(self.items[x], x, -1)
			if (r == true) then
				return x, -1, self.items[x]
			elseif (r) then
				return r
			end
		end
	end
end

function Match3Egg:createNewItems(forbidMatches)
	local newItems = {}
	self:forItems(
		function(item, x, y)
			if (not item.c) then
				item = {x=x, y=y}
				self.items[x][y] = item
				if (forbidMatches) then
					local tries = 1000
					repeat
						item.c = math.Random(self.numPicks)
						--tries = tries - 1
					until (tries == 0 or not self:getBiggestMatch())
				else
					item.c = math.Random(self.numPicks)
				end
				self:setSpriteFor(item)
				table.push_back(newItems, item)
			end
		end
	)
	return newItems
end

function Match3Egg:setSpriteFor(item)
	if (item.c) then
		if (not item.s) then
			local pos = self:getPos(item.x, item.y)
			item.s = self.itemsLayer:addChild({class="Sprite", x=pos.x, y=pos.y})
			item.s.image = self.picks[item.c]
			item.s.anchor = "center"
		end
	end
end

function Match3Egg:onMouseLeftDown(x, y)
	if (self.inputBlocked or not self.startedGame or self.closing) then
		return
	end

	self:checkPossibleSwap(x, y, true)
	self.dragging = self.selected ~= nil
end

function Match3Egg:onMouseMoved(x, y)
	if (self.inputBlocked or not self.startedGame or self.closing) then
		return
	end

	if (self.dragging and self.selected) then
		self:checkPossibleSwap(x, y)
	end
end

function Match3Egg:onMouseLeftUp(x, y)
	if (self.inputBlocked or not self.startedGame or self.closing) then
		return
	end

	self.dragging = false
end

function Match3Egg:checkPossibleSwap(x, y, click, checkOnlyItem)
	local clicked
	self:forItems(function(item, gx, gy)
		if (item.s and item.s:isInside(x, y)) then
			clicked = item
			return true
		end
		if (not checkOnlyItem and self.squares[gx][gy]:isInside(x, y)) then
			clicked = item
			return true
		end
	end)

	if (clicked and not clicked.busy) then
		local selected = self.selected
		if (clicked == selected) then
			--'selected.s.color = "white"
			if (click) then
				self.selected = nil
			end
		else
			local alignedSwap = false
			if (selected) then
				if (selected.x == clicked.x) then
					if (selected.y == clicked.y-1 or
						selected.y == clicked.y+1)
					then
						alignedSwap = true
					end
				elseif (selected.y == clicked.y) then
					if (selected.x == clicked.x-1 or
						selected.x == clicked.x+1)
					then
						alignedSwap = true
					end
				end
			end
			if (alignedSwap) then
				self:startSwap(selected, clicked)
				self.selected = nil
				self.comboCount = 0
			else
				if (selected) then
					--'selected.s.color = "white"
				end
				self.selected = clicked
				--'clicked.s.color = "red"
			end
		end
	
		self.selectStar.visible = false
		self:updateSelection()
	end
end

function Match3Egg:updateSelection()
	self.selectStar.visible = false
	if (self.selected and self.selected.s) then
		self.selectStar.visible = true
		self.selectStar.location = self.selected.s.location
	end
end

function Match3Egg:startSwap(selected, clicked)
	self.dragging = false
	--'selected.s.color = "white"
	self:swapItems(selected, clicked)
	clicked.busy = true
	selected.busy = true
	clicked.partner = selected
	selected.partner = clicked
	clicked.doneSwap = false
	selected.doneSwap = false
	clicked.swappingForMatch = true
	selected.swappingForMatch = true
end

function Match3Egg:onDoneSwap(item)
	if (not item.swappingForMatch) then
		item.busy = false
		self:handleMatchesAndCollapse()
		return
	end

	item.doneSwap = true
	local other = item.partner
	if (not other.doneSwap) then
		return
	end

	item.busy = false
	other.busy = false
	item.partner = nil
	other.partner = nil
	item.swappingForMatch = false
	other.swappingForMatch = false

	self:handleMatchesAndCollapse()
	
	if (not item.busy and not other.busy and
		not item.gone and not other.gone)
	then
		item.busy = true
		other.busy = true
		item.partner = nil
		other.partner = nil
		item.doneSwap = false
		other.doneSwap = false
		item.swappingForMatch = false
		other.swappingForMatch = false
		self:animate(
			{delay=self.swapBackDelay},
			{call=function() self:swapItems(item, other) end}
		)
		item.s:animate({blinkColor={startColor={1,1,1},endColor={0,1,0,0},fadeIn=100,fadeOut=100,loops=3}})
		other.s:animate({blinkColor={startColor={1,1,1},endColor={0,1,0,0},fadeIn=100,fadeOut=100,loops=3}})
	end
end

function Match3Egg:swapItems(i1, i2)
	i1.x, i1.y, i2.x, i2.y = i2.x, i2.y, i1.x, i1.y
	self.items[i1.x][i1.y] = i1
	self.items[i2.x][i2.y] = i2
end

function Match3Egg:collapseGrid()
	local changed
	repeat
		changed = false
		self:forItems(
			function(item, x, y)
				if (y < self.numY and item.c) then
					local other = self.items[x][y+1]
					if (not other.c) then
						self:swapItems(item, {x=other.x, y=other.y})
						changed = true
					end
				end
			end
		)
	until (not changed)
end

function Match3Egg:canMakeMatchWith(item)
	return
		item.c and
		not item.busy and
		not item.gone and
		self:isInRest(item)
end

function Match3Egg:getBiggestMatch(item)
	local biggestMatch
	self:forItems(function(it)
		if (self:canMakeMatchWith(it)) then
			local matchingItemsX = {it}
			local matchingItemsY = {it}
			for x=1,self.numX do
				if (it.x - x < 1) then break end
				local test = self.items[it.x - x][it.y]
				if (test.c ~= it.c or not self:canMakeMatchWith(test)) then break end
				table.push_back(matchingItemsX, test)
			end
			for x=1,self.numX do
				if (it.x + x > self.numX) then break end
				local test = self.items[it.x + x][it.y]
				if (test.c ~= it.c or not self:canMakeMatchWith(test)) then break end
				table.push_back(matchingItemsX, test)
			end
			for y=1,self.numY do
				if (it.y - y < 1) then break end
				local test = self.items[it.x][it.y - y]
				if (test.c ~= it.c or not self:canMakeMatchWith(test)) then break end
				table.push_back(matchingItemsY, test)
			end
			for y=1,self.numY do
				if (it.y + y > self.numY) then break end
				local test = self.items[it.x][it.y + y]
				if (test.c ~= it.c or not self:canMakeMatchWith(test)) then break end
				table.push_back(matchingItemsY, test)
			end
			local numBiggest = biggestMatch and #biggestMatch or 0
			if (#matchingItemsX >= 3 and #matchingItemsY >= 3 and
				#matchingItemsX + #matchingItemsY > numBiggest)
			then
				for _,t in ipairs(matchingItemsY) do
					table.insert(matchingItemsX, t)
				end
				biggestMatch = matchingItemsX
			elseif (#matchingItemsX >= 3 and #matchingItemsX > numBiggest) then
				biggestMatch = matchingItemsX
			elseif (#matchingItemsY >= 3 and #matchingItemsY > numBiggest) then
				biggestMatch = matchingItemsY
			end
		end
	end)
	return biggestMatch
end

function Match3Egg:flip3D(obj, turnDuration, delay, onMid, onEnd)
	onEnd = onEnd or function() end
	obj:animate(
		{delay=delay},
		{scaleX=0.03, scaleY=1.2, skewY=0.18, duration=turnDuration/2},
		{scaleX=1, scaleY=1, skewY=0, duration=turnDuration/2, call=onMid},
		{call=onEnd})
end

function Match3Egg:handleMatchesAndCollapse()
	local numMatches = 0
	local matchingItems
	repeat
		matchingItems = self:getBiggestMatch(item)
		if (matchingItems) then
			local midPos = {x=0, y=0}
			for _,it in ipairs(matchingItems) do
				it.busy = true
				it.gone = true

				local turnDuration = 400
				local square = self.squares[it.x][it.y]
				if (not square.done) then
					self.time = self.time - self.timeForSquareFlip
					if (self.time < 0) then self.time = 0 end
					square.done = true
					local squareMidFunc = function() square.frame = 1 end
					self:flip3D(square, turnDuration, 0, squareMidFunc)
				end

				it.s:animate(
					{alpha=0, duration=300, target=it.s},
					{call=function()
						if (it.s) then
							it.s.obsolete = true
							it.s = nil
						end
					end}
				)
				midPos.x = midPos.x + it.s.x
				midPos.y = midPos.y + it.s.y
				self:animate(
					{delay=200},
					{call=function()
						it.c = nil
					end}
				)
			end

			local num = #matchingItems
			midPos.x = midPos.x / num
			midPos.y = midPos.y / num
			local floater = self:addChild({class="Label", font="FONT_FLOATERS:default", anchor="center", align="center",
				roundPos=false, color0="white", color1={1, 0x01/255, 0x26/255, 0x2e/255},
				text=string.format(ghf.getText("MATCH3_MATCH"), num), location=midPos,
			})
			floater:animate(
				{scale=num-1.5, duration=1000},
				{remove=true}
			)
		end

		if (matchingItems) then
			numMatches = numMatches + 1

			self.time = self.time - self.timeForMatch
			self.time = self.time - self.timePerMatchSize * (#matchingItems - 3)
		end
	until (not matchingItems)

	if (numMatches > 0) then
		self.comboCount = self.comboCount + 1
	end

	if (numMatches >= 2) then
		self.time = self.time - self.timeForMultiple
		self.time = self.time - self.timePerMultipleSize * (numMatches - 2)

		local floater = self:addChild({class="Label", font="FONT_FLOATERS:default", anchor="center", align="center",
			roundPos=false, color0="white", color1={1, 0, 1, 1},
			text=string.format(ghf.getText("MATCH3_MATCH_X"), numMatches), location={x=512,y=300},
		})
		floater:animate(
			{scale=numMatches-0.5, y=200, duration=1000},
			{remove=true}
		)
	end

	if (self.comboCount >= 2) then
		self.time = self.time - self.timeForCombo
		self.time = self.time - self.timePerComboSize * (self.comboCount - 2)

		local floater = self:addChild({class="Label", font="FONT_FLOATERS:default", anchor="center", align="center",
			roundPos=false, color0="white", color1={1, 1, 0, 1},
			text=string.format(ghf.getText("MATCH3_COMBO"), self.comboCount), location={x=512,y=500},
		})
		floater:animate(
			{scale=self.comboCount-0.5, y=400, duration=1000},
			{remove=true}
		)
	end

	if (self.time < 0) then self.time = 0 end
end

function Match3Egg:getNumItemsInRow(items, x)
	local num = 0
	for _,it in ipairs(items) do
		if (it.x == x) then num = num + 1 end
	end
	return num
end

function Match3Egg:onTick(time)
	self:tick(time)

	if (self.startedGame and not self.closing) then
		if (not self.inputBlocked) then
			self.time = self.time + time
		end
		local bar = self:child("bar")
		local frac = self.time / self.duration
		bar:setClipRect(bar.x, bar.y + frac*bar.height, bar.width, bar.height)
		if (self.time >= self.duration) then
			self.inputBlocked = true
			self.closing = true
			--' TODO: create ITEM EXPLODE animation
			self:animate(
				{delay=0},
				{call=function()
					self:createHeaderAnimation(0, 2)
				end}
			)
		else
			self:collapseGrid()
			local newItems = self:createNewItems(false)
			for _,item in ipairs(newItems) do
				item.s.y = item.s.y - self:getNumItemsInRow(newItems, item.x) * self.gSpace.y
				item.s.alpha = 0
				item.s:animate({alpha=1, duration=100})
			end
			self:forItems(function(item, x, y)
				if (item.s) then
					local curPos = item.s.location
					local targetPos = self:getPos(x, y)
					local delta = {x=targetPos.x - curPos.x, y=targetPos.y - curPos.y}
					if (delta.x ~= 0 or delta.y ~= 0) then
						item.speed = item.speed or self.startSpeed
						item.speed = item.speed * (1 + self.accel * time)
						local length = math.sqrt(delta.x*delta.x + delta.y*delta.y)
						local dist = time*item.speed
						if (length < dist) then
							item.s.x = targetPos.x
							item.s.y = targetPos.y
						else
							delta.x = delta.x / length
							delta.y = delta.y / length
							item.s.x = curPos.x + delta.x*dist
							item.s.y = curPos.y + delta.y*dist
						end

						if (self:isInRest(item)) then
							item.speed = self.startSpeed
							self:onDoneSwap(item)
						end
					end
				end
			end)
			local numSquares = 0
			for _,row in ipairs(self.squares) do
				for _,it in ipairs(row) do
					if (not it.done) then
						numSquares = numSquares + 1
					end
				end
			end
			if (numSquares == 0) then
				self.dragging = false

				self.level = self.level + 1
				self.time = 0
				self.duration = self.duration - self.durationDecPerLevel

				self:pickASet()
				local turnDuration = 400
				for _,row in ipairs(self.squares) do
					for _,it in ipairs(row) do
						it.done = false
						local squareMidFunc = function() it.frame = 0 end
						self:flip3D(it, turnDuration, 0, squareMidFunc)
					end
				end

				self:forItems(
					function(item)
						if (item.s) then
							local itemMidFunc = function() item.s.image = self.picks[item.c] end
							self:flip3D(item.s, turnDuration, 0, itemMidFunc)
						end
					end
				)

				self.inputBlocked = true
				self:animate(
					{delay=1000},
					{call=function()
						self.inputBlocked = false
					end}
				)

			else
				--'local movesLeft = self:getMovesLeft()
				--'self.movesLeft.text = string.format(ghf.getText("MATCH3_MOVES_LEFT"), movesLeft)
				--'if (movesLeft == 0) then
				--'	--' TODO: reshuffle board
				--'end
			end
		end
	end
end

--'function Match3Egg:getMovesLeft()
--'	int movesLeft = 0
--'	
--'	return movesLeft
--'end

function Match3Egg:isInRest(item)
	if (not item.s) then
		return true
	end
	local curPos = item.s.location
	local targetPos = self:getPos(item.x, item.y)
	return (targetPos.x == curPos.x and targetPos.y == curPos.y)
end

function Match3Egg:handleCommand(command, sender)
	if (command == "back") then
		self.closing = true
		self:close()
	end
end

function Match3Egg:onClose()
	self.closing = true
	if (level and level.incPaused) then
		level:decPaused()
	end
end
