--' ************************************ Ingredient Button ************************************ '--
IngredientButton = getClass("IngredientButton")

IngredientButton.__getters = IngredientButton.__getters or {}

function IngredientButton:init(desc)
	IngredientButton.superInit(self, desc)

	--' --' *** pr("["..self.name.."] Init")
	self.statusObjects = self.statusObjects or {}

	self.workAnimation = desc.workAnimation or "work"
	self.workDirection = desc.workDirection or "up"
	self.workCycles = desc.workCycles or -1
	self.workWhenFinished = desc.workWhenFinished or "default"
	self.workFrameTime = desc.workFrameTime or 100
	self.prepareVisible = self.prepareVisible ~= false
	self.prepareFrameTime = self.prepareFrameTime or -1
	self.prepareDuration = self.prepareDuration or 0
	self.decayDuration = self.decayDuration or 1000
	self.decayVisible = self.decayVisible ~= false
	self.decayFrameTime = self.decayFrameTime or -1
	self.inactiveFrameTime = self.inactiveFrameTime or 100
	self.worth = desc.worth or 1
	self.compoundPosition = self.compoundPosition or {x=self.x, y=self.y}
	self.availableBlink = self.availableBlink or {startAlpha=1,endAlpha=0,fadeIn=75,fadeOut=75,loops=4}
	self.blinkWhenAvailable = self.blinkWhenAvailable ~= false -- Default true
	self.allowRestockOverload = self.allowRestockOverload ~= false -- Default true

	if (not self.ingredientName) then
		self.ingredientName = self:getIngredientNameFromResource()
	end

	self:onDisplayStockChange()
end

function IngredientButton:onLevelInitialized()
	IngredientButton.super.onLevelInitialized(self)

	if (self.notifyObjectId) then
		 --' *** pr("["..self.name.."] Searching notify object... '"..self.notifyObjectId.."'")
		self.notifyObject = level:getSpriteExt(self.notifyObjectId)
		 --' *** pr((self.notifyObject and "found.") or "not found!")
	end
	for i=1,5 do
		local so = self["statusObject"..i]
		if (isString(so)) then
			 --' *** pr("["..self.name.."] Searching status object... '"..so.."'")
			so = level:getSpriteExt(so)
			 --' *** pr((so and "found.") or "not found!")
			if (so) then
				table.push_back(self.statusObjects, so)
			end
		end
	end
end

function IngredientButton:getProductCenter()
	return self.screenCenter
end

function IngredientButton:setIngredientAndResource(ingredientName)
	 --' *** pb("["..self.name.."] Set ingredient name: "..ingredientName)
	self.ingredientName = ingredientName
	self.baseAnimation = "button"..ingredientName
end

function IngredientButton:getIngredientNameFromResource(res)
	res = res or self.baseAnimation
	 --' *** pi("["..self.name.."] Get ingredient name from: "..res)
	for _,v in ipairs({"button#", "product#", "icon#"}) do
		if (string.starts_with(res, v)) then
			res = string.sub(res, #v)
		end
	end
	for _,v in ipairs({"_prepare", "_decay"}) do
		if (string.ends_with(res, v)) then
			res = string.sub(res, 1, #res - #v)
		end
	end
	 --' *** pd("-> "..res)
	return res
end

function IngredientButton:listPossibleIngredients()
	return {self.ingredientName or ""}
end

function IngredientButton:getIngredientNameForLogic()
	local r
	if (self.notifyObject) then
		if (self.notifyObject.notify_getIngredientNameForLogic) then
			r = self.notifyObject:notify_getIngredientNameForLogic(self)
		end
	end
	return r or self.ingredientName or ""
end

function IngredientButton:notify_getIngredientNameForLogic(ing)
	 --' *** pb("["..self.name.."] IngredientButton Notify get ingredient name for logic (from '"..ing.name.."')")
	return ing.ingredientName
end

function IngredientButton:getIngredientNameForTrayIcon()
	local r
	if (self.notifyObject) then
		if (self.notifyObject.notify_getIngredientNameForTrayIcon) then
			r = self.notifyObject:notify_getIngredientNameForTrayIcon(self)
		end
	end
	return r or self.ingredientName or ""
end

function IngredientButton:notify_getIngredientNameForTrayIcon(ing)
	-- --' *** pb("["..self.name.."] IngredientButton Notify get ingredient name for tray icon (from '"..ing.name.."')")
	return ""
end

function IngredientButton:onStartPreparing()
	 --' *** pi("["..self.name.."] Start prepare: "..ts(self.ingredientName))
	for _,v in ipairs(self.statusObjects) do
		 --' *** pe("Status object "..v.name)
		if (v.status_onStartPreparing) then
			 --' *** pr("("..v.name..")")
			local handled = v:status_onStartPreparing(self)
			if (handled ~= nil) then
				 --' *** pd("Handled")
				return
			end
		end
	end

	self:playAnimation("prepare", -1, self.prepareFrameTime)
	if (not self.prepareFrameTime or self.prepareFrameTime < 0) then
		self:matchFrameTimeTo("prepareDuration")
	end
	self.visible = self.prepareVisible

	 --' *** pd()
end

function IngredientButton:onBecomeAvailable()
	 --' *** pi()
	if (self.name ~= "") then
		 --' *** pr("["..self.name.."] Become available: "..ts(self.ingredientName))
	end
	if (self.statusObjects) then
		for _,v in ipairs(self.statusObjects) do
			if (v.status_onBecomeAvailable) then
				 --' *** pr("("..v.name..")")
				local handled = v:status_onBecomeAvailable(self)
				if (handled ~= nil) then
					 --' *** pd("Handled")
					return
				end
			end
		end
	end
	self.visible = true

	if (self.autoProcessOnBecomeAvailable) then
		--' TODO: Would prefer to run this through the normal onWorkStart; Unfortunately we have no task here
		--'self:onWorkStart()

		--' So: temp HACK!
		if (self.notifyObject) then
			self.notifyObject:animate(
				{call=function() self.notifyObject:throwCopy(self.left + self.width/2, self.top + self.height/2, level.topLayer, true) end},
				{delay=throwDuration},
				{call=function() self.notifyObject:incDisplayStock() end}
			)
			self.notifyObject:incStock()
			self.state = "inactive"
		end
	end

	self:playAnimation(self.defaultAnimation, 0, self.productFrameTime)

	if (self.blinkWhenAvailable and self.availableBlink) then
		self:animate({blink = self.availableBlink})
	end

	if (self.notifyObject and self.notifyObject.notify_onBecomeAvailable) then
		self.notifyObject:notify_onBecomeAvailable()
	end

--' Hints
	if (isString(self.ingredientName)) then
		if (self.ingredientName == "#strawberry.ready" or self.ingredientName == "#orange.ready" or self.ingredientName == "#kiwi.ready") then
--'			if (not player:mayShowHint("blenderIce") and player:mayShowHint("blenderFruitDoneIce")) then
--'				if (self.nextObject1) then
--'					self.nextObject = self.nextObject1
--'					doCompoundArrow("blenderFruitDoneIce", self)
--'				end
--'			end
--'			if (not player:mayShowHint("blenderGlass") and player:mayShowHint("blenderFruitDoneGlass")) then
--'				if (self.nextObject2) then
--'					self.nextObject = self.nextObject2
--'					doCompoundArrow("blenderFruitDoneGlass", self)
--'				end
--'			end
			
			if (self.fruit and ("#"..self.fruit) == self.ingredientName) then
				doCompoundArrow("blenderFruitDone", self)
			end
		end

		if (self.decayDelay and self.decayDelay > 0) then
			self.decayTimer = self.decayDelay*0.95
--[[
			self:animate({delay=self.decayDelay*0.95},
				{call=function()
					if (self.state == "available" and self.pendingWorkTaskCount == 0) then
						if (player:mayShowHint("PaprikaBurned") and string.find(self.ingredientName, "#paprika") and string.find(self.ingredientName, ".ready")) then
							hintManager:openHint({hintId="PaprikaBurned", target=self, subject=self})
						end
						if (player:mayShowHint("PatatasReady") and (self.ingredientName == "#calamari.ready" or self.ingredientName == "#patatas.ready")) then
							hintManager:openHint({hintId="PatatasReady", target=self, subject=self, showButton=false})
						end
						if (player:mayShowHint("PaellaReady") and string.find(self.ingredientName, "#rice")) then
							hintManager:openHint({hintId="PaellaReady", target=self, subject=self})
						end

					end
				end})
]]		
		end
	end
--' End Hints
	 --' *** pd()
end

function IngredientButton:onTick(time)
	
	self:tick(time)
	
	if (self.state == "available" and self.decayTimer and self.decayTimer > 0)  then
		self.decayTimer = self.decayTimer - time
		if (self.decayTimer <= 0 and self.pendingWorkTaskCount == 0) then
			if (player:mayShowHint("PaprikaBurned") and string.find(self.ingredientName, "#paprika") and string.find(self.ingredientName, ".ready")) then
				hintManager:openHint({hintId="PaprikaBurned", target=self, subject=self})
			end
			if (player:mayShowHint("PatatasReady") and (self.ingredientName == "#calamari.ready" or self.ingredientName == "#patatas.ready")) then
				hintManager:openHint({hintId="PatatasReady", target=self, subject=self, showButton=false})
			end
			if (player:mayShowHint("PaellaReady") and string.find(self.ingredientName, "#rice")) then
				hintManager:openHint({hintId="PaellaReady", target=self, subject=self})
			end
		end
	end
end

function IngredientButton:onDecay()
	 --' *** pi("["..self.name.."] Decays: "..ts(self.ingredientName))
	for _,v in ipairs(self.statusObjects) do
		if (v.status_onDecay) then
			 --' *** pr("("..v.name..")")
			local handled = v:status_onDecay(self)
			if (handled ~= nil) then
				 --' *** pd("Handled")
				return
			end
		end
	end

	self:playAnimation("decay", 1, self.decayFrameTime, "stay")
	if (not self.decayFrameTime or self.decayFrameTime < 0) then
		self:matchFrameTimeTo("decayDuration")
	end
	self.visible = self.decayVisible

	if (player.trophyManager and self.isOvenProduct) then
		player.gameStats:incNrProductsBurned()
	end

	if (self.notifyObject and self.notifyObject.notify_onDecay) then
		self.notifyObject:notify_onDecay()
	end

	if (string.find(self.ingredientName, "paprika")) then
		self:animate({delay=(1500/20) * 10},{call=function()
			if (string.find(self.ingredientName, "filling1")) then
				--'HINTRESTORE
				--hintManager:openHint("paprika_filling1_burned", self)
			else
				--'HINTRESTORE
				--hintManager:openHint("paprika_filling2_burned", self)
			end
		end})
	elseif (string.find(self.ingredientName, "coffee")) then
		--'HINTRESTORE
		--hintManager:openHint("coffee_spilled", self)
	end

	 --' *** pd()
end

function IngredientButton:updateStatusObjects(frac)
	for _,v in ipairs(self.statusObjects) do
		v:status_onUpdateStatusFraction(frac)
	end	
end

function IngredientButton:onDeactivate()
	 --' *** pi("["..self.name.."] Becomes deactivated: "..ts(self.ingredientName))
	for _,v in ipairs(self.statusObjects) do
		if (v.status_onDeactivate) then
			 --' *** pr("("..v.name..")")
			local handled = v:status_onDeactivate(self)
			if (handled ~= nil) then
				 --' *** pd("Handled")
				return
			end
		end
	end

	if (self.notifyObject) then
		if (self.notifyObject.notify_onDeactivate) then
			self.notifyObject:notify_onDeactivate()
		end
	end

	if (self.doInactiveAnimation) then
		self:playAnimation("INACTIVE", 0, self.inactiveFrameTime)
		self.visible = true
	end
	 --' *** pd()
end

function IngredientButton:onClick()
	 --' *** pi("["..self.name.."] On click")

--	if (string.find(self.ingredientName, "#paprika")) then
--		player:setNeverShowHint("PaprikaReady")
--	elseif (string.find(self.ingredientName, "#vanillaice") or string.find(self.ingredientName, "#glass")) then
--		player:setNeverShowHint("glass")
--	end

	if (self.notifyObject) then
		 --' *** pr("-> notifyObject")
		if (self.notifyObject.notify_onClick) then
			 --' *** pr("("..self.notifyObject.name..")")
			local handled = self.notifyObject:notify_onClick(self)
			if (handled ~= nil) then
				 --' *** pd()
				self:handleClickEffect(true)
				return true
			end
		end
	end
	 --' *** pd()
	local res = IngredientButton.super.onClick(self)
	self:handleClickEffect(res)
	return true
end

function IngredientButton:handleClickEffect(correct)
	if (iOS) then
		local color = 0xaa3300
		if (correct) then
			color = 0x33aa00
		end		
		self:animate({blinkColor={startColor="white", endColor=color, fadeIn=130, fadeOut=130, loops=2}})
	end
end

function IngredientButton:allowWork(actor)
	 --' *** pi("["..self.name.."] Allow work?")
	if (self.notifyObject) then
		 --' *** pr("-> notifyObject")
		if (self.notifyObject.notify_allowWork) then
			 --' *** pr("("..self.notifyObject.name..")")
			local allow = self.notifyObject:notify_allowWork(self, actor)
			if (allow ~= nil) then
				 --' *** pd()
				return allow
			end
		end
	end

	if (self.deactivateOnWorkFinish and self.pendingWorkTaskCount > 0) then
		 --' *** pd("Cannot click twice on a single-fire button")
		return false
	end

	 --' *** pd("-> true")
	return true
end

function IngredientButton:allowIngredientWork(actor)
	 --' *** pi("["..self.name.."] IngredientButton allowIngredientWork")
	if (not self.ingredientName) then
		 --' *** pd("No ingredient name!")
		return false;
	end
	if (not tray:makesValidProductOrStart(self.ingredientName)) then
		 --' *** pd("Not a valid product or start: "..self.ingredientName)
		return false
	end
	 --' *** pd("-> true")
	return true
end

function IngredientButton:notify_allowWork(ing, actor)
	return true
end

function IngredientButton:onWorkStart(task)
	 --' *** pi("["..self.name.."] IngredientButton onWorkStart")
	IngredientButton.super.onWorkStart(self, task)

	self:stopLoopSample()
	if (not self:checkStock()) then
		 --' *** pd("-> no stock")
		self:playSample("SOUND_NO_STOCK:sound")
		return false --' Do not start
	end

	if (not self:checkTrayAvailable(task)) then
		 --' *** pd("-> tray full")
		if (not player:mayShowHint("TrayFull")) then
			tray.timesClickedWithFullTray = (tray.timesClickedWithFullTray or 0) + 1
			if (tray.timesClickedWithFullTray > 3) then
				player:removeNeverShowHint("TrayFull")
			end
		end
		if (player:mayShowHint("TrayFull")) then
			--'HINTRESTORE
			--hintManager:openHint({"TrayFull", tray})
			hintManager:openHint({hintId="TrayFull"})
			tray.timesClickedWithFullTray = 0
		end
		return false --' Do not start
	else
		tray.timesClickedWithFullTray = 0
	end

	if (self.notifyObject) then
		 --' *** pr("-> notifyObject")
		if (self.notifyObject.notify_onWorkStart) then
			local success = self.notifyObject:notify_onWorkStart(self, task)
			if (success ~= nil) then
				 --' *** pd("success = "..ts(success))
				return success
			end
		end
		 --' *** pr("-> unhandled...")
	end

	if (self.state ~= "available") then
		 --' *** pd("-> not available yet")
		return false --' Do not start
	end

	if (not self:allowIngredientWork()) then
		 --' *** pd("-> !allow ingredient work")
		return false --' Do not start
	end

	self:defaultOnWorkStart(task)
	tray:startIngredient(task.duration, self.compoundPosition, self.compoundTipType, false)
	 --' *** pd("started ingredient '"..ts(self.ingredientName).."'")
	return true
end

function IngredientButton:checkTrayAvailable(task)
	if (self.notifyObject) then
		if (self.notifyObject.notify_checkTrayAvailable) then
			local available = self.notifyObject:notify_checkTrayAvailable(self, task)
			if (available ~= nil) then return available end
		end
	end

	return not tray.full or not tray:makesValidProduct(self.ingredientName)
end

function IngredientButton:defaultOnWorkStart(task)
	for _,v in ipairs(self.statusObjects) do
		if (v.status_onWorkStart) then
			v:status_onWorkStart()
		end
	end

	 --' *** pi("["..self.name.."] Default work start: "..ts(self.ingredientName))
	task.duration = self:getWorkDurationWith(task.actor)
	 --' *** pr("duration: "..tostring(task.duration))
	if (task.duration > 0) then
		 --' *** pr("-> playing work anim '"..ts(self.workAnimation).."'")
		assert(task.actor)
		if (task.actor) then
			task.actor.direction = self.workDirection
			task.actor:playAnimation(self.workAnimation, self.workCycles, self.workFrameTime, self.workWhenFinished)
			if (self.workFrameTime and self.workFrameTime < 0) then
				task.actor:matchFrameTimeTo(task.duration)
			end
		end
		if (self.workSound and self.workSound ~= "") then
			self:playSample(self.workSound)
		elseif (self.workLoop and self.workLoop ~= "") then
			self:loopSample(self.workLoop)
		end
	end
	 --' *** pd()
end

function IngredientButton:notify_onWorkStart(ing, task)
	if (ing.state ~= "available") then
		 --' *** pd("-> not available yet")
		return false --' Do not start
	end

	if (not ing:allowIngredientWork()) then
		return false --' Do not start
	end

	 --' *** pi("["..self.name.."] IngredientButton notify_allowWork (from '"..ing.name.."')"..
	 --' *** 	" allowRestockOverload: "..ts(self.allowRestockOverload).." usesStock: "..ts(self.usesStock)..
	 --' *** 	" stock: "..ts(self.stock).." maxStock: "..ts(self.maxStock))
	if (self.usesStock and not self.allowRestockOverload and
		self.stock >= self.maxStock) then
		 --' *** pd("-> No filling beyond the maximum stock")
		return false
	end
	 --' *** pd()

	 --' *** pb("["..self.name.."] IngredientButton notify_onWorkStart (from '"..ing.name.."')")
	ing:defaultOnWorkStart(task)
	return true
end

function IngredientButton:onWorkUpdate(task, time)
	if (self.notifyObject) then
		if (self.notifyObject.notify_onWorkUpdate) then
			return self.notifyObject:notify_onWorkUpdate(self, task, time)
		end
	end
end

function IngredientButton:onWorkFinish(task)
	 --' *** pi("["..self.name.."] Work finish")
	IngredientButton.super.onWorkFinish(self, task)
	self:stopLoopSample()
	if (self.notifyObject) then
		 --' *** pr("-> notifyObject")
		if (self.notifyObject.notify_onWorkFinish) then
			local handled = self.notifyObject:notify_onWorkFinish(self, task)
			if (handled ~= nil) then
				 --' *** pd("Handled!")
				return
			end
		end
		 --' *** pr("-> unhandled...")
	end

	local success = tray:commitIngredient(self:getProductCenter(), self)
	self:defaultOnWorkFinish(task, success)

	 --' *** pd("success = "..ts(success))
end

function IngredientButton:defaultOnWorkFinish(task, success)
	for _,v in ipairs(self.statusObjects) do
		if (v.status_onWorkFinish) then
			v:status_onWorkFinish()
		end
	end

	 --' *** pb("["..self.name.."] Default work finish: "..ts(self.ingredientName).." success = "..tostring(success))
	self:stopLoopSample()
	self:characterOnWorkFinish(task, success)
end

function IngredientButton:characterOnWorkFinish(task, success)
	task.actor:playDefaultAnimation()
	task.actor.direction = "down"
end

function IngredientButton:notify_onWorkFinish(ing, task)
	 --' *** pb("["..self.name.."] Notify work finish: (from '"..ing.name.."')")
end

function IngredientButton:onCommit(productName, x, y, lastelem)
	 --' *** pi("["..self.name.."] On commit: "..productName)
	if (self.notifyObject) then
		 --' *** pr("-> notifyObject")
		 --' *** pb("["..self.name.."] Is " .. ((lastelem and "") or "not ") .. "last element")
		if (lastelem and self.notifyObject.notify_onCommit) then
			local success = self.notifyObject:notify_onCommit(self, productName, x, y)
			if (success ~= nil) then
				 --' *** pd("success = "..ts(success))
				return success
			end
		end
		 --' *** pr("-> unhandled...")
	end

	if (level:isValidProduct(productName)) then
		 --' *** pr("-> valid product!")
		self:defaultOnCommit(productName, x, y)
	end
	 --' *** pd()
end

function IngredientButton:defaultOnCommit(productName, x, y)
	 --' *** pi("["..self.name.."] Default commit: "..productName)
	if (self.deactivateOnWorkFinish) then
		 --' *** pr("-> deactivating!")
		self.state = "inactive"
	end
	if (self.usesStock) then
		 --' *** pr("-> decreased stock")
		self:decStock(true)
	end
	 --' *** pd()
end

function IngredientButton:notify_onCommit(ing, productName, x, y)
	 --' *** pi("["..self.name.."] Notify on commit: "..productName.." (from '"..ing.name.."')")
	local c = self.screenCenter
	local mod = ing:throwCopy(c.x, c.y, level.topLayer)
	self:incStock(ing.worth)
	self:animateIncDisplayStock(ing.worth, mod)
	ing:defaultOnCommit(productName, x, y)	
--'	if (player.trophyManager) then
--'		if (self.usesStock and self.stock == self.maxStock and player.room == 2 and player.shift >= 6) then
--'			player.trophyManager:checkTrophyGoalReached()
--'		end
--'	end
	 --' *** pd()
	return true
end

function IngredientButton:onDisplayStockChange()
	for _,v in ipairs(self.statusObjects) do
		if (v.status_onDisplayStockChange) then
			local handled = v:status_onDisplayStockChange(self)
			if (handled) then return end
		end
	end
	
	IngredientButton.super.onDisplayStockChange(self)
end

function IngredientButton:onRemoveProductFromTray(product)
	 --' *** pi("["..self.name.."] IngredientButton: onRemoveProductFromTray "..ts(product.source.name)) --' Should be same
	local handler = self.removeTrayHandler
	if (isString(handler)) then
		handler = level:getSpriteExt(handler)
	end
	local handled = false
	if (handler and handler.handleRemoveProductFromTray) then
		handled = handler:handleRemoveProductFromTray(product, self)
	end
	 --' *** pd((handled and "-> handled") or "-> NOT handled")
	return handled, false
end

function IngredientButton:handleRemoveProductFromTray(product, source)
	 --' *** pi("["..self.name.."] handleRemoveProductFromTray ")
	tray:removeProductsToTarget({product}, self)
	if (self.usesStock) then
		self:incStock(product.source.worth, true)
		 --' *** pr("-> increased stock by "..product.source.worth)
	end
	 --' *** pd()
	return true
end

function IngredientButton:onStockChange()

	if (not self:checkStock()) then
	
		--' stock reached 0
		if (player:mayShowHint("OutOfStock1") and string.find(self.name, "paprika")) then
			local obj = level:getSpriteExt("paprika_1")
			if (obj) then
				hintManager:placeArrow({hintId="OutOfStock1", x=obj.screenX + obj.hintArrowPosition.x, y=obj.screenY + obj.hintArrowPosition.x, parent=level.dragLayer})
				switchHintArrowClick(obj, "OutOfStock1")
				switchHintArrowClick(level:getSpriteExt("paprika_2"), "OutOfStock1")
				switchHintArrowClick(level:getSpriteExt("paprika_3"), "OutOfStock1")
			end
		elseif (player:mayShowHint("OutOfStock2") and (string.find(self.name, "jamon") or string.find(self.name, "sausage"))) then
			local obj = nil
			if (string.find(self.name, "jamon")) then
				obj = level:getSpriteExt("jamonshelf")
			elseif(string.find(self.name, "sausage")) then
				obj = level:getSpriteExt("sausageshelf")
			end
			if (obj) then
				hintManager:placeArrow({hintId="OutOfStock2" , x=obj.x + obj.width/2, y=obj.y + obj.height/2, parent=level.dragLayer})
				switchHintArrowClick(obj, "OutOfStock2")
			end
		elseif (player:mayShowHint("OutOfStock3") and string.find(self.name, "magazine")) then
			local obj = level:getSpriteExt("magazine_stock")
			if (obj) then
				hintManager:placeArrow({hintId="OutOfStock3" , x=obj.screenCenter.x, y=obj.screenCenter.y - obj.height/2, parent=level.dragLayer})
				switchHintArrowClick(obj, "OutOfStock3")
			end
		end
	else
		--' stock increased 
		if (string.find(self.name, "paprika")) then
			hintManager:removeArrows("OutOfStock1")
		elseif (string.find(self.name, "jamon") or string.find(self.name, "sausage")) then
			hintManager:removeArrows("OutOfStock2")
		elseif (string.find(self.name, "magazine")) then
			hintManager:removeArrows("OutOfStock3")
		end		
	end
end
