--' ************************************ Grow ************************************ '--
Grow = deriveLuaClass("Grow", "IngredientButton")

function Grow:init(desc)
	Grow.superInit(self, desc)
	self.startGrowScale = self.startGrowScale or 0
	self.endGrowScaleMin = self.endGrowScaleMin or 1
	self.endGrowScaleMax = self.endGrowScaleMax or 1
	self.endGrowScale = self.endGrowScale or 1
	self.decayGrowScale = self.decayGrowScale or -1
	self.scaleStartTime = self.scaleStartTime or 0
	self.growDuration = self.growDuration or 0
end

function Grow:onStartPreparing()
	Grow.super.onStartPreparing(self)
	self.scale = self.startGrowScale
	if (self.popOnPrepare and self.startGrowScale > 0) then
		self:doPop(self.startGrowScale)
	end
	self.endGrowScale = math.Random(self.endGrowScaleMin, self.endGrowScaleMax)
end

function Grow:onBecomeAvailable()
	Grow.super.onBecomeAvailable(self)
	self.scaleStartTime = 0
	if (self.popOnAvailable) then
		self:doPop(self.endGrowScale)
	else
		self.scale = self.endGrowScale
	end
--'	player.gameStats:incGrowProducts()
end

function Grow:onDecay()
	Grow.super.onDecay(self)
	if (self.decayGrowScale >= 0) then
		self:animate({scale=self.decayGrowScale, duration=self.frameCount * self.currentFrameTime})
	end
end

function Grow:onClick()
	Grow.super.onClick(self)
	player.gameStats:incBellPepperPicked();
	if (player.trophyManager) then
		player.trophyManager:checkTrophyGoalReached(24)
	end
end

function Grow:onTick(time)
	self:tick(time)
	if (self.state == "prepare") then
		if (self.popping) then
			self.scaleStartTime = self.timer.time
		else
			self.scale = math.lerp(
				math.inv_lerp(self.timer.time, self.scaleStartTime, self.timer.duration),
				self.startGrowScale, self.endGrowScale)
			if (self.flipGrowth) then self.scaleX = -self.scaleX end
		end
	end
end

function Grow:doPop(sc)
	self.popping = true
	local scX = (self.flipGrowth and -sc) or sc
	self:animate({
		{ scaleX=scX*1.10, scaleY=sc*0.90, duration=100},
		{ scaleX=scX*0.85, scaleY=sc*1.15, duration=100},
		{ scaleX=scX*1.20, scaleY=sc*0.80, duration=100},
		{ scaleX=scX*0.80, scaleY=sc*1.20, duration=100},
		{ scaleX=scX*1.15, scaleY=sc*0.85, duration=100},
		{ scaleX=scX*0.90, scaleY=sc*1.10, duration=100},
		{ scaleX=scX, scaleY=sc, duration=100},
		{ call=function() self.popping = false end },
	})
end
