--' ************************************ Firefly ************************************ '--
Firefly = deriveLuaClass("Firefly", "Object")

function Firefly:init(desc)
	Firefly.superInit(self, desc)

	self.baseAnimation = ""

	local flyDesc = table.copy(desc)
	flyDesc.class = "Object"
	flyDesc.name = (flyDesc.name or "").."_fly"
	flyDesc.x = 0
	flyDesc.y = 0
	flyDesc.visible = true
	self.fly = self:newChild(flyDesc)

	self.minRadius = self.minRadius or 10
	self.maxRadius = self.maxRadius or 50
	self.minDuration = self.minDuration or 600
	self.maxDuration = self.maxDuration or 3000

	local startAmpX = math.Random(self.minRadius, self.maxRadius)
	local startAmpY = math.Random(self.minRadius, self.maxRadius)
	self.fly:doEvery(0, function()
		local duration = math.Random(self.minDuration, self.maxDuration)
		local endAmp = math.Random(self.minRadius, self.maxRadius)
		self.fly:animate({
			duration=duration,
			wave={x=0, amplitudeStart=startAmpX, amplitudeEnd=endAmp},
		})
		startAmpX = endAmp
		return duration
	end)
	self.fly:doEvery(0, function()
		local duration = math.Random(self.minDuration, self.maxDuration)
		local endAmp = math.Random(self.minRadius, self.maxRadius)
		self.fly:animate({
			duration=duration,
			wave={y=0, amplitudeStart=startAmpY, amplitudeEnd=endAmp},
		})
		startAmpY = endAmp
		return duration
	end)
	local r = self.fly.width/2 + self.maxRadius
	function self:isInside(x, y)
		local p = self.location
		return
			x >= p.x - r and
			x <= p.x + r and
			y >= p.y - r and
			y <= p.y + r
	end
end
