--' ************************************ TriggerObject ************************************ '--
Door = deriveLuaClass("Door", "Object")

function Door:init(desc)
	Door.superInit(self, desc)

--'	self.openSoundId = desc.openSoundId or ""
--'	self.closeSoundId = desc.closeSoundId or ""

	self.slideOffsetX = desc.slideOffsetX or 0
	self.closeAfterLeaveDuration = desc.closeAfterLeaveDuration or 1000
	self.openCloseDuration = desc.openCloseDuration or 800
	if (not self.ease) then
		self.ease = math.linear
	elseif (not isCallable(self.ease)) then
		local options = {easeIn=math.jcurve, easeOut=math.rcurve, easeInOut=math.scurve}
		self.ease = options[self.ease] or math.linear
	end
	
	self.state = "door_closed"
	self.needToCloseTimer = 0
	self.openCloseTimer = self.openCloseDuration
end

function Door:onLevelInitialized()
	Door.super.onLevelInitialized(self)
	
	self.originalX = self.x
	self.startX = self.x
end

function Door:onTick(time)
	self:tick(time)
	
	if (self.state == "door_closing") then
		if (self.needToCloseTimer > 0) then
			self.needToCloseTimer = self.needToCloseTimer - time
		end
		if (self.needToCloseTimer <= 0) then
			self.state = "door_closed"
			self.openCloseTimer = 0
			self.startX = self.x
			if (self.closeSoundId) then
				self:playSample(self.closeSoundId)
			end
		end
	end		

	if (self.state == "door_open") then
		--' Open the door
		if (self.openCloseTimer < self.openCloseDuration) then	
			self.openCloseTimer = math.min(self.openCloseDuration, self.openCloseTimer + time)		
			local f = self.ease(self.openCloseTimer / self.openCloseDuration)
			self.x = math.lerp(f, self.startX, self.originalX + self.slideOffsetX)
		end			
	elseif (self.state == "door_closed") then
		--' Close the door
		if (self.openCloseTimer < self.openCloseDuration) then	
			self.openCloseTimer = math.min(self.openCloseDuration, self.openCloseTimer + time)		
			local f = self.ease(self.openCloseTimer / self.openCloseDuration)
			self.x = math.lerp(f, self.startX, self.originalX)
		end
	end
end

function Door:handleTrigger(trigger, meta)
	Door.super.handleTrigger(self, trigger, meta)
	if (self.active == false) then return end

	if (trigger == "door_onEnter") then
		if (self.state ~= "door_open") then			
			self.state = "door_open"
			self.needToCloseTimer = 0
			self.openCloseTimer = 0 --' calculate 
			self.startX = self.x
			if (self.openSoundId) then
				self:playSample(self.openSoundId)
			end
		end
	elseif (trigger == "door_onEmpty") then
		if (self.state == "door_open") then
			self.state = "door_closing"
			self.needToCloseTimer = self.closeAfterLeaveDuration
		end
	end
end
