--' ************************************ Cooker ************************************ '--
Cooker = deriveLuaClass("Cooker", "StatusObject")

function Cooker:init(desc)
	Cooker.superInit(self, desc)
	self.productAppend = self.productAppend or "ready"
end

function Cooker:onLevelInitialized()
	Cooker.super.onLevelInitialized(self)

	self.buttons = {}
	for i=1,20 do
		local button = self["button"..i]
		if (button) then
			button = level:getSpriteExt(button)
			if (button) then
				button.state = "inactive"
				table.push_back(self.buttons, button)
			end
		end
	end

	if (not self.buttonPositions or #self.buttonPositions < #self.buttons) then
		self.buttonPositions = self.buttonPositions or {}
		for _,v in ipairs(self.buttons) do
			table.push_back(self.buttonPositions, v.location)
		end
	end

	if (isString(self.overlayObject)) then
		self.overlayObject = level:getSpriteExt(self.overlayObject)
	end
end

function Cooker:getAvailableButton()
	for k,v in ipairs(self.buttons) do
		if (v.state == "inactive" and not v.isQueued) then
			return k, v
		end
	end
end

function Cooker:notify_onWorkStart(ing, task)
	local newProductName = self:getNewProductName(ing.ingredientName)
	 --' *** pi(" -> cooks "..newProductName)
	if (not tray:makesValidProductOrStart(newProductName)) then
		 --' *** pd("Not my problem")
		return nil --' Let ing handle it itself
	end

	local k,v = self:getAvailableButton()
	if (not isTable(v)) then
		 --' *** pr("Spot available? "..ts(isTable(v)))
		if (level:isValidProductOrStart(ing.ingredientName)) then
			tray:clearCurrentIngredients()
			 --' *** pd("New product")
			return nil --' Let ing handle it itself
		end
		 --' *** pd()
		return false
	end

	ing:defaultOnWorkStart(task)
	tray:startIngredient(task.duration, ing.compoundPosition, ing.compoundTipType, true)
	 --' *** pd("notify_onWorkStart true")
	return true
end

function Cooker:getNewProductName(productName)
	return productName.."."..self.productAppend
end

function Cooker:notify_onCommit(ing, productName, x, y)
	 --' *** pi("["..self.name.."] Cooker notify on commit: "..productName)
	local newProductName = self:getNewProductName(productName)
	if (not level:isValidProductOrStart(newProductName)) then
		 --' *** pd("handle it yourself")
		return nil --' Let ing handle it itself
	end
	local idx, button = self:getAvailableButton()
	local success = (button ~= nil)
	if (success) then
		button:setIngredientAndResource(newProductName)
		self:animate(
					{call=function()
					end},
					{delay=throwDuration},
					{call=function()
					end})

		local oldParent = button.parent
		local oldButtonLocation = self.buttonPositions[idx]
		local oldAnchor = button.anchor
		button.isOvenProduct = true
		button:becomeChildOf(level.topLayer)
		button.isQueued = true
		local targetLocation = self.buttonPositions[idx]
		button.location = {x=x, y=y}
		button.anchor = "center"
		button:relocateAnchor(oldAnchor)
		--' Temporary set values to give the throw Copy the right appearance
			button.old_visible = button.visible
			button.visible = true
			button.old_baseAnimation = button.baseAnimation
			button.baseAnimation = button.baseAnimation.."_prepare"
			button:throwCopy(targetLocation.x, targetLocation.y, level.topLayer, false)
			button.visible = button.old_visible
			button.baseAnimation = button.old_baseAnimation
		--'
		button:animate({
			{call=function()
				self:playSample("SOUND_FOOD_TO_TRAY:sound")
			end},
			{delay=throwDuration},
			{call=function()
				self:playSample("SOUND_FOOD_ON_TRAY:sound")
				oldParent:addChild(button)
				button.location = oldButtonLocation
				button.state = "prepare"
				button.isQueued = false
			end},
		})

		local num = tray:getCurrentIngredientCount()
		for i = 1,num do
			local ing = tray:getIngredientSource(i)
			 --' *** pi("["..self.name.."] calling defaultOnCommit for ["..ing.name.."]")
			ing:defaultOnCommit(productName, x, y)
			 --' *** pd()
		end
		tray:clearCurrentIngredients()
	end
	 --' *** pd()
	return success
end

function Cooker:showStatus(obj, status, anim)
	obj.visible = true
	if (self[status.."Frame"] >= 0) then
		obj.frame = self[status.."Frame"]
	elseif (self[status.."Cycles"] ~= 0) then
		obj:playAnimation(anim, self[status.."Cycles"], self[status.."FrameTime"], "stay")
	end
end

function Cooker:status_onStartPreparing(ing)
	 --' *** pb("["..self.name.."] Cooker:status_onStartPreparing overlayObject="..ts(self.overlayObject and self.overlayObject.name or nil))
	if (self.overlayObject and self.overlayObject.status_onStartPreparing) then
		self.overlayObject:status_onStartPreparing(ing)
	end
	Cooker.super.status_onStartPreparing(self, ing)
end

function Cooker:status_onBecomeAvailable(ing)
	 --' *** pb("["..self.name.."] Cooker:status_onBecomeAvailable overlayObject="..ts(self.overlayObject and self.overlayObject.name or nil))
	if (self.overlayObject and self.overlayObject.status_onBecomeAvailable) then
		self.overlayObject:status_onBecomeAvailable(ing)
	end
	Cooker.super.status_onBecomeAvailable(self, ing)
end

function Cooker:status_onDecay(ing)
	 --' *** pb("["..self.name.."] Cooker:status_onDecay overlayObject="..ts(self.overlayObject and self.overlayObject.name or nil))
	if (self.overlayObject and self.overlayObject.status_onDecay) then
		self.overlayObject:status_onDecay(ing)
	end
	Cooker.super.status_onDecay(self, ing)
end

function Cooker:status_onDeactivate(ing)
	 --' *** pb("["..self.name.."] Cooker:status_onDeactivate ")
	if (self.overlayObject and self.overlayObject.status_onDeactivate) then
		 --' *** pd("-> overlayObject = " .. ts(self.overlayObject and self.overlayObject.name or nil))
		self.overlayObject:status_onDeactivate(ing)
	end
	Cooker.super.status_onDeactivate(self, ing)
end
