--' ************************************ Changer ************************************ '--
Changer = deriveLuaClass("Changer", "IngredientButton")

function Changer:init(desc)
	Changer.superInit(self, desc)
	self.clickable = true
end

function Changer:onLevelInitialized()
	Changer.super.onLevelInitialized(self)

	if (isString(self.stage)) then
		self.stage = level:getSpriteExt(self.stage)
	end

	if (self.stage) then
		self.stage.visible = false
	end

	self.stages = {}
	for i=1,20 do
		local stage = self["stage"..i]
		if (stage) then
			table.push_back(self.stages, stage)
		end
	end

	self:setCurrentIngredientName(1)
end

function Changer:listPossibleIngredients()
	local ings = {}
	for _,v in ipairs(self.stages) do
		table.push_back(ings, self:getIngredientNameFromResource(v))
	end
	return ings
end

function Changer:allowWork(actor)
	for _,v in ipairs(self.stages) do
		local productName = self:getIngredientNameFromResource(v)
		if (tray:isValidNextIngredient(productName)) then
			return true
		end
	end
	return false
end

function Changer:setCurrentIngredientName(idx)
	self.ingredientName = self:getIngredientNameFromResource(self.stages[idx])
	if (self.stage) then
		self.stage.baseAnimation = self.stages[idx]
	end
end

function Changer:onWorkStart(task)
	--'Changer.super.onWorkStart(self, task)
	self:defaultOnWorkStart(task)
	if (self.stage) then
		self.stage.visible = true
	end
	self.clicked = false
	self:setCurrentIngredientName(1)
	return true
end

function Changer:onWorkClick(task, x, y)
	self.clicked = true
	return true
end

function Changer:onWorkUpdate(task, time)
	local idx = math.floor(task.timer.fraction * #self.stages) + 1
	if (isString(self.stages[idx])) then
		self:setCurrentIngredientName(idx)
	end

	if (Changer.super.onWorkUpdate(self, task, time)) then
		return true
	end
	return self.clicked
end

function Changer:onWorkFinish(task)
	if (self.clicked) then
		Changer.super.onWorkFinish(self, task)
	end

	if (self.stage) then
		self.stage.visible = false
	end
	self:defaultOnWorkFinish(task, success)
	self:setCurrentIngredientName(1)
end
