--' ************************************ Animal ************************************ '--
Animal = deriveLuaClass("Animal", "DelCharacter")

function Animal:init(desc)
	Animal.superInit(self, desc)

	self.dropMax = self.dropMax or 4
	self.dropOffset = self.dropOffset or {x=0, y=0}
	self.dropFloor = self.dropFloor or 0
	self.dropCycles = self.dropCycles or 1
	self.dropVisibleFrame = self.dropVisibleFrame or 0
	self.aggroCycles = self.aggroCycles or 1
	self.atDropLocation = false
	self.needsToExitForLevelEnd = false
	self.dropWorkOffset = self.dropWorkOffset or {x=0,y=0}

	self.clickable = self.aggroAnimation ~= nil and self.aggroAnimation ~= ""
	self.drawOutline = false
	self.dropCount = 0

	self.dropMinDelay = self.dropMinDelay or 0
	self.dropMaxDelay = self.dropMaxDelay or 0
	self.timeForNextDrop = math.Random(self.dropMinDelay,self.dropMaxDelay)

	if (self.dropLocations) then
		self.walkLocations = self.walkLocations or {}
		for _,v in ipairs(self.dropLocations) do
			v.drop = true
			table.insert(self.walkLocations, v)
		end
	end
	self.dropLocations = self.dropLocations or {{x=0, y=0}}
	self.walkLocations = self.walkLocations or {{x=0, y=0}}
	self.location = self:pickNewLocation(self.walkLocations)

	self.stationaryPosition = desc.stationaryPosition or self.location
end

function Animal:onLevelInitialized()
	Animal.super.onLevelInitialized(self)
	self:pickNewAction()

	if (isString(self.dropNotify)) then
		self.dropNotify = level:getSpriteExt(self.dropNotify)
	end
end

function Animal:onTick(time)
	self:tick(time)
	if (self.timeForNextDrop > 1000 and self.dropNotify and self.dropNotify.usesStock and self.dropNotify.stock <= 0) then
		self.timeForNextDrop = 1000
	end
	if (level.addLevelTime and self.timeForNextDrop >= 0) then
		self.timeForNextDrop = self.timeForNextDrop - time
	end
end

function Animal:resetTimer()
	self.timeForNextDrop = math.Random(self.dropMinDelay,self.dropMaxDelay)
end

function Animal:pickNewLocation(t)
	local loc = level.validPosition or {x=0, y=0}
	local minWD = self.minWalkDist and (self.minWalkDist*self.minWalkDist)
	local maxWD = self.maxWalkDist and (self.maxWalkDist*self.maxWalkDist)
	if (isTable(t)) then
		local tries = 1000
		repeat
			loc = t[math.Random(#t)]
			local d = {x=loc.x-self.x, y=loc.y-self.y}
			d = d.x*d.x + d.y*d.y
			tries = tries - 1
		until (tries < 0 or (level:canWalkTo(loc) and
				(not minWD or d >= minWD) and
				(not maxWD or d <= maxWD)))
	end
	if (loc.drop) then
		loc = {x=loc.x - self.dropOffset.x, y=loc.y - self.dropOffset.y, drop=loc.drop}
	end
	return loc
end

function Animal:waitFunc()
	local dur = math.Random(1600, 2400)
	 --' *** pb("["..self.name.."] Animal:waitFunc: "..dur.." msec")
	self:playDefaultAnimation()
	self:addTask({class="Task", duration=dur})
end

function Animal:walkToFunc(locList)
	 --' *** pi("["..self.name.."] Animal:walkToFunc")
	locList = locList or self.walkLocations
	if (locList) then
		local tgt = self:pickNewLocation(locList)
		 --' *** pr("x="..tgt.x..",y="..tgt.y)
		self:addTask({class="WalkToTask", target=tgt, playDefaultOnFinish=true})
		self.atDropLocation = (tgt.drop == true)
	end
	 --' *** pd()
end

function Animal:doDropFunc()
	 --' *** pi("["..self.name.."] Animal:doDropFunc")
	if (not level.needsToAddLevelTime) then
		 --' *** pd("-> level not running...")
		return false
	end

	 --' *** pr("dropMax="..ts(self.dropMax).." dropCount="..ts(self.dropCount))
	if (self.dropMax >= 0 and self.dropCount >= self.dropMax) then
		 --' *** pd("-> too much drops...")
		return false
	end

	 --' *** pr("timeForNextDrop="..ts(self.timeForNextDrop))
	if (self.timeForNextDrop > 0) then
		 --' *** pd("-> not time yet...")
		return false
	end

	 --' *** pr("atDrop="..ts(self.atDropLocation))
	if (not self.atDropLocation) then
		 --' *** pd("-> not at a drop location: walking to it")
		self:walkToFunc(self.dropLocations)
		self:addTask({class="CallTask", func=function() self.atDropLocation = true self:doDropFunc() end})
		return true
	end

	if (self.direction == "left") then self.direction = "right" end

	 --' *** pr("at: x="..ts(self.x + self.dropOffset.y)..", y="..ts(self.y + self.dropOffset.y))

	self:playSample(self.workSoundId)

	local btn = level:add({
		class = "IngredientButton",
		name = "Drop from "..self.name,
		baseAnimation = self.drop,
		x = self.x + self.dropOffset.x,
		y = self.y + self.dropOffset.y,
		anchor = "bottom",
		pivot = "center",
		floor = self.dropFloor,
		--prepareDuration = self.dropPrepareDuration,
		--decayDelay = self.dropDecayDelay,
		workDirection = self.dropWorkDirection,
		workDuration = self.dropWorkDuration,
		workAnimation = self.dropWorkAnimation,
		workFrameTime = self.dropWorkFrameTime,
		hitMaskThreshold = self.dropThreshold,
		workCharacter = self.dropWorkCharacter,
		shadowResource = self.dropShadow,
		deactivateOnWorkFinish = true,
		notifyObject = self.dropNotify,
	})

	btn.workPos = {x=btn.left + btn.width/2 + self.dropWorkOffset.x, y=btn.top + btn.height + self.dropWorkOffset.y}
	local old_defaultOnWorkFinish = btn.defaultOnWorkFinish
	local old_onDecay = btn.onDecay

	switchNeverShowHintClick(btn, "NewEgg")

	btn.defaultOnWorkFinish = function(_, task, success)
		old_defaultOnWorkFinish(btn, task, success)
		 --' *** pb("["..self.name.."] dropping onWorkFinish. dropCount="..ts(self.dropCount).." (-1)")
		if (self.dropCount >= self.dropMax) then
			self:resetTimer()
		end
		self.dropCount = self.dropCount - 1
	end
	btn.onDecay = function(_)
		old_onDecay(btn)
		 --' *** pb("["..self.name.."] dropping decayed. dropCount="..ts(self.dropCount).." (-1)")
		self.dropCount = self.dropCount - 1
	end

	if (self.dropAnimation) then
		btn.visible = false
		local ft = self.dropFrameTime or self.defaultFrameTime
		self:addTask({class="PlayAnimationTask", animation=self.dropAnimation, cycles=self.dropCycles, frameTime=ft, whenFinished="stay", wait=true})
		self:addTask({class="CallTask", func=function() btn.visible = true end})
	end
	self.dropCount = self.dropCount + 1
	self:resetTimer()
	self.atDropLocation = false
	 --' *** pd()
	return true
end

function Animal:pickNewAction()
	 --' *** pi("["..self.name.."] Animal:pickNewAction")
	self.emotion = ""
	self.oldWalkSpeed = self.oldWalkSpeed or self.curWalkSpeed
	self.walkSpeed = self.oldWalkSpeed
	if (level.inStoryMode) then
		self:addTask({class="WalkToTask", target=self.stationaryPosition, playDefaultOnFinish=true})
		self:addTask({class="Task", duration=2000})
	else
		local dropped = false
		if (self.timeForNextDrop <= 0) then
			dropped = self:doDropFunc()
		end
		if (not dropped) then
			randomFromWeightedTable({
				[self.waitFunc] = self.waitChance or 50,
				[self.walkToFunc] = self.walkChance or 10,
			})(self)
		end
	end
	self:addTask({class="Task", duration=100})
	self:addTask({class="CallTask", func=function() self:pickNewAction() end})
	 --' *** pd()
end

function Animal:onClick()
	 --' *** pi("["..self.name.."] Animal:onClick")
	if (self.aggroAnimation) then
		 --' *** pr("playing aggro anim '"..self.aggroAnimation.."'")
		self.clickable = false
		self.oldWalkSpeed = self.oldWalkSpeed or self.curWalkSpeed
		self.curWalkSpeed = self.curWalkSpeed * 3.5
		taskSystem:cancelAllTasksFor(self)
		if (self.walkLocations) then
			local tgt = self:pickNewLocation(self.walkLocations)
			self:addTask({class="WalkToTask", target=tgt, playDefaultOnFinish=true})
			self.atDropLocation = false
		end
		self:addTask({class="PlayAnimationTask", animation=self.aggroAnimation, cycles=self.aggroCycles, frameTime=self.aggroFrameTime or self.defaultFrameTime, whenFinished="stay", wait=true})
		self:addTask({class="CallTask", func=function()
			self.clickable = true
			self.curWalkSpeed = self.oldWalkSpeed
			self:pickNewAction()
		end})
	end
	 --' *** pd()
	return true
end
