dofile("script/rooms/defaults/room6_defaults.lua")

levelDesc.name = "room6_9"
levelDesc.musicMood = "-"
levelDesc.music = "R1"
levelDesc.values.maxTraySize = 6

-----' Example: -----------------------------------
--'	{ trigger = "spawn", delay=2500, customers={"p1", "p1"}, place="table", female=1, male=1, order={class="Order", steps={{"#milk", "#milk"},} }},
--' special friend
--'	{ trigger = "spawn", customers={"p8"}, delay=0,	place="counter", moodDropEnabled=false, order={class="Order", steps={{"#lantern", "#gas"},},} },
--------------------------------------------------

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger = "startEvent", delay=0},
		{ trigger="spawn",	delay=500,		place="counter",},	
		{ trigger="spawn",	delay=7000,		place="counter",},
		{ trigger="spawn",	delay=10000,	place="counter",},
		{ trigger="spawn",	delay=4000,		place="counter",},	
		{ trigger="spawn",	delay=7000,		place="counter",},
		{ trigger="spawn",	delay=10000,	place="counter",},
		{ trigger="spawn",	delay=5000,		place="counter",},	
		{ trigger="spawn",	delay=16000,	place="table",	size=4, customers={"p2","p2","p2","p2"} }, 
		{ trigger="spawn",	delay=16000,	place="table",	size=2, customers={"p5","p5"} }, 
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=6000,		place="counter",},	
		{ trigger="spawn",	delay=6000,		place="counter",},	
		{ trigger="spawn",	delay=16000,	place="table",	size=4, customers={"p1","p1","p1","p1",} }, 
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=14000,	place="table",	size=4,},
		{ trigger="spawn",	delay=10000,	place="counter",},
		{ trigger="spawn",	delay=7000,		place="counter",},	
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=4000,		place="counter",},	
		{ trigger="spawn",	delay=15000,	place="table",	size=4, customers={"p2","p2","p2","p2"} }, 
		{ trigger="spawn",	delay=10000,	place="table",	size=3, customers={"p6","p6","p6"} }, 
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=4000,		place="counter",},	
		{ trigger="spawn",	delay=10000,	place="table",	size=4,},
		{ trigger="spawn",	delay=14000,	place="counter",},
		{ trigger="spawn",	delay=4000,		place="counter",},
		{ trigger="spawn",	delay=7000,		place="counter",},	
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=4000,		place="counter",},	
		{ trigger="spawn",	delay=14000,	place="table",	size=2, customers={"p1","p1","p1","p1"} },
		{ trigger="spawn",	delay=14000,	place="table",	size=4, customers={"p1","p1","p1","p1"} }, 
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=4000,		place="counter",},	
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=4000,		place="counter",},	
		{ trigger="spawn",	delay=14000,	place="counter",},	
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big", dessert=true },
	p2 = { weight=50, base="child", dessert=true },
	p3 = { weight=75, base="elderly", dessert=true },
	p4 = { weight=50, base="normal", dessert=true },
	p5 = { weight=50, base="locals",dessert=true },
	p6 = { weight=50, base="yup",dessert=true },
}

levelDesc.eventDesc =
{
	class="FixEvent",
	bar="progressbar_click_fix",
--'	hideItemOnDone = true,
--'	customCursor = {image="CLEANING:icons", x=25, y=25, frameTime=120, mousePointer="none"},
	scoreAllDone = 300,

	onStart = function(self)
		FixEvent.onStart(self)
		local floor = self.items[1].obj
		floor:createOverhead("snuggy_cloud")
		floor.old_onClick = floor.onClick
		floor.onClick = function(self)
			self:old_onClick()
			self:removeAllModifiers()
			self:removeOverhead()
		end
		floor.old_onWorkFinish = floor.onWorkFinish
		floor.onWorkFinish = function(self, task)
			self:old_onWorkFinish(task)
			if (self.item and not self.item.done) then
				self:animate({delay=1500},
					{call = function()
						if (not self.overhead) then
							self:createOverhead("snuggy_cloud")
						end
					end})
			end
		end
		floor.stateChange = function(obj)
			level:getObject("pile_of_tiles_event").frame = obj.frame
		end
	end
}
