dofile("script/rooms/defaults/room6_defaults.lua")

levelDesc.name = "room6_7"
levelDesc.musicMood = "-"
levelDesc.music = "R1"
levelDesc.values.maxTraySize = 6

-----' Example: -----------------------------------
--'	{ trigger = "spawn", delay=2500, customers={"p1", "p1"}, place="table", female=1, male=1, order={class="Order", steps={{"#milk", "#milk"},} }},
--' special friend
--'	{ trigger = "spawn", customers={"p8"}, delay=0,	place="counter", moodDropEnabled=false, order={class="Order", steps={{"#lantern", "#gas"},},} },
--------------------------------------------------

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger="startEvent",	delay=0,	},
		{ trigger="spawn",	delay=500,		place="counter",},	
		{ trigger="spawn",	delay=2500,		place="counter",},	
		{ trigger="spawn",	delay=8000,		place="table",	size=4,},
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=11000,	place="table",	size=4,},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=11000,	place="table",	size=1,},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=13000,	place="table",	size=2,},
		{ trigger="spawn",	delay=12000,	place="table",	size=3,},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=2500,		place="table",	size=2,},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=12000,	place="table",	size=3,},
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=7000,		place="counter",},	
		{ trigger="spawn",	delay=13000,	place="table",	size=2,},
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=15000,	place="table",	size=1,},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=10000,	place="table",	size=2,},
		{ trigger="spawn",	delay=8000,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=7000,		place="counter",},	
		{ trigger="spawn",	delay=10000,	place="table",	size=4,},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=3000,		place="counter",},	
		{ trigger="spawn",	delay=3000,		place="counter",},	
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="elderly" },
	p4 = { weight=50, base="normal" },
	p5 = { weight=50, base="locals" },
	p6 = { weight=50, base="yup" },
}

function levelDesc:onLevelInitialized()
	DelLevel.onLevelInitialized(self)
	-- 100000
	local table4_4 = level:getObject("table4-4")
	assert(table4_4)
	if (table4_4) then
		table4_4.usedInGameplay = false
		table4_4.clickable = false -- makes the player think it's still used, even though customers won't use it
	end
end

levelDesc.eventDesc =
{
	class="ShoutAndMakeEvent",
	bar = "progressbar_big",

	productPool = {"#applepie", "#bagel", "#coffee", "#tea", "#clubsandwich_twothird", "#clubsandwich_third"},

	numProductsPerOrder = 2,
	numOrders = 10,
	scoreOneDone = 10,
	scoreAllDone = 100,
	timeUntilFirstOrder = 2000,
	timeUntilNextOrder = 15000,
	maxHorizontalSlotCount = 3,
	maxGroupCount = 2,
	limitToMaxGroupCount = true,
	floatersFromHero = true,
	eventWonDelay = 2000,
	items =
	{
		{ obj="table4-4", barPos = {x=33, y=-70}, timeUntilEnd=250000, },
	},

	onStart = function(event)
		ShoutAndMakeEvent.onStart(event)
		event.eventCharacters = {}
		table.insert(event.eventCharacters, level:getCharacter("angela"))
		table.insert(event.eventCharacters, level:getCharacter("jimmy"))
	end,

	eventEnd = function(self)
		stopEating()
		
	end,
}

function stopEating()
	if (event.eating) then
		event.eating = false
		for _,v in ipairs(event.eventCharacters) do
			v:playAnimation("order")
		end
	end
end

levelDesc.old_onDeliver = levelDesc.onDeliver
function levelDesc:onDeliver(order, matched, owner)
	local table4_4 = level:getObject("table4-4")
	
	if (levelDesc.old_onDeliver) then
		levelDesc:old_onDeliver(order, matched, owner)
	end

	if (owner.obj and owner.obj == table4_4 and not event.completed and #matched > 0) then
		event.eating = true
		for k,v in ipairs(event.eventCharacters) do
			local consume = levelDesc.productSettings[matched[k]].consumeAnimation
			if (not consume) then
				consume = "eat"
			end
			if (consume == "eat" or consume == "drink") then
				table4_4.plateState = "full"
			end
			v:playAnimation(consume, -1)
		end
	end
end
