dofile("script/rooms/defaults/room6_defaults.lua")

levelDesc.name = "room6_5"
levelDesc.musicMood = "-"
levelDesc.music = "R1"
levelDesc.values.maxTraySize = 6

-----' Example: -----------------------------------
--'	{ trigger = "spawn", delay=2500, customers={"p1", "p1"}, place="table", female=1, male=1, order={class="Order", steps={{"#milk", "#milk"},} }},
--' special friend
--'	{ trigger = "spawn", customers={"p8"}, delay=0,	place="counter", moodDropEnabled=false, order={class="Order", steps={{"#lantern", "#gas"},},} },
--------------------------------------------------

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger="spawn",	delay=500,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=11000,	place="table",	size=4,},
		{ trigger="spawn",	delay=10000,	place="table",	size=2,}, --14000
		{ trigger = "startEvent", delay=0},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=2500,		place="table",	size=2,},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="table",	size=4,},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=14000,	place="table",	size=2,},
		{ trigger="spawn",	delay=11000,	place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=10000,	place="table",	size=4,},
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="table",	size=3,},
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=15000,	place="table",	size=3,},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=6000,		place="table",	size=1,	},
		{ trigger="spawn",	delay=8000,		place="counter",},	
		{ trigger="spawn",	delay=9000,		place="table",	size=2,},
		{ trigger="spawn",	delay=12000,	place="table",	size=4,},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=8000,		place="counter",},	
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="elderly" },
	p4 = { weight=50, base="normal" },
	p5 = { weight=50, base="locals" },
	p6 = { weight=50, base="yup" },
}

function levelDesc:handleTrigger(trigger, data)

	if (trigger == "addbox") then
		local catboxPile = level:getObject("catboxes_pile")
		catboxPile.frame = catboxPile.frame + 1
	end
	
	return self.class.handleTrigger(self, trigger, data)
end


levelDesc.eventDesc =
{
--'	eventBarText = "TEXT_EVENT1_KEEPITUP1",
--'	eventBarImage = "CHALLENGE_ICON1",
	class="PackageDeliveryEvent",
	scoreOneDone = 40,
	scoreAllDone = 100,

	deliveryCharacter = "deliveryguy",
	deliveryIcon = "catbox_cloud:room6_icons",
	deliveryEmotion = "box3",
--'	deliverySound = "",
	numDeliveriesNeeded = 6, --' IMPORTANT THIS STAYS 6!
	deliveryStartPosition = {x=366, y=-7},
	deliveryPosition = {x=463, y=288},
	storagePosition = {x=679, y=339},
	timeBetweenDeliveriesMin = 15000,
	timeBetweenDeliveriesMax = 30000,
	deliveryWaitTime = 10000,

	onDeliveryCharacterClick = function(obj)
		if (table.contains(event.deliveryCharacters, obj)) then
			obj.clickable = false
			event.deliveryDone = true
			event:hideHintArrow()

			hero:addTask({class="WalkToTask", target=event.pickupPosition, directionOnFinish="up"})
			hero:addTask({class="PlayAnimationTask", animation="work", cycles=1, duration=500})
			hero:addTask({class="CallTask", func=function() --' Move to onWorkFinish
				event:itemDone({})
				event:returnFromDelivery(obj, true) --' Let delivery char walk away
			end})
			event:carryDelivery(hero, true)
			hero:addTask({class="WalkToTask", target=event.storagePosition, playDefaultOnFinish=true})
			event:carryDelivery(hero, false)
			hero:addTask({class="CallTask", func=function()
				level:getObject("catboxes_pile").frame = event.itemsDone
				event:onItemDone()
			end})
		end
	end
}
