dofile("script/rooms/defaults/room6_defaults.lua")

levelDesc.name = "room6_3"
levelDesc.musicMood = "-"
levelDesc.music = "R1"
levelDesc.values.maxTraySize = 5

-----' Example: -----------------------------------
--'	{ trigger = "spawn", delay=2500, customers={"p1", "p1"}, place="table", female=1, male=1, order={class="Order", steps={{"#milk", "#milk"},} }},
--' special friend
--'	{ trigger = "spawn", customers={"p8"}, delay=0,	place="counter", moodDropEnabled=false, order={class="Order", steps={{"#lantern", "#gas"},},} },
--------------------------------------------------

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger="spawn",	delay=1000,		place="counter", },	
		{ trigger="startEvent",	delay=0,},	
		{ trigger="spawn",	delay=4000,		place="table",	size=3,}, --11000
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=3000,		place="table",	size=1,},
		{ trigger="spawn",	delay=7000,		place="counter",},	
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=11000,	place="table",	size=2,},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=6000,		place="table",	size=1,},		
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=2000,		place="table",	size=4,}, --12000
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=5000,		place="table",	size=1,},
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=11000,	place="table",	size=2,},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=6000,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=8000,	place="counter",},			--18000
		{ trigger="spawn",	delay=2500,		place="table",	size=4,},
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=3000,		place="table",	size=3,},	--13000
		{ trigger="spawn",	delay=11000,	place="table",	size=1,},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=5000,		place="counter",},
		{ trigger="spawn",	delay=10000,	place="counter",},
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="elderly" },
	p4 = { weight=50, base="normal" },
	p5 = { weight=50, base="locals" },
	p6 = { weight=50, base="yup" },
}

levelDesc.eventDesc =
{
	class="KeepItUpEvent",
	duration = 99999999, --' TODO Event
	bar = "progressbar_big", --' TODO Event

	scoreAllDone = 200,
	playStartAnimation = true,
	startAnimationCycles = -1,
	startAnimationFrameTime = 300,
	floaterPos = {x=137, y=347},

	items = {
		{
			obj="phone_event",
			absBarPos={x=226, y=341},
			barFloor=700,
			workPos={140, 433},
			overheadPosition = {x=0, y=-70},
			workAnimation="phone_talking",
			workDirection="right",
			workDuration=2500,
			drainDuration=40000,
		},
	},
}

function levelDesc:onFillBarStart(item)
	item.obj:playAnimation("up")
	if (not event.overheadClouds) then
		event.overheadClouds = {"phone_cloud_1", "phone_cloud_2", "phone_cloud_3"}
	end
	local randId = -1
	repeat
		randId = math.Random(#event.overheadClouds)
	until (not self.randId or randId ~= self.randId)
	self.randId = randId
	item.obj:createOverhead(event.overheadClouds[randId])
end

function levelDesc:onFillBarEnd(item)
	item.obj:playDefaultAnimation()
	item.obj:removeOverhead()
end
