dofile("script/rooms/defaults/room5_defaults.lua")

levelDesc.name = "room5_3"
levelDesc.musicMood = "-"
levelDesc.values.maxTraySize = 4
levelDesc.autoStartShift = false

levelDesc.trigger =
{
	class = "TriggerSystem",
	
	triggers =
	{		
		{ trigger="spawn",	delay=1000,		place="counter", },	
		{ trigger="startEvent",	delay=0,},	
		{ trigger="spawn",	delay=4000,		place="table",	size=3,}, --11000
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=3000,		place="table",	size=1, customers={{base="gladys", gender=""}}, order={class="Order", steps={{"#greentea", "#applepie"}, } }	}, --13000
		{ trigger="spawn",	delay=7000,		place="counter",},	
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=11000,	place="table",	size=2,},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=6000,		place="table",	size=1,},		
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=2000,		place="table",	size=4,}, --12000
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=5000,		place="table",	size=1,},
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=11000,	place="table",	size=2,},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=6000,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=8000,	place="counter",},			--18000
		{ trigger="spawn",	delay=2500,		place="table",	size=4,},
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=3000,		place="table",	size=3,},	--13000
		{ trigger="spawn",	delay=11000,	place="table",	size=1,},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=5000,		place="counter",},
		{ trigger="spawn",	delay=10000,		place="counter", customers={{base="elderly", baseAnimation="grumpy", gender="male",}}, requiresUpgrade=true,},
	}
}

function levelDesc:onLevelInitialized()
	DelLevel.onLevelInitialized(self)

	local puppy = level:getObject("puppy")
	local speed = hero:calcValue("walkSpeed")
	puppy.walkSpeed = speed + 20
end


levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="elderly" },
	p4 = { weight=50, base="normal" },
	p5 = { weight=50, base="locals" },
	p6 = { weight=50, base="yup" },
}

levelDesc.eventDesc =
{
	class="FollowAnnoyEvent",
	scoreAllDone = 100,
	scoreOneDone = 25,
	--numAnnoys = 6,
	numAnnoysNeeded = 6,
	annoyCharacterName = "puppy",
	talkDuration = 200,
	talkDirection = "down",
	talkAnimation = "puppycrouch",
	annoyAnimation = "barkevent",
	annoySound = "sound_puppy_bark:sound",

	hintArrowId = "AnnoyingPuppy",
	beginCharacterAnnoy = function(self, character)
		if (player:mayShowHint(self.hintArrowId)) then
			hintManager:placeArrow({hintId = self.hintArrowId, x=character.center.x, y=character.topLeft.y-5, parent=level.dragLayer})
			switchHintArrowClick(character, self.hintArrowId)
		end
	end,
	endCharacterAnnoy = function(self, character)
		if (hintManager:hasArrow(self.hintArrowId)) then
			hintManager:removeArrows(self.hintArrowId)
			player:removeNeverShowHint(self.hintArrowId)
		end
	end,
}
