dofile("script/rooms/defaults/room5_defaults.lua")

levelDesc.name = "room5_1"
levelDesc.music = "R5"
levelDesc.musicMood = "-"
levelDesc.values.maxTraySize = 4
levelDesc.autoStartShift = false

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger="startEvent",	delay=0,},	
		{ trigger="spawn",	delay=500,		place="counter", customers={{base="yup"}}, order={class="Order", steps={{"#lasagna#red#lasagna#red#lasagna#topping.ready", "#greentea"},} }},	
		{ trigger="spawn",	delay=9000,		place="table",	size=3,},
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=11000,	place="table",	size=2,},
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=8000,		place="counter",},	
		{ trigger="spawn",	delay=6000,		place="table",	size=3,},
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=4000,		place="table",	size=2,},
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=9000,		place="table",	size=3,},
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=11000,	place="table",	size=2,},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=6000,		place="counter",},	
		{ trigger="spawn",	delay=10000,		place="counter", customers={{base="normal", baseAnimation="grumpy", gender="male",}}, requiresUpgrade=true,},
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="elderly" },
	p4 = { weight=50, base="normal" },
	p5 = { weight=50, base="locals" },
	p6 = { weight=50, base="yup" },
}

levelDesc.eventDesc =
{
	class="CuriousCustomerEvent",
--'	hintArrowDesc = {hintId="vacuum_cleanup_item4", parent="vacuum_cleanup_item4", x=0, y=0},
	scoreAllDone = 100,
	scoreOneDone = 25,
	numCustomers = 6,
	numCustomersNeeded = 4,
	minNextCustomerDuration = 30000,
	maxNextCustomerDuration = 40000,
	talkDuration = 2000,
	talkDirection = "up",
	talkAnimation = "talking",
	talkPos={x=416, y=681},
	waitPos={x=335, y=651},
	customers={"big", "child", "elderly", "normal",},
	talkToIcon = "talk_to_emily_icon:room5_icons",

	hintArrowId = "CuriousCustomers",
	onCustomerArrived = function(self, character)
		if (player:mayShowHint(self.hintArrowId)) then
			hintManager:placeArrow({hintId = self.hintArrowId, x=character.center.x, y=character.topLeft.y - 47, parent=level.dragLayer})
			switchHintArrowClick(character, self.hintArrowId)
		end
	end,
	onCustomerLeave = function(self, character)
		if (hintManager:hasArrow(self.hintArrowId)) then
			hintManager:removeArrows(self.hintArrowId)
			player:removeNeverShowHint(self.hintArrowId)
		end
	end,
}
