dofile("script/rooms/defaults/room4_defaults.lua")

levelDesc.name = "room4_9"
levelDesc.musicMood = "-"
levelDesc.values.maxTraySize = 6
levelDesc.autoStartShift = false
levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
			{ trigger="spawn",	delay=500,		place="table",	size=2,}, --2500
			{ trigger="spawn",	delay=12000,	place="table",	size=2,},
			{ trigger="spawn",	delay=12000,	place="counter",},	
			{ trigger="spawn",	delay=15000,	place="table",	size=3,},
			{ trigger="spawn",	delay=12000,	place="counter",},	
			{ trigger="startEvent",	delay=0,},	
			{ trigger="spawn",	delay=7000,		place="counter",},	
			{ trigger="spawn",	delay=15000,	place="table",	size=2,},
			{ trigger="spawn",	delay=12000,	place="counter",},	
			{ trigger="spawn",	delay=16000,	place="table",	size=2,},
			{ trigger="spawn",	delay=12000,	place="counter",},	
			{ trigger="spawn",	delay=8000,		place="counter",},	
			{ trigger="spawn",	delay=15000,	place="table",	size=2,},
			{ trigger="spawn",	delay=12000,	place="table",	size=2,},
			{ trigger="spawn",	delay=7000,		place="counter",},	
			{ trigger="spawn",	delay=15000,	place="table",	size=4,},
			{ trigger="spawn",	delay=12000,	place="counter",},	
			{ trigger="spawn",	delay=16000,	place="counter",},	
			{ trigger="spawn",	delay=8000,		place="table",	size=2,},
			{ trigger="spawn",	delay=12000,	place="counter",},	
			{ trigger="spawn",	delay=15000,	place="table",	size=3,},
			{ trigger="spawn",	delay=11000,	place="counter",},	
			{ trigger="spawn",	delay=12000,	place="table",	size=2,},
			{ trigger="spawn",	delay=5000,		place="counter",},	
			{ trigger="spawn",	delay=16000,	place="counter",},	
			{ trigger="spawn",	delay=12000,	place="table",	size=2,},
			{ trigger="spawn",	delay=8000,		place="counter",},	
			{ trigger="spawn",	delay=12000,	place="counter",},	
			{ trigger="spawn",	delay=8000,		place="table",	size=2,},
			{ trigger="spawn",	delay=15000,	place="counter",},	
			{ trigger="spawn",	delay=11000,	place="counter",},	
			{ trigger="spawn",	delay=5000,		place="counter",},	
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big", baseAnimation="customer-biggie2" },
	p2 = { weight=50, base="child", baseAnimation="customer-child2" },
	p3 = { weight=50, base="elderly", baseAnimation="customer-old2" },
	p4 = { weight=50, base="normal", baseAnimation="customer-normal2" },
	p5 = { weight=50, base="locals", baseAnimation="customer-local2" },
	p6 = { weight=50, base="yup", baseAnimation="customer-yup2" },
}
levelDesc.eventDesc =
{
--' TODO: Set correct values
	class="ShoutAndMakeEvent",
	bar = "progressbar_big",
	productPool = {"#caviar", "#fruitcake", "#asparagus#redsauce", "#asparagus#whitesauce", "#crab.ready", "#lam#redsauce", "#lam#whitesauce", "#salmon#redsauce", "#salmon#whitesauce","#lobster.ready", "#oyster", "#lemonwater", "#cremebrulee", "#chocolatecake", },
	numProductsPerOrder = 2,
	numOrders = 7,
	scoreOneDone = 5,
	scoreAllDone = 200,
	timeUntilFirstOrder = 2000,
	timeUntilNextOrder = 25000,
	scribbleDuration = 1500,
	maxHorizontalSlotCount = 3,
	maxGroupCount = 3,
	floatersFromHero = true,
	eventWonDelay = 2000,
	maxNumTimesProductOrdered = 1,
	matchProductPoolProductOrder = true,

	items =
	{
		{ obj="table1-4", barPos = {x=33, y=-70}, timeUntilEnd=250000, },
	},

	onInitialized = function(event)
		ShoutAndMakeEvent.onInitialized(event)
		levelDesc.eventTable = event.items[1].obj
		assert(levelDesc.eventTable)
		if (levelDesc.eventTable) then
			levelDesc.eventTable.usedInGameplay = false
			levelDesc.eventTable.clickable = false
		end
	end,

	eventEnd = function(self)
		if (levelDesc.eventTable) then
			levelDesc.eventTable.plateState = "empty"
			--'levelDesc.eventTable.usedInGameplay = true
			--'levelDesc.eventTable.clickable = true
		end
	end,
}

function levelDesc:onProductAdded()
	local philippe = level:getCharacter("philippe")
	taskSystem:cancelAllTasksFor(philippe)
	philippe:playAnimation("order", -1)
end

levelDesc.old_onDeliver = levelDesc.onDeliver
function levelDesc:onDeliver(order, matched, owner)
	if (self.old_onDeliver) then
		levelDesc:old_onDeliver(order, matched, owner)		
	end

	if (owner.obj == levelDesc.eventTable and not event.completed and #matched > 0) then
		local consume = self.productSettings[matched[1]].consumeAnimation
		if (consume) then
			event.eating = true
			if (consume == "eat" or consume == "drink") then
				levelDesc.eventTable.plateState = "full"
			end
			local critic = level:getCharacter("philippe")
			critic:playAnimation("sit_"..consume, -1)
			assert(event.scribbleDuration)
			--' Scribble down some notes
			local timeLeftUntilNext = event.items[1].nextOrderTimer
			if (timeLeftUntilNext < 0) then timeLeftUntilNext = 0 end
			critic:animate({delay=timeLeftUntilNext}, {call=function() critic:playAnimation("sit_scribble", -1) end})
			event.items[1].nextOrderTimer = timeLeftUntilNext + event.scribbleDuration
		end
	end
end
