dofile("script/rooms/defaults/room4_defaults.lua")

levelDesc.name = "room4_3"
levelDesc.musicMood = "-"
levelDesc.values.maxTraySize = 4
levelDesc.autoStartShift = false
levelDesc.endLevelDelay = 3000

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger="spawn",	delay=500,		place="counter",},	
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=6000,		place="table",	size=2,}, --changed some table sizes
		{ trigger="spawn",	delay=6000,		place="table",	size=4,}, --10000
		{ trigger="spawn",	delay=12000,	place="counter",},				
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=8000,		place="table",	size=2,},
		{ trigger="spawn",	delay=6000,		place="table",	size=2,}, --10000
		{ trigger="startEvent",	delay=6000,	},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=7000,		place="counter",},	
		{ trigger="spawn",	delay=8000,		place="table",	size=3,},
		{ trigger="spawn",	delay=12000,	place="table",	size=2,},
		{ trigger="spawn",	delay=2000,		place="counter",},		  --12000
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=11000,	place="counter",},	
		{ trigger="spawn",	delay=12000,	place="table",	size=2,},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=6000,		place="table",	size=2,}, --16000
		{ trigger="spawn",	delay=8000,		place="table",	size=4,}, --13000	
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=7000,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="table",	size=2,},
		{ trigger="spawn",	delay=7000,		place="counter",},	
		{ trigger="spawn",	delay=2000,		place="table",	size=2,}, --12000
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=11000,	place="counter",},	
		{ trigger="spawn",	delay=9000,		place="counter",},	
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big", baseAnimation="customer-biggie2" },
	p2 = { weight=50, base="child", baseAnimation="customer-child2" },
	p3 = { weight=50, base="elderly", baseAnimation="customer-old2" },
	p4 = { weight=50, base="normal", baseAnimation="customer-normal2" },
	p5 = { weight=50, base="locals", baseAnimation="customer-local2" },
	p6 = { weight=50, base="yup", baseAnimation="customer-yup2" },
}

levelDesc.eventDesc =
{
	class="ChaseEvent",
	scoreOneDone = 25,
	scoreAllDone = 100,
	chaseCharacter = "jeanpaul",
	nrTimesToCatch = 4,
	maxNrTries = 1000,
	timeBetweenRunsMin = 15000,
	timeBetweenRunsMax = 20000,
	tauntTimes = {2000, 2000, 2500, 2500, 3000, 3000, 4000, 4000},
	timeUntilFirstRun = 15000,
	setPath = {4, -1, -1, 1},
	--' padnummer uit de editor 1-4
	tauntTextIds =
	{
		"TEXT_Taunt1",
		"TEXT_Taunt2",
		"TEXT_Taunt3",
	},

	hintArrowId = "ChaseJP",
	onArriveAtTauntLocation = function(self, character)
		if (player:mayShowHint(self.hintArrowId)) then
			hintManager:placeArrow({hintId = self.hintArrowId, parent = character})
			switchHintArrowClick(character, self.hintArrowId)
		end
	end,
	onLeaveTauntLocation = function(self, character)
		if (hintManager:hasArrow(self.hintArrowId)) then
			hintManager:removeArrows(self.hintArrowId)
			player:removeNeverShowHint(self.hintArrowId)
		end
	end,
}
--' kan in room defaults gezet worden, bepaalt dat character op het einde van het level ergens anders heen loopt
function levelDesc:getExitPositionForCharacter(character, hasWon)
	if (character.name == "jeanpaul") then
		return {x=1114, y=540}
	end
	return nil
end
