dofile("script/rooms/defaults/room4_defaults.lua")

levelDesc.name = "room4_1"
levelDesc.musicMood = "-"
levelDesc.values.maxTraySize = 3
levelDesc.autoStartShift = false

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger="startEvent",	delay=0,},	
		{ trigger="spawn",	delay=500,		place="counter",},	
		{ trigger="spawn",	delay=9000,		place="table",	size=2,},
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=11000,	place="table",	size=1,},
		{ trigger="spawn",	delay=6000,		place="counter",},	
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=14000,	place="table",	size=2,},
		{ trigger="spawn",	delay=6000,		place="counter",},	
		{ trigger="spawn",	delay=9000,		place="table",	size=2,},
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=8000,		place="table",	size=2,},
		{ trigger="spawn",	delay=10000,	place="table",	size=2,},
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=12000,	place="table",	size=2,},
		{ trigger="spawn",	delay=7000,		place="counter",},	
		{ trigger="spawn",	delay=8000,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="table",	size=2,},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=7000,		place="counter",},	
		{ trigger="spawn",	delay=8000,		place="counter",},	
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big", baseAnimation="customer-biggie2" },
	p2 = { weight=50, base="child", baseAnimation="customer-child2" },
	p3 = { weight=50, base="elderly", baseAnimation="customer-old2" },
	p4 = { weight=50, base="normal", baseAnimation="customer-normal2" },
	p5 = { weight=50, base="locals", baseAnimation="customer-local2" },
	p6 = { weight=50, base="yup", baseAnimation="customer-yup2" },
}

levelDesc.eventDesc =
{
	class="HiddenObjectEvent",
--'	hintArrowDesc = {hintId="vacuum_cleanup_item4", parent="vacuum_cleanup_item4", x=0, y=0},
	scoreAllDone = 100,
	scoreOneDone = 25,
	initObjectsHidden = false,
	hideItemOnDone = true,
	hintDesc = {hintId="ChaseDoves"},

	flyAway = function(obj, params)
		local pidgeonBaseAnim = params.baseAnimation or "pidgeonmale"
		local pidgeon = level:createCharacter({base="default", baseAnimation=pidgeonBaseAnim, x=obj.x, y=obj.y})
		pidgeon.shadowVisible = false
		pidgeon:playAnimation("flying", -1)
		pidgeon.timePassed = 0
		local flyTime = 3000

		if (params.direction == "up") then
			pidgeon.direction = params.direction
			pidgeon.y = pidgeon.y + 30
			pidgeon:addTask({class="LuaTask",
			update=function(self, time)
				pidgeon.floor=pidgeon.floor+(time*(1700/flyTime))
				pidgeon.timePassed = pidgeon.timePassed + time
				if (pidgeon.timePassed > flyTime) then return true
				else return false end
			end
			, duration=flyTime})
		else
			local goingRight = params.direction ~= "left"
			local flyTarget = {x=obj.x + (goingRight and 1500 or -1500), y=obj.y - 750}
			pidgeon.direction = (goingRight and "right" or "left")
			pidgeon:addTask({class="LuaTask",
					update=function(self, time)
						pidgeon.floor=pidgeon.floor+(time*(750/flyTime))
						pidgeon.x=pidgeon.x+((goingRight and 1 or -1) * time*(1500/flyTime))
						pidgeon.timePassed = pidgeon.timePassed + time
						if (pidgeon.timePassed > flyTime) then return true
						else return false end
					end
					, duration=flyTime})
		end
		pidgeon:addTask({class="RemoveTask"})
	end,
}

function hiddenObjectOnClick(obj)
	if (obj.visible) then
		obj.clickable = false
		hero:addTask({class="WalkToTask", target=obj,})
		local params = tryParse(obj.extraParams) or {}
		local shooAnim = params.shooAnimation or "shoo_cat"
		if (params.heroDirection) then
			hero:addTask({class="DirectionTask", direction=params.heroDirection})
		end
		hero:addTask({class="PlayAnimationTask", animation=shooAnim, cycles=1, frameTime=100, wait=true})
		hero:addTask({class="CallTask", func= function() event:itemDone(obj.item) event.flyAway(obj, params) end,})
		hero:addTask({class="PlayDefaultAnimationTask",})
		return true
	end
end

