dofile("script/rooms/defaults/room3_defaults.lua")

levelDesc.name = "room3_5"
levelDesc.musicMood = "-"
levelDesc.values.maxTraySize = 4
levelDesc.autoStartShift = false

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger="startEvent",	delay=0,	},	
		{ trigger="spawn",	delay=1000,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="table",	size=3,},
		{ trigger="spawn",	delay=14000,	place="table",	size=2,},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=15000,	place="table",	size=4,},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=10000,	place="table",	size=3,},
		{ trigger="spawn",	delay=13000,	place="table",	size=2,},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=13000,	place="table",	size=4,},
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=4000,		place="table",	size=2,},
		{ trigger="spawn",	delay=12000,	place="table",	size=3,},
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=15000,	place="table",	size=4,},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="table",	size=3,},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=13000,	place="table",	size=2,},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=8000,		place="counter",},	
		{ trigger="spawn",	delay=8000,		place="counter",},	
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big", baseAnimation="customer-biggie2" },
	p2 = { weight=50, base="child", baseAnimation="customer-child2" },
	p3 = { weight=50, base="elderly", baseAnimation="customer-old2" },
	p4 = { weight=50, base="normal", baseAnimation="customer-normal2" },
	p5 = { weight=50, base="locals", baseAnimation="customer-local2" },
	p6 = { weight=50, base="yup", baseAnimation="customer-yup2" },
}

function stopEating()
	if (event.eating) then
		event.eating = false
		level:getCharacter("healthinspector"):playAnimation("read")
		levelDesc.eventTable.plateState = "dirty"	
	end
end

levelDesc.eventDesc =
{
	class = "ShoutAndMakeEvent",
	productPool = {"#lettuce#carrot#cucumber#shrimp", "#toast.ready#cheese", "#lettuce#carrot#cucumber#shrimp", "#milk", "#croissant", "#baguette", "#toast.ready#ham", "#strawberry.ready#glass"},
	numProductsPerOrder = 2,
	numOrders = 8,
	scoreAllDone = 100,
	scoreOneDone = 12.5,
	timeUntilFirstOrder = 2000,
	timeUntilNextOrder = 30000,
	maxHorizontalSlotCount = 3,
	maxGroupCount = 3,
	eventWonDelay = 2000,
	eventBarIconObject = "stewardess",
	matchProductPoolProductOrder = true,
	blinkStartFraction = 0.1,
	floaterPos={x=767, y=348},
	
	items =
	{
		{ obj="table5-1", timeUntilEnd=340000, overheadPosition={x=-20, y=-30}, noProgressBar=true, },
	},

	onInitialized = function(event)
		ShoutAndMakeEvent.onInitialized(event)
		levelDesc.eventTable = level:getObject("table5-1")
		if (levelDesc.eventTable) then
			levelDesc.eventTable.usedInGameplay = false
			levelDesc.eventTable.clickable = false
		end
		levelDesc.disableTable = level:getObject("table4-1")
		if (levelDesc.disableTable) then
			levelDesc.disableTable.usedInGameplay = false
		end
	end,

	orderFirstTime = function(event, item)
		if (item.numOrders == event.numOrders) then
			level:getCharacter("healthinspector"):playAnimation("order", -1)
		end
	end,

	eventEnd = function(self)
		stopEating()
		if (levelDesc.eventTable) then
			levelDesc.eventTable.plateState = "empty"
			levelDesc.eventTable.usedInGameplay = true
			levelDesc.eventTable.clickable = true
		end
	end
}

function levelDesc:onDeliverProducts(item)
	if (not event.completed and not event.eating) then
		event.eating = true
		level:getCharacter("healthinspector"):playAnimation("eat", -1)
		levelDesc.eventTable.plateState = "full"
	end
end


