dofile("script/rooms/defaults/room2_defaults.lua")

levelDesc.name = "room2_7"
levelDesc.musicMood = "-"
levelDesc.values.maxTraySize = 5
levelDesc.autoStartShift = false

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
	--single wave then quiet
		{ trigger="startEvent",	delay=1000,	},	
		{ trigger="spawn",	delay=500,		place="table",	size=3,},
		{ trigger="spawn",	delay=11000,	place="counter",},	
		{ trigger="spawn",	delay=6000,		place="table",	size=4,}, --12000
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=10000,		place="table",	size=2,}, --14000, 4000
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=8000,		place="table",	size=2,}, --13000
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=10000,	place="table",	size=4,}, --12000	
		{ trigger="spawn",	delay=10000,		place="table",	size=2,}, --14000, 4000
		{ trigger="spawn",	delay=11000,	place="counter",},	
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=15000,		place="table",	size=3,}, --15000, 5000
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=14000,	place="table",	size=4,},
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=9000,		place="table",	size=3,}, --15000, 5000
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=7000,		place="table",	size=2,}, --14000, 4000
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=15000,	place="table",	size=4,},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=3000,		place="counter",},	
		{ trigger="spawn",	delay=14000,	place="table",	size=2,},
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=10000,	place="counter",},	
		{ trigger="spawn",	delay=5000,		place="counter",},	
		{ trigger="spawn",	delay=10000,		place="counter", customers={{base="normal", baseAnimation="purplelady", gender="female",}}, requiresUpgrade=true,},
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big", baseAnimation="customer-biggie2" },
	p2 = { weight=50, base="child", baseAnimation="customer-child2" },
	p3 = { weight=50, base="elderly", baseAnimation="customer-old2" },
	p4 = { weight=50, base="normal", baseAnimation="customer-normal2" },
	p5 = { weight=50, base="locals", baseAnimation="customer-local2" },
	p6 = { weight=50, base="yup", baseAnimation="customer-yup2" },
}

levelDesc.eventDesc =
{
	class="KeepItUpEvent",
	duration = 99999999, --' TODO Event
	bar = "progressbar_big", --' TODO Event

	scoreAllDone = 200,
	playStartAnimation = true,
	startAnimation = "sit_depressed",
	startAnimationCycles = -1,
	startAnimationFrameTime = 300,
	floaterPos = {x=285, y=200},

	items = {
		{
			obj={base="carlos", name="carlos2"},
			absBarPos={x=300, y=210},
			barFloor=700,
			workPos={382, 230},
			overheadPosition = {x=20, y=-115},
			workAnimation="consoling",
			workDirection="right",
			workDuration=2500,
			drainDuration=75000,
		},
	},

	hintDesc = {hintId = "KeepCaring"},
	showHintOnStart = false,--'Show it at 90%

	restoreItem = function(self, item)
		self:removeDecals(item)
	end,

	onInitialized = function()
		KeepItUpEvent.onInitialized(event)
		event.hintWasShown = false
	end,
	onProgress = function()
		KeepItUpEvent.onProgress(event)
		if (not event.hintWasShown and event:getProgress() <= 0.9) then
			event:showHint()
			event.hintWasShown = true
		end
	end
}

function levelDesc:onFillBarStart(item)
	local clouds = {"carmen_cloud", "heart_cloud", "plane_cloud"}
	item.obj:createOverhead(clouds[math.Random(#clouds)])
end

function levelDesc:onFillBarEnd(item)
	item.obj:removeOverhead()
end
