dofile("script/rooms/defaults/room2_defaults.lua")

levelDesc.name = "room2_1"
levelDesc.musicMood = "-"
levelDesc.values.maxTraySize = 3
levelDesc.showSuitcases = false

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger="startEvent",	delay=0,	},	
		{ trigger="spawn",	delay=500,		place="counter",},	
		{ trigger="spawn",	delay=9000,		place="table",	size=2,},
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=10000,	place="table",	size=2,},
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=13000,	place="table",	size=2,},
		{ trigger="spawn",	delay=9000,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="counter",},	
		{ trigger="spawn",	delay=14000,	place="table",	size=2,},
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=5000,		place="counter",},	
		{ trigger="spawn",	delay=12000,	place="table",	size=2,},
		{ trigger="spawn",	delay=7000,		place="counter",},	
		{ trigger="spawn",	delay=13000,	place="table",	size=2,},
		{ trigger="spawn",	delay=8000,		place="counter",},	
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=10000,		place="counter", customers={{base="normal", baseAnimation="purplelady", gender="female",}}, requiresUpgrade=true,},
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big", baseAnimation="customer-biggie2" },
	p2 = { weight=50, base="child", baseAnimation="customer-child2" },
	p3 = { weight=50, base="elderly", baseAnimation="customer-old2" },
	p4 = { weight=50, base="normal", baseAnimation="customer-normal2" },
	p5 = { weight=50, base="locals", baseAnimation="customer-local2" },
	p6 = { weight=50, base="yup", baseAnimation="customer-yup2" },
}

levelDesc.suitcaseCounter = 0
-- return if the item has been created
function levelDesc:generateFindObject(event, object)
	if (self.hasShiftFinished) then
		event:eventLost()
		return
	end

	local baseAnim = object
	if (levelDesc.suitcaseCounter < 3 or math.Random(2) > 1) then
		local suitcases = {"suitcase_5", "suitcase_6", "suitcase_7", "suitcase_8", "suitcase_9", "suitcase_10", "suitcase_11", "suitcase_12", "suitcase_13", "suitcase_14"}
		baseAnim = suitcases[math.Random(#suitcases)]
		levelDesc.suitcaseCounter = levelDesc.suitcaseCounter + 1
	end

	local suitcase = level:createCharacter({name=baseAnim, base="default", walkSpeed=100, defaultSection="room2_icons", baseAnimation = baseAnim, x=event.entrancePositions[1].x, y=event.entrancePositions[1].y})
	suitcase:addTask({class="PlaySoundTask", sound="sound_suitcase_appear:sound"})
	suitcase:addTask({class="WalkToTask", target=event.exitPositions[1]})
	suitcase:addTask({class="RemoveTask"})

	if (baseAnim == object) then
		event:initializeFindObject(suitcase)
		levelDesc.suitcaseCounter = 0
	end

	return false
end

function levelDesc:initializeFindObject(event, object)
	object.onClick = function(self)
			self.clickable = false

			local searchingObject = event:getCurSearchingObject()
			assert(searchingObject)

			searchingObject:removeOverhead()

			searchingObject:addTask({class="Task", duration=300})
			searchingObject:addTask({class="PlaySoundTask", sound="sound_suitcase_appear:sound"})
			searchingObject:addTask({class="WalkToTask", target={x=1070, y=218}})
			searchingObject:addTask({class="CallTask", func=function() event:SetupNextSearchObject() end})

			if (event.scoreOneDone and event.scoreOneDone > 0) then
				local pos = self.floaterPosition
				local text = string.format(ghf.getText("EVENT_SCORE_ONE_DONE"), event.scoreOneDone)
				level:handleScore(event.scoreOneDone, pos.x, pos.y, false, 0);
				effects.createScoreFloater(level.floaterLayer, text, pos.x, pos.y, event.scoreOneDone, 0)
				if (level.BM_eventScore) then level:BM_eventScore(event.scoreOneDone) end
			end

			eventBar:incValue(1)
		end	

	object.clickable = true	
end

levelDesc.eventDesc =
{
	class="StayAlertEvent",
	entrancePositions = levelDesc.suitcaseEntrancePositions,
	exitPositions = levelDesc.suitcaseExitPositions,	
	generateFindObjectFunc = levelDesc.generateFindObject,
	initializeFindObjectFunc = levelDesc.initializeFindObject,
	floaterPos = {x=866, y=92},
	objectsToFind = {
		{searchingObject="child2male", objects={{overhead="lost_suitcase_1:room2_icons", objectName="suitcase_1", linkUnderParent=true},}, }, --' Link this balloon under the parent instead of GUI layer
		{searchingObject="yup2female", objects={{overhead="lost_suitcase_3:room2_icons", objectName="suitcase_3", },}, }, 
		{searchingObject="biggie2male", objects={{overhead="lost_suitcase_2:room2_icons", objectName="suitcase_2", },}, },
		{searchingObject="yup2male", objects={{overhead="lost_suitcase_4:room2_icons", objectName="suitcase_4",},}, },
	},
	minNextFindObjectDuration = 2000,
	maxNextFindObjectDuration = 3000,
	hintDesc = {hintId="Suitcases"},
	scoreAllDone = 100,
	scoreOneDone = 25,
	eventWon = function(self) StayAlertEvent.eventWon(self) level.showSuitcases = true end,
}
