dofile("script/rooms/defaults/room1_defaults.lua")
dofile("script/animations/room1_tutorial_animations.lua")

levelDesc.name = "tutorial"
levelDesc.musicMood = "-"
levelDesc.autoStartShift = false

levelDesc.values.maxTraySize = 3

-----' Example: -----------------------------------
--'	{ trigger = "spawn", delay=2500, customers={"p1", "p1"}, place="table", female=1, male=1, order={class="Order", steps={{"#milk", "#milk"},} }},
--' special friend
--'	{ trigger = "spawn", customers={"p8"}, delay=0,	place="counter", moodDropEnabled=false, order={class="Order", steps={{"#lantern", "#gas"},},} },
--------------------------------------------------

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
	}
}

levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="elderly" },
	p4 = { weight=50, base="normal" },
	p5 = { weight=50, base="locals" },
	p6 = { weight=50, base="yup" },
}

--'' Tutorial flow

function levelDesc:startTutorial()
	self.tutorialState = "StartTutorial"
	self.tutorialActive = true
	self.inputAlwaysEnabled = true
	self.currentMessageId = ""
	self:disableAllObjects()

	self.isGamePlayLevel = false
	--print("[TUTORIAL] Starting")

	taskSystem:createAnimation("TutorialContent 1")
end

function levelDesc:endTutorial()
	self.tutorialState = "Done"
	self.tutorialActive = false
	self.inputAlwaysEnabled = false
	self:restoreAllObjects()
	print("[TUTORIAL] Done")

	self.isGamePlayLevel = true
	taskSystem:createAnimation("onTutorialEnd")
end

levelDesc.old_handleTrigger = levelDesc.handleTrigger
function levelDesc:handleTrigger(trigger, data)

	if (trigger == "startTutorial") then
		self:startTutorial()
	else
		--' Tutorial triggers
		if (self.tutorialActive) then
			if (trigger == "doHintArrow") then
				assert(data.params)
				local params = data.params
				params = string.gsub(params, "%s", "") --' Trim whitespace
				local ings = string.split(params, ",")
				local name = ""
				if (#ings > 1) then
					self.tutorialHintArrowIdx = 1
					self.tutorialHintArrowObjects = {}
					for _,v in ipairs(ings) do
						table.push_back(self.tutorialHintArrowObjects, v)
						player:removeNeverShowHint(v)
					end
					name = self.tutorialHintArrowObjects[1]
				else
					name = params
				end
				local item
				if (name == "tutorialCustomer") then
					item = self.currentGroup.overheadObject
				else
					item = self:getSpriteExt(name)
				end
				assert(item)
				doHintArrow(item, name)

			elseif (trigger == "setTutorialState") then
				self.tutorialState = data.params

			elseif (trigger == "fireSpawnTrigger") then
				local params = tryParse(data.params)
				assert(isTable(params))
				self:fireTrigger("spawn", params)
				self.tutorialOrder = params.order

			elseif (trigger == "endTutorial") then
				self:endTutorial()
			end
		end
	end

	if (levelDesc.old_handleTrigger) then
		return levelDesc.old_handleTrigger(self, trigger, data)
	else
		return self.class.handleTrigger(self, trigger, data)
	end
end

function levelDesc:onCustomerGroupStateEnter(customerGroup, state)
	if (self.tutorialActive) then
		if (state == "Thinking") then
			if (self.tutorialState == "firstCustomer") then
				self.currentGroup = customerGroup
				taskSystem:createAnimation("TutorialContent 2")
			end

		elseif (state == "Ordering") then
			if (self.tutorialState == "firstCustomer") then
				taskSystem:createAnimation("TutorialContent 3")

			elseif (self.tutorialState == "firstGroup") then
				self.currentGroup = customerGroup
				taskSystem:createAnimation("TutorialContent 7")
			end

		elseif (state == "Paying") then
			if (level.tutorialState == "firstCustomerOrderDelivery") then
				taskSystem:createAnimation("TutorialContent 5")--', {tutorialCharacter=self.currentGroup.main})

			elseif (self.tutorialState == "firstGroup") then
				if (level.mouseStepDone) then
					taskSystem:createAnimation("TutorialContent 8")
				else
					level.manualStepAfterMouse = true
				end
			end
		elseif (state == "Eating") then
			if (level.tutorialState == "firstGroup") then
				taskSystem:createAnimation("TutorialContent 7a")
				level.tutorialMouse = level:getObject("mouse1")
				level.tutorialMouse:addTask({class="SetTask", visible=true, showing=true})
				level.tutorialMouse:addTask({class="PlaySoundTask", sound="MOUSE_SQUEAK:sound"})
				level.tutorialMouse:addTask({class="PlayAnimationTask", animation=self.moveType, cycles=1, frameTime=100, whenFinished="stay", wait=true})
			end
		end
	end
end

function arrowObject_onWorkFinish(obj, task)
	if (level.tutorialActive) then
		if (level.tutorialState == "firstCustomerOrder") then
			taskSystem:createAnimation("TutorialContent 4")

		elseif (level.tutorialState == "firstCustomerOrderDelivered") then
			taskSystem:createAnimation("TutorialContent 6")

		elseif (level.tutorialState == "firstGroupDone") then
			taskSystem:createAnimation("TutorialContent 9")

		elseif (level.tutorialState == "firstTableCleaning") then
			taskSystem:createAnimation("TutorialContent 11")
		end
	end

	obj.onWorkFinish = obj.old_onWorkFinish
	obj:onWorkFinish(task)
end

function levelDesc:onOrderCompleted(order, owner)
	if (self.tutorialState == "firstGroup") then
		hero:addTask({class="WalkToTask", target=self.heroPosition, playDefaultOnFinish=true})
	end

	DelLevel:onOrderCompleted(order, owner)
end

--'' Tutorial helper functions

function levelDesc:disableAllObjects()
	local objs = self:getObjects()
	for _,v in ipairs(objs) do
		if (v.old_clickable == nil) then
			v.old_clickable = v.old_clickable or (v.clickable == true)
		end
		v.clickable = false
	end
	if (tray) then
		if (tray.old_clickable == nil) then
			tray.old_clickable = tray.old_clickable or (tray.clickable == true)
		end
		tray.clickable = false
	end
end

function levelDesc:restoreAllObjects()
	local objs = self:getObjects()
	for _,v in ipairs(objs) do
		v.clickable = v.old_clickable
	end
	if (tray) then
		tray.clickable = tray.old_clickable
	end
end

function doHintArrow(obj, id, offset)
	assert(obj)
	obj.old_onClick = obj.onClick or obj.old_onClick or function() end
	obj.onClick = onArrowObjectClick
	offset = offset or {x=0, y=0}
	obj.hintArrowPosition = obj.hintArrowPosition or {x=0, y=0}
	local pos = {x=obj.left + obj.hintArrowPosition.x, y=obj.top + obj.hintArrowPosition.y}
	if (id) then
		player:removeNeverShowHint(id)
	end
	hintManager:placeArrow({
		hintId=id,
		parent=level.dragLayer,
		x= pos.x + offset.x,
		y= pos.y + offset.y,
	})
	level:disableAllObjects()
	obj.clickable = true
end

function onArrowObjectClick(obj)
	obj.old_onWorkFinish = obj.onWorkFinish
	obj.onWorkFinish = arrowObject_onWorkFinish

	obj.onClick = obj.old_onClick
	obj:onClick()
	obj.clickable = false
	hintManager:removeArrows("", true)

	if (level.tutorialHintArrowObjects and #level.tutorialHintArrowObjects > 1 and
			level.tutorialHintArrowIdx < #level.tutorialHintArrowObjects)
	then
		local idx = level.tutorialHintArrowIdx + 1
		level.tutorialHintArrowIdx = idx
		local name = level.tutorialHintArrowObjects[idx]
		local item
		if (name == "tutorialCustomer") then
			item = level.currentGroup.overheadObject
		else
			item = level:getSpriteExt(name)
		end
		assert(item)
		doHintArrow(item)
	end

	if (level.tutorialActive and obj.name == "mouse1") then
		level:getObject("evelyn"):hideMessageDialog("killMouse")
		if (level.manualStepAfterMouse) then
			taskSystem:createAnimation("TutorialContent 8")
		else
			level.mouseStepDone = true
		end
	end
	if (level.tutorialActive and level.tutorialState == "firstTableCleaning") then
		taskSystem:createAnimation("TutorialContent 10")
	end

	return true
end
