dofile("script/rooms/defaults/room1_defaults.lua")

levelDesc.name = "room1_7"
levelDesc.musicMood = "-"
levelDesc.values.maxTraySize = 4
levelDesc.autoStartShift = false

levelDesc.trigger =
{
	class = "TriggerSystem",
	triggers =
	{
		{ trigger = "startEvent", delay=0},
		{ trigger="spawn",	delay=500,		place="counter",},	
		{ trigger="spawn",	delay=14000,	place="table",		size=3,},
		{ trigger="spawn",	delay=13000,	place="counter",},	
		{ trigger="spawn",	delay=11000,	place="counter",},	
		{ trigger="spawn",	delay=15000,	place="table",		size=2,},
		{ trigger="spawn",	delay=15000,	place="table",		size=1,},
		{ trigger="spawn",	delay=16000,	place="counter",},	
		{ trigger="spawn",	delay=14000,	place="counter",},	
		{ trigger="spawn",	delay=6000,		place="counter",},	
		{ trigger="spawn",	delay=17000,	place="counter",},	
		{ trigger="spawn",	delay=15000,	place="table",		size=3,},
		{ trigger="spawn",	delay=16000,	place="counter",},	
		{ trigger="spawn",	delay=15000,	place="table",		size=2,},
		{ trigger="spawn",	delay=16000,	place="table",		size=1,},
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=16000,	place="table",		size=1,},
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=16000,	place="table",		size=4,},
		{ trigger="spawn",	delay=17000,	place="counter",},	
		{ trigger="spawn",	delay=15000,	place="counter",},	
		{ trigger="spawn",	delay=15000,	place="counter",},	
		
	}
}
levelDesc.customerList =
{
	p1 = { weight=50, base="big" },
	p2 = { weight=50, base="child" },
	p3 = { weight=50, base="elderly" },
	p4 = { weight=50, base="normal" },
	p5 = { weight=50, base="locals" },
	p6 = { weight=50, base="yup" },
}

function levelDesc:onLevelInitialized()
	DelLevel.onLevelInitialized(self)
	-- 100000
	local table2_2 = level:getObject("table2-2")
	if (table2_2) then
		table2_2.usedInGameplay = false
		--table2_2.clickable = false -- makes the player think it's still used, even though customers won't use it
	end
end

levelDesc.eventDesc =
{
	class="FixEvent",
	bar="progressbar_click_fix",
	hideItemOnDone = true,
	--customCursor = {image="CLEANING:icons", x=25, y=25, frameTime=120, mousePointer="none"},
	--scoreAllDone = 100,
	scoreOneDone = 200,
	hintArrowDesc = {hintId="DressEmily", parent="edward", x=0, y=0},
	initObjectsHidden = true,
	showItemsOnStart = false,

	onStart = function(self) 		
		FixEvent.onStart(self)
		local edward = level:getObject("edward")
		assert(edward, "no evelyn")
		local emily_dress = level:getChild("emily_dress")
		assert(emily_dress, "no emily_dress")
		local item = event:getItemForObject(emily_dress)

		event:preserveItem(item)
		item.shownForEvent = true
		item.obj.clickable = false
		item.obj.doHighlight = false
		FixEvent.showItem(event, item)

		edward.onClick = function(self) self.selected = true hintManager:removeArrows("DressEmily") FixEvent.fixEventOnClick(emily_dress) end
		edward.clickable = true

--'		hintManager:placeArrow({hintId="DressEmily", parent=edward})
	end,
}

function levelDesc.event_onClick(self, obj)
	if (not hero.dressingUpQueued and not obj.item.done) then
--'print("levelDesc.onClickToStartDressing(event, obj)")
		hero.dressingUpQueued = true
		level:getObject("edward").clickable = false
		hero:addTask({class="CallTask", func=function()
			if (hero.dressingUpQueued) then
				hero.dressingUp = true
				local emily_dress = level:getObject("emily_dress")
				taskSystem:createSequentialAnimation({
					{class="SetTask", positionLock=obj, actor=hero},
					{class="WalkToTask", target=emily_dress.floaterPosition, wait=true, actor=hero, newAnimationWalkSpeed=hero.curWalkSpeed},
					{class="SetTask", hasPutOnDress=true, actor=hero},
					{class="EmotionTask", emotion= "", actor=level:getObject("edward")},
					{class="PlayAnimationTask", animation="weardress", cycles=1, whenFinished="stay", actor=hero, wait=true},
					{class="SetTask", visible=false, actor=hero},
					{class="SetTask", visible=true, actor=emily_dress},
					{class="PlayAnimationTask", animation="sewing", cycles=-1, whenFinished="stay", actor=level:getObject("edward")},
					{class="WorkTask", target=obj, actor=hero},
				}, "dressing_up", false, {hero,})
			end
		end})
	end
	return true
end

function levelDesc.event_onWorkStart(self, obj, task)
	level:getObject("edward").selected = false
end

function levelDesc.event_onWorkFinish(self, obj, task)
	if (hero.dressingUp == true) then
--'print("levelDesc.event_onWorkFinish()")

		taskSystem:removeAnimation("dressing_up")

		level:getObject("edward"):playDefaultAnimation()
		level:getObject("edward").selected = false
		level:getObject("emily_dress").visible = false
		hero.visible = true
		--hero:addTask({class="PlayAnimationTask", animation="weardress", whenFinished="default", cycles=1, wait=true, reversed=true})

		hero.hasPutOnDress = false
		hero.dressingUp = false
		hero.dressingUpQueued = false
	end
end

function levelDesc.beforeAddWorkTaskOnClick(self, obj, actor)
	if (actor == hero) then
		level:getObject("edward").selected = false
		level:getObject("edward").clickable = true
		if (hero.dressingUp == true) then
--'print("levelDesc.beforeAddWorkTaskOnClick()")

			taskSystem:removeAnimation("dressing_up")

			level:getObject("emily_dress").visible = false
			hero.visible = true

			if (hero.hasPutOnDress) then
				hero:addTask({class="PlayAnimationTask", animation="weardress", whenFinished="stay", cycles=1, wait=true, reversed=true})
				hero:addTask({class="CallTask", func=function()
					local edward = level:getObject("edward")
					edward.emotion = "holddress"
					edward:playDefaultAnimation()
					edward.clickable = true
				end,})
			end

			hero.dressingUp = false
			hero.hasPutOnDress = false
			hero.dressingUpQueued = false
		elseif (hero.dressingUpQueued == true) then
			hero.dressingUp = false
			hero.hasPutOnDress = false
			hero.dressingUpQueued = false
		end
	end
end

function levelDesc.event_onWorkCancel(self, obj, task)
--'print("levelDesc.event_onWorkCancel()")
	hero.dressingUp = false
	hero.hasPutOnDress = false
	hero.dressingUpQueued = false
	level:getObject("edward").selected = false
end
